/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResources;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamRef;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamRefBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamRefFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ValidatingAdmissionPolicyBindingSpecFluent<A extends ValidatingAdmissionPolicyBindingSpecFluent<A>>
extends BaseFluent<A> {
    private MatchResourcesBuilder matchResources;
    private ParamRefBuilder paramRef;
    private String policyName;
    private List<String> validationActions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ValidatingAdmissionPolicyBindingSpecFluent() {
    }

    public ValidatingAdmissionPolicyBindingSpecFluent(ValidatingAdmissionPolicyBindingSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ValidatingAdmissionPolicyBindingSpec instance) {
        ValidatingAdmissionPolicyBindingSpec validatingAdmissionPolicyBindingSpec = instance = instance != null ? instance : new ValidatingAdmissionPolicyBindingSpec();
        if (instance != null) {
            this.withMatchResources(instance.getMatchResources());
            this.withParamRef(instance.getParamRef());
            this.withPolicyName(instance.getPolicyName());
            this.withValidationActions(instance.getValidationActions());
            this.withMatchResources(instance.getMatchResources());
            this.withParamRef(instance.getParamRef());
            this.withPolicyName(instance.getPolicyName());
            this.withValidationActions(instance.getValidationActions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MatchResources buildMatchResources() {
        return this.matchResources != null ? this.matchResources.build() : null;
    }

    public A withMatchResources(MatchResources matchResources) {
        this._visitables.remove((Object)this.matchResources);
        if (matchResources != null) {
            this.matchResources = new MatchResourcesBuilder(matchResources);
            this._visitables.get((Object)"matchResources").add(this.matchResources);
        } else {
            this.matchResources = null;
            this._visitables.get((Object)"matchResources").remove((Object)this.matchResources);
        }
        return (A)((Object)this);
    }

    public boolean hasMatchResources() {
        return this.matchResources != null;
    }

    public MatchResourcesNested<A> withNewMatchResources() {
        return new MatchResourcesNested(null);
    }

    public MatchResourcesNested<A> withNewMatchResourcesLike(MatchResources item) {
        return new MatchResourcesNested(item);
    }

    public MatchResourcesNested<A> editMatchResources() {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(null));
    }

    public MatchResourcesNested<A> editOrNewMatchResources() {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(new MatchResourcesBuilder().build()));
    }

    public MatchResourcesNested<A> editOrNewMatchResourcesLike(MatchResources item) {
        return this.withNewMatchResourcesLike(Optional.ofNullable(this.buildMatchResources()).orElse(item));
    }

    public ParamRef buildParamRef() {
        return this.paramRef != null ? this.paramRef.build() : null;
    }

    public A withParamRef(ParamRef paramRef) {
        this._visitables.remove((Object)this.paramRef);
        if (paramRef != null) {
            this.paramRef = new ParamRefBuilder(paramRef);
            this._visitables.get((Object)"paramRef").add(this.paramRef);
        } else {
            this.paramRef = null;
            this._visitables.get((Object)"paramRef").remove((Object)this.paramRef);
        }
        return (A)((Object)this);
    }

    public boolean hasParamRef() {
        return this.paramRef != null;
    }

    public ParamRefNested<A> withNewParamRef() {
        return new ParamRefNested(null);
    }

    public ParamRefNested<A> withNewParamRefLike(ParamRef item) {
        return new ParamRefNested(item);
    }

    public ParamRefNested<A> editParamRef() {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(null));
    }

    public ParamRefNested<A> editOrNewParamRef() {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(new ParamRefBuilder().build()));
    }

    public ParamRefNested<A> editOrNewParamRefLike(ParamRef item) {
        return this.withNewParamRefLike(Optional.ofNullable(this.buildParamRef()).orElse(item));
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public A withPolicyName(String policyName) {
        this.policyName = policyName;
        return (A)((Object)this);
    }

    public boolean hasPolicyName() {
        return this.policyName != null;
    }

    public A addToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.add(index, item);
        return (A)((Object)this);
    }

    public A setToValidationActions(int index, String item) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        this.validationActions.set(index, item);
        return (A)((Object)this);
    }

    public A addToValidationActions(String ... items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToValidationActions(Collection<String> items) {
        if (this.validationActions == null) {
            this.validationActions = new ArrayList<String>();
        }
        for (String item : items) {
            this.validationActions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromValidationActions(String ... items) {
        if (this.validationActions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.validationActions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValidationActions(Collection<String> items) {
        if (this.validationActions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.validationActions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getValidationActions() {
        return this.validationActions;
    }

    public String getValidationAction(int index) {
        return this.validationActions.get(index);
    }

    public String getFirstValidationAction() {
        return this.validationActions.get(0);
    }

    public String getLastValidationAction() {
        return this.validationActions.get(this.validationActions.size() - 1);
    }

    public String getMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingValidationAction(Predicate<String> predicate) {
        for (String item : this.validationActions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withValidationActions(List<String> validationActions) {
        if (validationActions != null) {
            this.validationActions = new ArrayList<String>();
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        } else {
            this.validationActions = null;
        }
        return (A)((Object)this);
    }

    public A withValidationActions(String ... validationActions) {
        if (this.validationActions != null) {
            this.validationActions.clear();
            this._visitables.remove((Object)"validationActions");
        }
        if (validationActions != null) {
            for (String item : validationActions) {
                this.addToValidationActions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasValidationActions() {
        return this.validationActions != null && !this.validationActions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingAdmissionPolicyBindingSpecFluent that = (ValidatingAdmissionPolicyBindingSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.matchResources, (Object)that.matchResources)) {
            return false;
        }
        if (!Objects.equals((Object)this.paramRef, (Object)that.paramRef)) {
            return false;
        }
        if (!Objects.equals(this.policyName, that.policyName)) {
            return false;
        }
        if (!Objects.equals(this.validationActions, that.validationActions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.matchResources, this.paramRef, this.policyName, this.validationActions, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchResources != null) {
            sb.append("matchResources:");
            sb.append((Object)((Object)this.matchResources) + ",");
        }
        if (this.paramRef != null) {
            sb.append("paramRef:");
            sb.append((Object)((Object)this.paramRef) + ",");
        }
        if (this.policyName != null) {
            sb.append("policyName:");
            sb.append(this.policyName + ",");
        }
        if (this.validationActions != null && !this.validationActions.isEmpty()) {
            sb.append("validationActions:");
            sb.append(this.validationActions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParamRefNested<N>
    extends ParamRefFluent<ParamRefNested<N>>
    implements Nested<N> {
        ParamRefBuilder builder;

        ParamRefNested(ParamRef item) {
            this.builder = new ParamRefBuilder(this, item);
        }

        public N and() {
            return (N)ValidatingAdmissionPolicyBindingSpecFluent.this.withParamRef(this.builder.build());
        }

        public N endParamRef() {
            return this.and();
        }
    }

    public class MatchResourcesNested<N>
    extends MatchResourcesFluent<MatchResourcesNested<N>>
    implements Nested<N> {
        MatchResourcesBuilder builder;

        MatchResourcesNested(MatchResources item) {
            this.builder = new MatchResourcesBuilder(this, item);
        }

        public N and() {
            return (N)ValidatingAdmissionPolicyBindingSpecFluent.this.withMatchResources(this.builder.build());
        }

        public N endMatchResources() {
            return this.and();
        }
    }
}

