package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NonResourceRuleBuilder extends NonResourceRuleFluent<NonResourceRuleBuilder> implements VisitableBuilder<NonResourceRule,NonResourceRuleBuilder>{
  public NonResourceRuleBuilder() {
    this(new NonResourceRule());
  }
  
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent) {
    this(fluent, new NonResourceRule());
  }
  
  public NonResourceRuleBuilder(NonResourceRuleFluent<?> fluent,NonResourceRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NonResourceRuleBuilder(NonResourceRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NonResourceRuleFluent<?> fluent;
  
  public NonResourceRule build() {
    NonResourceRule buildable = new NonResourceRule(fluent.getNonResourceURLs(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}