
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.version.Info;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "BaseKubernetesList",
    "CreateOptions",
    "CustomResourceDefinition",
    "CustomResourceDefinitionCondition",
    "CustomResourceDefinitionList",
    "CustomResourceDefinitionNames",
    "CustomResourceDefinitionSpec",
    "CustomResourceDefinitionStatus",
    "DeleteOptions",
    "GetOptions",
    "Info",
    "JSONSchemaPropsOrStringArray",
    "ListOptions",
    "ObjectMeta",
    "ObjectReference",
    "Patch",
    "PatchOptions",
    "Quantity",
    "RootPaths",
    "Status",
    "Time",
    "TypeMeta",
    "UpdateOptions",
    "V1CustomResourceDefinition",
    "V1CustomResourceDefinitionCondition",
    "V1CustomResourceDefinitionList",
    "V1CustomResourceDefinitionNames",
    "V1CustomResourceDefinitionSpec",
    "V1CustomResourceDefinitionStatus",
    "V1JSONSchemaPropsOrStringArray"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CreateOptions")
    private CreateOptions createOptions;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinition")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition customResourceDefinition;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinitionCondition")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition customResourceDefinitionCondition;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinitionList")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList customResourceDefinitionList;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinitionNames")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames customResourceDefinitionNames;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinitionSpec")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec customResourceDefinitionSpec;
    /**
     * 
     * 
     */
    @JsonProperty("CustomResourceDefinitionStatus")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus customResourceDefinitionStatus;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("GetOptions")
    private GetOptions getOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("JSONSchemaPropsOrStringArray")
    private io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray jSONSchemaPropsOrStringArray;
    /**
     * 
     * 
     */
    @JsonProperty("ListOptions")
    private ListOptions listOptions;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectReference")
    private io.fabric8.kubernetes.api.model.ObjectReference objectReference;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PatchOptions")
    private PatchOptions patchOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    /**
     * 
     * 
     */
    @JsonProperty("UpdateOptions")
    private UpdateOptions updateOptions;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinition")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition v1CustomResourceDefinition;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinitionCondition")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition v1CustomResourceDefinitionCondition;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinitionList")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList v1CustomResourceDefinitionList;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinitionNames")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames v1CustomResourceDefinitionNames;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinitionSpec")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec;
    /**
     * 
     * 
     */
    @JsonProperty("V1CustomResourceDefinitionStatus")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus v1CustomResourceDefinitionStatus;
    /**
     * 
     * 
     */
    @JsonProperty("V1JSONSchemaPropsOrStringArray")
    private io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray v1JSONSchemaPropsOrStringArray;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param listOptions
     * @param aPIGroupList
     * @param baseKubernetesList
     * @param customResourceDefinitionSpec
     * @param updateOptions
     * @param v1CustomResourceDefinitionList
     * @param v1JSONSchemaPropsOrStringArray
     * @param v1CustomResourceDefinitionCondition
     * @param patch
     * @param v1CustomResourceDefinition
     * @param customResourceDefinition
     * @param v1CustomResourceDefinitionNames
     * @param rootPaths
     * @param info
     * @param patchOptions
     * @param deleteOptions
     * @param quantity
     * @param objectReference
     * @param jSONSchemaPropsOrStringArray
     * @param v1CustomResourceDefinitionStatus
     * @param v1CustomResourceDefinitionSpec
     * @param createOptions
     * @param aPIGroup
     * @param customResourceDefinitionList
     * @param customResourceDefinitionNames
     * @param typeMeta
     * @param customResourceDefinitionCondition
     * @param objectMeta
     * @param customResourceDefinitionStatus
     * @param getOptions
     * @param time
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, BaseKubernetesList baseKubernetesList, CreateOptions createOptions, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition customResourceDefinition, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition customResourceDefinitionCondition, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList customResourceDefinitionList, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames customResourceDefinitionNames, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec customResourceDefinitionSpec, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus customResourceDefinitionStatus, DeleteOptions deleteOptions, GetOptions getOptions, Info info, io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray jSONSchemaPropsOrStringArray, ListOptions listOptions, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, io.fabric8.kubernetes.api.model.ObjectReference objectReference, Patch patch, PatchOptions patchOptions, Quantity quantity, RootPaths rootPaths, Status status, String time, TypeMeta typeMeta, UpdateOptions updateOptions, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition v1CustomResourceDefinition, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition v1CustomResourceDefinitionCondition, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList v1CustomResourceDefinitionList, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames v1CustomResourceDefinitionNames, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus v1CustomResourceDefinitionStatus, io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray v1JSONSchemaPropsOrStringArray) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.baseKubernetesList = baseKubernetesList;
        this.createOptions = createOptions;
        this.customResourceDefinition = customResourceDefinition;
        this.customResourceDefinitionCondition = customResourceDefinitionCondition;
        this.customResourceDefinitionList = customResourceDefinitionList;
        this.customResourceDefinitionNames = customResourceDefinitionNames;
        this.customResourceDefinitionSpec = customResourceDefinitionSpec;
        this.customResourceDefinitionStatus = customResourceDefinitionStatus;
        this.deleteOptions = deleteOptions;
        this.getOptions = getOptions;
        this.info = info;
        this.jSONSchemaPropsOrStringArray = jSONSchemaPropsOrStringArray;
        this.listOptions = listOptions;
        this.objectMeta = objectMeta;
        this.objectReference = objectReference;
        this.patch = patch;
        this.patchOptions = patchOptions;
        this.quantity = quantity;
        this.rootPaths = rootPaths;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
        this.updateOptions = updateOptions;
        this.v1CustomResourceDefinition = v1CustomResourceDefinition;
        this.v1CustomResourceDefinitionCondition = v1CustomResourceDefinitionCondition;
        this.v1CustomResourceDefinitionList = v1CustomResourceDefinitionList;
        this.v1CustomResourceDefinitionNames = v1CustomResourceDefinitionNames;
        this.v1CustomResourceDefinitionSpec = v1CustomResourceDefinitionSpec;
        this.v1CustomResourceDefinitionStatus = v1CustomResourceDefinitionStatus;
        this.v1JSONSchemaPropsOrStringArray = v1JSONSchemaPropsOrStringArray;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The createOptions
     */
    @JsonProperty("CreateOptions")
    public CreateOptions getCreateOptions() {
        return createOptions;
    }

    /**
     * 
     * 
     * @param createOptions
     *     The CreateOptions
     */
    @JsonProperty("CreateOptions")
    public void setCreateOptions(CreateOptions createOptions) {
        this.createOptions = createOptions;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinition
     */
    @JsonProperty("CustomResourceDefinition")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition getCustomResourceDefinition() {
        return customResourceDefinition;
    }

    /**
     * 
     * 
     * @param customResourceDefinition
     *     The CustomResourceDefinition
     */
    @JsonProperty("CustomResourceDefinition")
    public void setCustomResourceDefinition(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition customResourceDefinition) {
        this.customResourceDefinition = customResourceDefinition;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinitionCondition
     */
    @JsonProperty("CustomResourceDefinitionCondition")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition getCustomResourceDefinitionCondition() {
        return customResourceDefinitionCondition;
    }

    /**
     * 
     * 
     * @param customResourceDefinitionCondition
     *     The CustomResourceDefinitionCondition
     */
    @JsonProperty("CustomResourceDefinitionCondition")
    public void setCustomResourceDefinitionCondition(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionCondition customResourceDefinitionCondition) {
        this.customResourceDefinitionCondition = customResourceDefinitionCondition;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinitionList
     */
    @JsonProperty("CustomResourceDefinitionList")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList getCustomResourceDefinitionList() {
        return customResourceDefinitionList;
    }

    /**
     * 
     * 
     * @param customResourceDefinitionList
     *     The CustomResourceDefinitionList
     */
    @JsonProperty("CustomResourceDefinitionList")
    public void setCustomResourceDefinitionList(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionList customResourceDefinitionList) {
        this.customResourceDefinitionList = customResourceDefinitionList;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinitionNames
     */
    @JsonProperty("CustomResourceDefinitionNames")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames getCustomResourceDefinitionNames() {
        return customResourceDefinitionNames;
    }

    /**
     * 
     * 
     * @param customResourceDefinitionNames
     *     The CustomResourceDefinitionNames
     */
    @JsonProperty("CustomResourceDefinitionNames")
    public void setCustomResourceDefinitionNames(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionNames customResourceDefinitionNames) {
        this.customResourceDefinitionNames = customResourceDefinitionNames;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinitionSpec
     */
    @JsonProperty("CustomResourceDefinitionSpec")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec getCustomResourceDefinitionSpec() {
        return customResourceDefinitionSpec;
    }

    /**
     * 
     * 
     * @param customResourceDefinitionSpec
     *     The CustomResourceDefinitionSpec
     */
    @JsonProperty("CustomResourceDefinitionSpec")
    public void setCustomResourceDefinitionSpec(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpec customResourceDefinitionSpec) {
        this.customResourceDefinitionSpec = customResourceDefinitionSpec;
    }

    /**
     * 
     * 
     * @return
     *     The customResourceDefinitionStatus
     */
    @JsonProperty("CustomResourceDefinitionStatus")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus getCustomResourceDefinitionStatus() {
        return customResourceDefinitionStatus;
    }

    /**
     * 
     * 
     * @param customResourceDefinitionStatus
     *     The CustomResourceDefinitionStatus
     */
    @JsonProperty("CustomResourceDefinitionStatus")
    public void setCustomResourceDefinitionStatus(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionStatus customResourceDefinitionStatus) {
        this.customResourceDefinitionStatus = customResourceDefinitionStatus;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The getOptions
     */
    @JsonProperty("GetOptions")
    public GetOptions getGetOptions() {
        return getOptions;
    }

    /**
     * 
     * 
     * @param getOptions
     *     The GetOptions
     */
    @JsonProperty("GetOptions")
    public void setGetOptions(GetOptions getOptions) {
        this.getOptions = getOptions;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The jSONSchemaPropsOrStringArray
     */
    @JsonProperty("JSONSchemaPropsOrStringArray")
    public io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray getJSONSchemaPropsOrStringArray() {
        return jSONSchemaPropsOrStringArray;
    }

    /**
     * 
     * 
     * @param jSONSchemaPropsOrStringArray
     *     The JSONSchemaPropsOrStringArray
     */
    @JsonProperty("JSONSchemaPropsOrStringArray")
    public void setJSONSchemaPropsOrStringArray(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray jSONSchemaPropsOrStringArray) {
        this.jSONSchemaPropsOrStringArray = jSONSchemaPropsOrStringArray;
    }

    /**
     * 
     * 
     * @return
     *     The listOptions
     */
    @JsonProperty("ListOptions")
    public ListOptions getListOptions() {
        return listOptions;
    }

    /**
     * 
     * 
     * @param listOptions
     *     The ListOptions
     */
    @JsonProperty("ListOptions")
    public void setListOptions(ListOptions listOptions) {
        this.listOptions = listOptions;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The objectReference
     */
    @JsonProperty("ObjectReference")
    public io.fabric8.kubernetes.api.model.ObjectReference getObjectReference() {
        return objectReference;
    }

    /**
     * 
     * 
     * @param objectReference
     *     The ObjectReference
     */
    @JsonProperty("ObjectReference")
    public void setObjectReference(io.fabric8.kubernetes.api.model.ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The patchOptions
     */
    @JsonProperty("PatchOptions")
    public PatchOptions getPatchOptions() {
        return patchOptions;
    }

    /**
     * 
     * 
     * @param patchOptions
     *     The PatchOptions
     */
    @JsonProperty("PatchOptions")
    public void setPatchOptions(PatchOptions patchOptions) {
        this.patchOptions = patchOptions;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The updateOptions
     */
    @JsonProperty("UpdateOptions")
    public UpdateOptions getUpdateOptions() {
        return updateOptions;
    }

    /**
     * 
     * 
     * @param updateOptions
     *     The UpdateOptions
     */
    @JsonProperty("UpdateOptions")
    public void setUpdateOptions(UpdateOptions updateOptions) {
        this.updateOptions = updateOptions;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinition
     */
    @JsonProperty("V1CustomResourceDefinition")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition getV1CustomResourceDefinition() {
        return v1CustomResourceDefinition;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinition
     *     The V1CustomResourceDefinition
     */
    @JsonProperty("V1CustomResourceDefinition")
    public void setV1CustomResourceDefinition(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition v1CustomResourceDefinition) {
        this.v1CustomResourceDefinition = v1CustomResourceDefinition;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinitionCondition
     */
    @JsonProperty("V1CustomResourceDefinitionCondition")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition getV1CustomResourceDefinitionCondition() {
        return v1CustomResourceDefinitionCondition;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinitionCondition
     *     The V1CustomResourceDefinitionCondition
     */
    @JsonProperty("V1CustomResourceDefinitionCondition")
    public void setV1CustomResourceDefinitionCondition(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionCondition v1CustomResourceDefinitionCondition) {
        this.v1CustomResourceDefinitionCondition = v1CustomResourceDefinitionCondition;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinitionList
     */
    @JsonProperty("V1CustomResourceDefinitionList")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList getV1CustomResourceDefinitionList() {
        return v1CustomResourceDefinitionList;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinitionList
     *     The V1CustomResourceDefinitionList
     */
    @JsonProperty("V1CustomResourceDefinitionList")
    public void setV1CustomResourceDefinitionList(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionList v1CustomResourceDefinitionList) {
        this.v1CustomResourceDefinitionList = v1CustomResourceDefinitionList;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinitionNames
     */
    @JsonProperty("V1CustomResourceDefinitionNames")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames getV1CustomResourceDefinitionNames() {
        return v1CustomResourceDefinitionNames;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinitionNames
     *     The V1CustomResourceDefinitionNames
     */
    @JsonProperty("V1CustomResourceDefinitionNames")
    public void setV1CustomResourceDefinitionNames(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionNames v1CustomResourceDefinitionNames) {
        this.v1CustomResourceDefinitionNames = v1CustomResourceDefinitionNames;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinitionSpec
     */
    @JsonProperty("V1CustomResourceDefinitionSpec")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec getV1CustomResourceDefinitionSpec() {
        return v1CustomResourceDefinitionSpec;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinitionSpec
     *     The V1CustomResourceDefinitionSpec
     */
    @JsonProperty("V1CustomResourceDefinitionSpec")
    public void setV1CustomResourceDefinitionSpec(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec) {
        this.v1CustomResourceDefinitionSpec = v1CustomResourceDefinitionSpec;
    }

    /**
     * 
     * 
     * @return
     *     The v1CustomResourceDefinitionStatus
     */
    @JsonProperty("V1CustomResourceDefinitionStatus")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus getV1CustomResourceDefinitionStatus() {
        return v1CustomResourceDefinitionStatus;
    }

    /**
     * 
     * 
     * @param v1CustomResourceDefinitionStatus
     *     The V1CustomResourceDefinitionStatus
     */
    @JsonProperty("V1CustomResourceDefinitionStatus")
    public void setV1CustomResourceDefinitionStatus(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionStatus v1CustomResourceDefinitionStatus) {
        this.v1CustomResourceDefinitionStatus = v1CustomResourceDefinitionStatus;
    }

    /**
     * 
     * 
     * @return
     *     The v1JSONSchemaPropsOrStringArray
     */
    @JsonProperty("V1JSONSchemaPropsOrStringArray")
    public io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray getV1JSONSchemaPropsOrStringArray() {
        return v1JSONSchemaPropsOrStringArray;
    }

    /**
     * 
     * 
     * @param v1JSONSchemaPropsOrStringArray
     *     The V1JSONSchemaPropsOrStringArray
     */
    @JsonProperty("V1JSONSchemaPropsOrStringArray")
    public void setV1JSONSchemaPropsOrStringArray(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray v1JSONSchemaPropsOrStringArray) {
        this.v1JSONSchemaPropsOrStringArray = v1JSONSchemaPropsOrStringArray;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
