package io.fabric8.kubernetes.api.model.apiextensions.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceDefinitionNamesFluent<A extends CustomResourceDefinitionNamesFluent<A>> extends Fluent<A> {


    public A addToCategories(int index,String item);
    public A setToCategories(int index,String item);
    public A addToCategories(String... items);
    public A addAllToCategories(Collection<String> items);
    public A removeFromCategories(String... items);
    public A removeAllFromCategories(Collection<String> items);
    public List<String> getCategories();
    public String getCategory(int index);
    public String getFirstCategory();
    public String getLastCategory();
    public String getMatchingCategory(Predicate<String> predicate);
    public Boolean hasMatchingCategory(Predicate<String> predicate);
    public A withCategories(List<String> categories);
    public A withCategories(String... categories);
    public Boolean hasCategories();
    public A addNewCategory(String arg1);
    public A addNewCategory(StringBuilder arg1);
    public A addNewCategory(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getListKind();
    public A withListKind(String listKind);
    public Boolean hasListKind();
    public A withNewListKind(String arg1);
    public A withNewListKind(StringBuilder arg1);
    public A withNewListKind(StringBuffer arg1);
    public String getPlural();
    public A withPlural(String plural);
    public Boolean hasPlural();
    public A withNewPlural(String arg1);
    public A withNewPlural(StringBuilder arg1);
    public A withNewPlural(StringBuffer arg1);
    public A addToShortNames(int index,String item);
    public A setToShortNames(int index,String item);
    public A addToShortNames(String... items);
    public A addAllToShortNames(Collection<String> items);
    public A removeFromShortNames(String... items);
    public A removeAllFromShortNames(Collection<String> items);
    public List<String> getShortNames();
    public String getShortName(int index);
    public String getFirstShortName();
    public String getLastShortName();
    public String getMatchingShortName(Predicate<String> predicate);
    public Boolean hasMatchingShortName(Predicate<String> predicate);
    public A withShortNames(List<String> shortNames);
    public A withShortNames(String... shortNames);
    public Boolean hasShortNames();
    public A addNewShortName(String arg1);
    public A addNewShortName(StringBuilder arg1);
    public A addNewShortName(StringBuffer arg1);
    public String getSingular();
    public A withSingular(String singular);
    public Boolean hasSingular();
    public A withNewSingular(String arg1);
    public A withNewSingular(StringBuilder arg1);
    public A withNewSingular(StringBuffer arg1);
}
