package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceDefinitionSpecFluentImpl<A extends CustomResourceDefinitionSpecFluent<A>> extends BaseFluent<A> implements CustomResourceDefinitionSpecFluent<A>{
  public CustomResourceDefinitionSpecFluentImpl() {
  }
  public CustomResourceDefinitionSpecFluentImpl(CustomResourceDefinitionSpec instance) {
    this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
    this.withConversion(instance.getConversion()); 
    this.withGroup(instance.getGroup()); 
    this.withNames(instance.getNames()); 
    this.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
    this.withScope(instance.getScope()); 
    this.withSubresources(instance.getSubresources()); 
    this.withValidation(instance.getValidation()); 
    this.withVersion(instance.getVersion()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();
  private CustomResourceConversionBuilder conversion;
  private String group;
  private CustomResourceDefinitionNamesBuilder names;
  private Boolean preserveUnknownFields;
  private String scope;
  private CustomResourceSubresourcesBuilder subresources;
  private CustomResourceValidationBuilder validation;
  private String version;
  private ArrayList<CustomResourceDefinitionVersionBuilder> versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAdditionalPrinterColumns(Integer index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(index >= 0 ? index : _visitables.get("additionalPrinterColumns").size(), builder);this.additionalPrinterColumns.add(index >= 0 ? index : additionalPrinterColumns.size(), builder); return (A)this;
  }
  public A setToAdditionalPrinterColumns(Integer index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalPrinterColumns").size()) { _visitables.get("additionalPrinterColumns").add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder);}
    if (index < 0 || index >= additionalPrinterColumns.size()) { additionalPrinterColumns.add(builder); } else { additionalPrinterColumns.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder);if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    if (additionalPrinterColumns == null) return (A) this;
    final Iterator<CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
    final List visitables = _visitables.get("additionalPrinterColumns");
    while (each.hasNext()) {
      CustomResourceColumnDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalPrinterColumns instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
    return additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
    return additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  public CustomResourceColumnDefinition buildAdditionalPrinterColumn(Integer index) {
    return this.additionalPrinterColumns.get(index).build();
  }
  public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(0).build();
  }
  public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
  }
  public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    for (CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    for (CustomResourceColumnDefinitionBuilder item: additionalPrinterColumns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) { _visitables.get("additionalPrinterColumns").removeAll(this.additionalPrinterColumns);}
    if (additionalPrinterColumns != null) {this.additionalPrinterColumns = new ArrayList(); for (CustomResourceColumnDefinition item : additionalPrinterColumns){this.addToAdditionalPrinterColumns(item);}} else { this.additionalPrinterColumns = null;} return (A) this;
  }
  public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {this.additionalPrinterColumns.clear();}
    if (additionalPrinterColumns != null) {for (CustomResourceColumnDefinition item :additionalPrinterColumns){ this.addToAdditionalPrinterColumns(item);}} return (A) this;
  }
  public Boolean hasAdditionalPrinterColumns() {
    return additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty();
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
    return new CustomResourceDefinitionSpecFluentImpl.AdditionalPrinterColumnsNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
    return new CustomResourceDefinitionSpecFluentImpl.AdditionalPrinterColumnsNestedImpl(-1, item);
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(Integer index,CustomResourceColumnDefinition item) {
    return new CustomResourceDefinitionSpecFluentImpl.AdditionalPrinterColumnsNestedImpl(index, item);
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(Integer index) {
    if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
    if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
    int index = additionalPrinterColumns.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  public CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalPrinterColumns.size();i++) { 
    if (predicate.test(additionalPrinterColumns.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  /**
   * This method has been deprecated, please use method buildConversion instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceConversion getConversion() {
    return this.conversion!=null ?this.conversion.build():null;
  }
  public CustomResourceConversion buildConversion() {
    return this.conversion!=null ?this.conversion.build():null;
  }
  public A withConversion(CustomResourceConversion conversion) {
    _visitables.get("conversion").remove(this.conversion);
    if (conversion!=null){ this.conversion= new CustomResourceConversionBuilder(conversion); _visitables.get("conversion").add(this.conversion);} else { this.conversion = null; _visitables.get("conversion").remove(this.conversion); } return (A) this;
  }
  public Boolean hasConversion() {
    return this.conversion != null;
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
    return new CustomResourceDefinitionSpecFluentImpl.ConversionNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(CustomResourceConversion item) {
    return new CustomResourceDefinitionSpecFluentImpl.ConversionNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
    return withNewConversionLike(getConversion());
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
    return withNewConversionLike(getConversion() != null ? getConversion(): new CustomResourceConversionBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(CustomResourceConversion item) {
    return withNewConversionLike(getConversion() != null ? getConversion(): item);
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNames instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceDefinitionNames getNames() {
    return this.names!=null ?this.names.build():null;
  }
  public CustomResourceDefinitionNames buildNames() {
    return this.names!=null ?this.names.build():null;
  }
  public A withNames(CustomResourceDefinitionNames names) {
    _visitables.get("names").remove(this.names);
    if (names!=null){ this.names= new CustomResourceDefinitionNamesBuilder(names); _visitables.get("names").add(this.names);} else { this.names = null; _visitables.get("names").remove(this.names); } return (A) this;
  }
  public Boolean hasNames() {
    return this.names != null;
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
    return new CustomResourceDefinitionSpecFluentImpl.NamesNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item) {
    return new CustomResourceDefinitionSpecFluentImpl.NamesNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
    return withNewNamesLike(getNames());
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
    return withNewNamesLike(getNames() != null ? getNames(): new CustomResourceDefinitionNamesBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item) {
    return withNewNamesLike(getNames() != null ? getNames(): item);
  }
  public Boolean getPreserveUnknownFields() {
    return this.preserveUnknownFields;
  }
  public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
    this.preserveUnknownFields=preserveUnknownFields; return (A) this;
  }
  public Boolean hasPreserveUnknownFields() {
    return this.preserveUnknownFields != null;
  }
  public String getScope() {
    return this.scope;
  }
  public A withScope(String scope) {
    this.scope=scope; return (A) this;
  }
  public Boolean hasScope() {
    return this.scope != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSubresources instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceSubresources getSubresources() {
    return this.subresources!=null ?this.subresources.build():null;
  }
  public CustomResourceSubresources buildSubresources() {
    return this.subresources!=null ?this.subresources.build():null;
  }
  public A withSubresources(CustomResourceSubresources subresources) {
    _visitables.get("subresources").remove(this.subresources);
    if (subresources!=null){ this.subresources= new CustomResourceSubresourcesBuilder(subresources); _visitables.get("subresources").add(this.subresources);} else { this.subresources = null; _visitables.get("subresources").remove(this.subresources); } return (A) this;
  }
  public Boolean hasSubresources() {
    return this.subresources != null;
  }
  public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresources() {
    return new CustomResourceDefinitionSpecFluentImpl.SubresourcesNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
    return new CustomResourceDefinitionSpecFluentImpl.SubresourcesNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editSubresources() {
    return withNewSubresourcesLike(getSubresources());
  }
  public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresources() {
    return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): new CustomResourceSubresourcesBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
    return withNewSubresourcesLike(getSubresources() != null ? getSubresources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildValidation instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceValidation getValidation() {
    return this.validation!=null ?this.validation.build():null;
  }
  public CustomResourceValidation buildValidation() {
    return this.validation!=null ?this.validation.build():null;
  }
  public A withValidation(CustomResourceValidation validation) {
    _visitables.get("validation").remove(this.validation);
    if (validation!=null){ this.validation= new CustomResourceValidationBuilder(validation); _visitables.get("validation").add(this.validation);} else { this.validation = null; _visitables.get("validation").remove(this.validation); } return (A) this;
  }
  public Boolean hasValidation() {
    return this.validation != null;
  }
  public CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidation() {
    return new CustomResourceDefinitionSpecFluentImpl.ValidationNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.ValidationNested<A> withNewValidationLike(CustomResourceValidation item) {
    return new CustomResourceDefinitionSpecFluentImpl.ValidationNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.ValidationNested<A> editValidation() {
    return withNewValidationLike(getValidation());
  }
  public CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidation() {
    return withNewValidationLike(getValidation() != null ? getValidation(): new CustomResourceValidationBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.ValidationNested<A> editOrNewValidationLike(CustomResourceValidation item) {
    return withNewValidationLike(getValidation() != null ? getValidation(): item);
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToVersions(Integer index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(Integer index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(Collection<CustomResourceDefinitionVersion> items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(Collection<CustomResourceDefinitionVersion> items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<CustomResourceDefinitionVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      CustomResourceDefinitionVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CustomResourceDefinitionVersion> getVersions() {
    return versions != null ? build(versions) : null;
  }
  public List<CustomResourceDefinitionVersion> buildVersions() {
    return versions != null ? build(versions) : null;
  }
  public CustomResourceDefinitionVersion buildVersion(Integer index) {
    return this.versions.get(index).build();
  }
  public CustomResourceDefinitionVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public CustomResourceDefinitionVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public CustomResourceDefinitionVersion buildMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    for (CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    for (CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(List<CustomResourceDefinitionVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new ArrayList(); for (CustomResourceDefinitionVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (CustomResourceDefinitionVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl(-1, item);
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(Integer index,CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl(index, item);
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomResourceDefinitionSpecFluentImpl that = (CustomResourceDefinitionSpecFluentImpl) o;
    if (additionalPrinterColumns != null ? !additionalPrinterColumns.equals(that.additionalPrinterColumns) :that.additionalPrinterColumns != null) return false;
    if (conversion != null ? !conversion.equals(that.conversion) :that.conversion != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (names != null ? !names.equals(that.names) :that.names != null) return false;
    if (preserveUnknownFields != null ? !preserveUnknownFields.equals(that.preserveUnknownFields) :that.preserveUnknownFields != null) return false;
    if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
    if (subresources != null ? !subresources.equals(that.subresources) :that.subresources != null) return false;
    if (validation != null ? !validation.equals(that.validation) :that.validation != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalPrinterColumns,  conversion,  group,  names,  preserveUnknownFields,  scope,  subresources,  validation,  version,  versions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty()) { sb.append("additionalPrinterColumns:"); sb.append(additionalPrinterColumns + ","); }
    if (conversion != null) { sb.append("conversion:"); sb.append(conversion + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (names != null) { sb.append("names:"); sb.append(names + ","); }
    if (preserveUnknownFields != null) { sb.append("preserveUnknownFields:"); sb.append(preserveUnknownFields + ","); }
    if (scope != null) { sb.append("scope:"); sb.append(scope + ","); }
    if (subresources != null) { sb.append("subresources:"); sb.append(subresources + ","); }
    if (validation != null) { sb.append("validation:"); sb.append(validation + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPreserveUnknownFields() {
    return withPreserveUnknownFields(true);
  }
  class AdditionalPrinterColumnsNestedImpl<N> extends CustomResourceColumnDefinitionFluentImpl<CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>> implements CustomResourceDefinitionSpecFluent.AdditionalPrinterColumnsNested<N>,Nested<N>{
    AdditionalPrinterColumnsNestedImpl(Integer index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    AdditionalPrinterColumnsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceColumnDefinitionBuilder(this);
    }
    CustomResourceColumnDefinitionBuilder builder;
    Integer index;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.setToAdditionalPrinterColumns(index,builder.build());
    }
    public N endAdditionalPrinterColumn() {
      return and();
    }
    
  }
  class ConversionNestedImpl<N> extends CustomResourceConversionFluentImpl<CustomResourceDefinitionSpecFluent.ConversionNested<N>> implements CustomResourceDefinitionSpecFluent.ConversionNested<N>,Nested<N>{
    ConversionNestedImpl(CustomResourceConversion item) {
      this.builder = new CustomResourceConversionBuilder(this, item);
    }
    ConversionNestedImpl() {
      this.builder = new CustomResourceConversionBuilder(this);
    }
    CustomResourceConversionBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withConversion(builder.build());
    }
    public N endConversion() {
      return and();
    }
    
  }
  class NamesNestedImpl<N> extends CustomResourceDefinitionNamesFluentImpl<CustomResourceDefinitionSpecFluent.NamesNested<N>> implements CustomResourceDefinitionSpecFluent.NamesNested<N>,Nested<N>{
    NamesNestedImpl(CustomResourceDefinitionNames item) {
      this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
    }
    NamesNestedImpl() {
      this.builder = new CustomResourceDefinitionNamesBuilder(this);
    }
    CustomResourceDefinitionNamesBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
    }
    public N endNames() {
      return and();
    }
    
  }
  class SubresourcesNestedImpl<N> extends CustomResourceSubresourcesFluentImpl<CustomResourceDefinitionSpecFluent.SubresourcesNested<N>> implements CustomResourceDefinitionSpecFluent.SubresourcesNested<N>,Nested<N>{
    SubresourcesNestedImpl(CustomResourceSubresources item) {
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    SubresourcesNestedImpl() {
      this.builder = new CustomResourceSubresourcesBuilder(this);
    }
    CustomResourceSubresourcesBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withSubresources(builder.build());
    }
    public N endSubresources() {
      return and();
    }
    
  }
  class ValidationNestedImpl<N> extends CustomResourceValidationFluentImpl<CustomResourceDefinitionSpecFluent.ValidationNested<N>> implements CustomResourceDefinitionSpecFluent.ValidationNested<N>,Nested<N>{
    ValidationNestedImpl(CustomResourceValidation item) {
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    ValidationNestedImpl() {
      this.builder = new CustomResourceValidationBuilder(this);
    }
    CustomResourceValidationBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withValidation(builder.build());
    }
    public N endValidation() {
      return and();
    }
    
  }
  class VersionsNestedImpl<N> extends CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionSpecFluent.VersionsNested<N>> implements CustomResourceDefinitionSpecFluent.VersionsNested<N>,Nested<N>{
    VersionsNestedImpl(Integer index,CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionVersionBuilder(this);
    }
    CustomResourceDefinitionVersionBuilder builder;
    Integer index;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}