package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceConversionBuilder extends CustomResourceConversionFluentImpl<CustomResourceConversionBuilder> implements VisitableBuilder<CustomResourceConversion,CustomResourceConversionBuilder>{
  public CustomResourceConversionBuilder() {
    this(false);
  }
  public CustomResourceConversionBuilder(Boolean validationEnabled) {
    this(new CustomResourceConversion(), validationEnabled);
  }
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceConversion(), validationEnabled);
  }
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent,CustomResourceConversion instance) {
    this(fluent, instance, false);
  }
  public CustomResourceConversionBuilder(CustomResourceConversionFluent<?> fluent,CustomResourceConversion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConversionReviewVersions(instance.getConversionReviewVersions()); 
    fluent.withStrategy(instance.getStrategy()); 
    fluent.withWebhookClientConfig(instance.getWebhookClientConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceConversionBuilder(CustomResourceConversion instance) {
    this(instance,false);
  }
  public CustomResourceConversionBuilder(CustomResourceConversion instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
    this.withStrategy(instance.getStrategy()); 
    this.withWebhookClientConfig(instance.getWebhookClientConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomResourceConversionFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceConversion build() {
    CustomResourceConversion buildable = new CustomResourceConversion(fluent.getConversionReviewVersions(),fluent.getStrategy(),fluent.getWebhookClientConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}