package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>> extends BaseFluent<A> implements CustomResourceConversionFluent<A>{
  public CustomResourceConversionFluentImpl() {
  }
  public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
    this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
    this.withStrategy(instance.getStrategy()); 
    this.withWebhookClientConfig(instance.getWebhookClientConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> conversionReviewVersions = new ArrayList<String>();
  private String strategy;
  private WebhookClientConfigBuilder webhookClientConfig;
  private Map<String,Object> additionalProperties;
  public A addToConversionReviewVersions(Integer index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.add(index, item);
    return (A)this;
  }
  public A setToConversionReviewVersions(Integer index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.set(index, item); return (A)this;
  }
  public A addToConversionReviewVersions(java.lang.String... items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  public A addAllToConversionReviewVersions(Collection<String> items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  public A removeFromConversionReviewVersions(java.lang.String... items) {
    for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromConversionReviewVersions(Collection<String> items) {
    for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
  }
  public List<String> getConversionReviewVersions() {
    return this.conversionReviewVersions;
  }
  public String getConversionReviewVersion(Integer index) {
    return this.conversionReviewVersions.get(index);
  }
  public String getFirstConversionReviewVersion() {
    return this.conversionReviewVersions.get(0);
  }
  public String getLastConversionReviewVersion() {
    return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
  }
  public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConversionReviewVersions(List<String> conversionReviewVersions) {
    if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
  }
  public A withConversionReviewVersions(java.lang.String... conversionReviewVersions) {
    if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear();}
    if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
  }
  public Boolean hasConversionReviewVersions() {
    return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
  }
  public String getStrategy() {
    return this.strategy;
  }
  public A withStrategy(String strategy) {
    this.strategy=strategy; return (A) this;
  }
  public Boolean hasStrategy() {
    return this.strategy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildWebhookClientConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebhookClientConfig getWebhookClientConfig() {
    return this.webhookClientConfig!=null ?this.webhookClientConfig.build():null;
  }
  public WebhookClientConfig buildWebhookClientConfig() {
    return this.webhookClientConfig!=null ?this.webhookClientConfig.build():null;
  }
  public A withWebhookClientConfig(WebhookClientConfig webhookClientConfig) {
    _visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
    if (webhookClientConfig!=null){ this.webhookClientConfig= new WebhookClientConfigBuilder(webhookClientConfig); _visitables.get("webhookClientConfig").add(this.webhookClientConfig);} else { this.webhookClientConfig = null; _visitables.get("webhookClientConfig").remove(this.webhookClientConfig); } return (A) this;
  }
  public Boolean hasWebhookClientConfig() {
    return this.webhookClientConfig != null;
  }
  public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig() {
    return new CustomResourceConversionFluentImpl.WebhookClientConfigNestedImpl();
  }
  public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(WebhookClientConfig item) {
    return new CustomResourceConversionFluentImpl.WebhookClientConfigNestedImpl(item);
  }
  public CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig() {
    return withNewWebhookClientConfigLike(getWebhookClientConfig());
  }
  public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
    return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): new WebhookClientConfigBuilder().build());
  }
  public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(WebhookClientConfig item) {
    return withNewWebhookClientConfigLike(getWebhookClientConfig() != null ? getWebhookClientConfig(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl) o;
    if (conversionReviewVersions != null ? !conversionReviewVersions.equals(that.conversionReviewVersions) :that.conversionReviewVersions != null) return false;
    if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
    if (webhookClientConfig != null ? !webhookClientConfig.equals(that.webhookClientConfig) :that.webhookClientConfig != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conversionReviewVersions,  strategy,  webhookClientConfig,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conversionReviewVersions != null && !conversionReviewVersions.isEmpty()) { sb.append("conversionReviewVersions:"); sb.append(conversionReviewVersions + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (webhookClientConfig != null) { sb.append("webhookClientConfig:"); sb.append(webhookClientConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class WebhookClientConfigNestedImpl<N> extends WebhookClientConfigFluentImpl<CustomResourceConversionFluent.WebhookClientConfigNested<N>> implements CustomResourceConversionFluent.WebhookClientConfigNested<N>,Nested<N>{
    WebhookClientConfigNestedImpl(WebhookClientConfig item) {
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    WebhookClientConfigNestedImpl() {
      this.builder = new WebhookClientConfigBuilder(this);
    }
    WebhookClientConfigBuilder builder;
    public N and() {
      return (N) CustomResourceConversionFluentImpl.this.withWebhookClientConfig(builder.build());
    }
    public N endWebhookClientConfig() {
      return and();
    }
    
  }
  
}