package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JSONSchemaPropsFluentImpl<A extends JSONSchemaPropsFluent<A>> extends BaseFluent<A> implements JSONSchemaPropsFluent<A>{
  public JSONSchemaPropsFluentImpl() {
  }
  public JSONSchemaPropsFluentImpl(JSONSchemaProps instance) {
    this.withRef(instance.get$ref()); 
    this.withSchema(instance.get$schema()); 
    this.withAdditionalItems(instance.getAdditionalItems()); 
    this.withAdditionalProperties(instance.getAdditionalProperties()); 
    this.withAllOf(instance.getAllOf()); 
    this.withAnyOf(instance.getAnyOf()); 
    this.withDefault(instance.getDefault()); 
    this.withDefinitions(instance.getDefinitions()); 
    this.withDependencies(instance.getDependencies()); 
    this.withDescription(instance.getDescription()); 
    this.withEnum(instance.getEnum()); 
    this.withExample(instance.getExample()); 
    this.withExclusiveMaximum(instance.getExclusiveMaximum()); 
    this.withExclusiveMinimum(instance.getExclusiveMinimum()); 
    this.withExternalDocs(instance.getExternalDocs()); 
    this.withFormat(instance.getFormat()); 
    this.withId(instance.getId()); 
    this.withItems(instance.getItems()); 
    this.withMaxItems(instance.getMaxItems()); 
    this.withMaxLength(instance.getMaxLength()); 
    this.withMaxProperties(instance.getMaxProperties()); 
    this.withMaximum(instance.getMaximum()); 
    this.withMinItems(instance.getMinItems()); 
    this.withMinLength(instance.getMinLength()); 
    this.withMinProperties(instance.getMinProperties()); 
    this.withMinimum(instance.getMinimum()); 
    this.withMultipleOf(instance.getMultipleOf()); 
    this.withNot(instance.getNot()); 
    this.withNullable(instance.getNullable()); 
    this.withOneOf(instance.getOneOf()); 
    this.withPattern(instance.getPattern()); 
    this.withPatternProperties(instance.getPatternProperties()); 
    this.withProperties(instance.getProperties()); 
    this.withRequired(instance.getRequired()); 
    this.withTitle(instance.getTitle()); 
    this.withType(instance.getType()); 
    this.withUniqueItems(instance.getUniqueItems()); 
    this.withXKubernetesEmbeddedResource(instance.getXKubernetesEmbeddedResource()); 
    this.withXKubernetesIntOrString(instance.getXKubernetesIntOrString()); 
    this.withXKubernetesListMapKeys(instance.getXKubernetesListMapKeys()); 
    this.withXKubernetesListType(instance.getXKubernetesListType()); 
    this.withXKubernetesMapType(instance.getXKubernetesMapType()); 
    this.withXKubernetesPreserveUnknownFields(instance.getXKubernetesPreserveUnknownFields()); 
    this.withXKubernetesValidations(instance.getXKubernetesValidations()); 
  }
  private String $ref;
  private String $schema;
  private JSONSchemaPropsOrBoolBuilder additionalItems;
  private JSONSchemaPropsOrBoolBuilder additionalProperties;
  private ArrayList<JSONSchemaPropsBuilder> allOf = new ArrayList<JSONSchemaPropsBuilder>();
  private ArrayList<JSONSchemaPropsBuilder> anyOf = new ArrayList<JSONSchemaPropsBuilder>();
  private JsonNode _default;
  private Map<String,JSONSchemaProps> definitions;
  private Map<String,JSONSchemaPropsOrStringArray> dependencies;
  private String description;
  private List<JsonNode> _enum = new ArrayList<JsonNode>();
  private JsonNode example;
  private Boolean exclusiveMaximum;
  private Boolean exclusiveMinimum;
  private ExternalDocumentationBuilder externalDocs;
  private String format;
  private String id;
  private JSONSchemaPropsOrArrayBuilder items;
  private Long maxItems;
  private Long maxLength;
  private Long maxProperties;
  private Double maximum;
  private Long minItems;
  private Long minLength;
  private Long minProperties;
  private Double minimum;
  private Double multipleOf;
  private JSONSchemaPropsBuilder not;
  private Boolean nullable;
  private ArrayList<JSONSchemaPropsBuilder> oneOf = new ArrayList<JSONSchemaPropsBuilder>();
  private String pattern;
  private Map<String,JSONSchemaProps> patternProperties;
  private Map<String,JSONSchemaProps> properties;
  private List<String> required = new ArrayList<String>();
  private String title;
  private String type;
  private Boolean uniqueItems;
  private Boolean xKubernetesEmbeddedResource;
  private Boolean xKubernetesIntOrString;
  private List<String> xKubernetesListMapKeys = new ArrayList<String>();
  private String xKubernetesListType;
  private String xKubernetesMapType;
  private Boolean xKubernetesPreserveUnknownFields;
  private ArrayList<ValidationRuleBuilder> xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();
  public String getRef() {
    return this.$ref;
  }
  public A withRef(String $ref) {
    this.$ref=$ref; return (A) this;
  }
  public Boolean hasRef() {
    return this.$ref != null;
  }
  public String getSchema() {
    return this.$schema;
  }
  public A withSchema(String $schema) {
    this.$schema=$schema; return (A) this;
  }
  public Boolean hasSchema() {
    return this.$schema != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaPropsOrBool getAdditionalItems() {
    return this.additionalItems!=null ?this.additionalItems.build():null;
  }
  public JSONSchemaPropsOrBool buildAdditionalItems() {
    return this.additionalItems!=null ?this.additionalItems.build():null;
  }
  public A withAdditionalItems(JSONSchemaPropsOrBool additionalItems) {
    _visitables.get("additionalItems").remove(this.additionalItems);
    if (additionalItems!=null){ this.additionalItems= new JSONSchemaPropsOrBoolBuilder(additionalItems); _visitables.get("additionalItems").add(this.additionalItems);} else { this.additionalItems = null; _visitables.get("additionalItems").remove(this.additionalItems); } return (A) this;
  }
  public Boolean hasAdditionalItems() {
    return this.additionalItems != null;
  }
  public JSONSchemaPropsFluent.AdditionalItemsNested<A> withNewAdditionalItems() {
    return new JSONSchemaPropsFluentImpl.AdditionalItemsNestedImpl();
  }
  public JSONSchemaPropsFluent.AdditionalItemsNested<A> withNewAdditionalItemsLike(JSONSchemaPropsOrBool item) {
    return new JSONSchemaPropsFluentImpl.AdditionalItemsNestedImpl(item);
  }
  public JSONSchemaPropsFluent.AdditionalItemsNested<A> editAdditionalItems() {
    return withNewAdditionalItemsLike(getAdditionalItems());
  }
  public JSONSchemaPropsFluent.AdditionalItemsNested<A> editOrNewAdditionalItems() {
    return withNewAdditionalItemsLike(getAdditionalItems() != null ? getAdditionalItems(): new JSONSchemaPropsOrBoolBuilder().build());
  }
  public JSONSchemaPropsFluent.AdditionalItemsNested<A> editOrNewAdditionalItemsLike(JSONSchemaPropsOrBool item) {
    return withNewAdditionalItemsLike(getAdditionalItems() != null ? getAdditionalItems(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalProperties instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaPropsOrBool getAdditionalProperties() {
    return this.additionalProperties!=null ?this.additionalProperties.build():null;
  }
  public JSONSchemaPropsOrBool buildAdditionalProperties() {
    return this.additionalProperties!=null ?this.additionalProperties.build():null;
  }
  public A withAdditionalProperties(JSONSchemaPropsOrBool additionalProperties) {
    _visitables.get("additionalProperties").remove(this.additionalProperties);
    if (additionalProperties!=null){ this.additionalProperties= new JSONSchemaPropsOrBoolBuilder(additionalProperties); _visitables.get("additionalProperties").add(this.additionalProperties);} else { this.additionalProperties = null; _visitables.get("additionalProperties").remove(this.additionalProperties); } return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public JSONSchemaPropsFluent.AdditionalPropertiesNested<A> withNewAdditionalProperties() {
    return new JSONSchemaPropsFluentImpl.AdditionalPropertiesNestedImpl();
  }
  public JSONSchemaPropsFluent.AdditionalPropertiesNested<A> withNewAdditionalPropertiesLike(JSONSchemaPropsOrBool item) {
    return new JSONSchemaPropsFluentImpl.AdditionalPropertiesNestedImpl(item);
  }
  public JSONSchemaPropsFluent.AdditionalPropertiesNested<A> editAdditionalProperties() {
    return withNewAdditionalPropertiesLike(getAdditionalProperties());
  }
  public JSONSchemaPropsFluent.AdditionalPropertiesNested<A> editOrNewAdditionalProperties() {
    return withNewAdditionalPropertiesLike(getAdditionalProperties() != null ? getAdditionalProperties(): new JSONSchemaPropsOrBoolBuilder().build());
  }
  public JSONSchemaPropsFluent.AdditionalPropertiesNested<A> editOrNewAdditionalPropertiesLike(JSONSchemaPropsOrBool item) {
    return withNewAdditionalPropertiesLike(getAdditionalProperties() != null ? getAdditionalProperties(): item);
  }
  public A addToAllOf(Integer index,JSONSchemaProps item) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").add(index >= 0 ? index : _visitables.get("allOf").size(), builder);this.allOf.add(index >= 0 ? index : allOf.size(), builder); return (A)this;
  }
  public A setToAllOf(Integer index,JSONSchemaProps item) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= _visitables.get("allOf").size()) { _visitables.get("allOf").add(builder); } else { _visitables.get("allOf").set(index, builder);}
    if (index < 0 || index >= allOf.size()) { allOf.add(builder); } else { allOf.set(index, builder);}
     return (A)this;
  }
  public A addToAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").add(builder);this.allOf.add(builder);} return (A)this;
  }
  public A addAllToAllOf(Collection<JSONSchemaProps> items) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").add(builder);this.allOf.add(builder);} return (A)this;
  }
  public A removeFromAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").remove(builder);if (this.allOf != null) {this.allOf.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllOf(Collection<JSONSchemaProps> items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").remove(builder);if (this.allOf != null) {this.allOf.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (allOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = allOf.iterator();
    final List visitables = _visitables.get("allOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllOf instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<JSONSchemaProps> getAllOf() {
    return allOf != null ? build(allOf) : null;
  }
  public List<JSONSchemaProps> buildAllOf() {
    return allOf != null ? build(allOf) : null;
  }
  public JSONSchemaProps buildAllOf(Integer index) {
    return this.allOf.get(index).build();
  }
  public JSONSchemaProps buildFirstAllOf() {
    return this.allOf.get(0).build();
  }
  public JSONSchemaProps buildLastAllOf() {
    return this.allOf.get(allOf.size() - 1).build();
  }
  public JSONSchemaProps buildMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: allOf) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: allOf) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllOf(List<JSONSchemaProps> allOf) {
    if (this.allOf != null) { _visitables.get("allOf").removeAll(this.allOf);}
    if (allOf != null) {this.allOf = new ArrayList(); for (JSONSchemaProps item : allOf){this.addToAllOf(item);}} else { this.allOf = null;} return (A) this;
  }
  public A withAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... allOf) {
    if (this.allOf != null) {this.allOf.clear();}
    if (allOf != null) {for (JSONSchemaProps item :allOf){ this.addToAllOf(item);}} return (A) this;
  }
  public Boolean hasAllOf() {
    return allOf != null && !allOf.isEmpty();
  }
  public JSONSchemaPropsFluent.AllOfNested<A> addNewAllOf() {
    return new JSONSchemaPropsFluentImpl.AllOfNestedImpl();
  }
  public JSONSchemaPropsFluent.AllOfNested<A> addNewAllOfLike(JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.AllOfNestedImpl(-1, item);
  }
  public JSONSchemaPropsFluent.AllOfNested<A> setNewAllOfLike(Integer index,JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.AllOfNestedImpl(index, item);
  }
  public JSONSchemaPropsFluent.AllOfNested<A> editAllOf(Integer index) {
    if (allOf.size() <= index) throw new RuntimeException("Can't edit allOf. Index exceeds size.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  public JSONSchemaPropsFluent.AllOfNested<A> editFirstAllOf() {
    if (allOf.size() == 0) throw new RuntimeException("Can't edit first allOf. The list is empty.");
    return setNewAllOfLike(0, buildAllOf(0));
  }
  public JSONSchemaPropsFluent.AllOfNested<A> editLastAllOf() {
    int index = allOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allOf. The list is empty.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  public JSONSchemaPropsFluent.AllOfNested<A> editMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allOf.size();i++) { 
    if (predicate.test(allOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allOf. No match found.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  public A addToAnyOf(Integer index,JSONSchemaProps item) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").add(index >= 0 ? index : _visitables.get("anyOf").size(), builder);this.anyOf.add(index >= 0 ? index : anyOf.size(), builder); return (A)this;
  }
  public A setToAnyOf(Integer index,JSONSchemaProps item) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= _visitables.get("anyOf").size()) { _visitables.get("anyOf").add(builder); } else { _visitables.get("anyOf").set(index, builder);}
    if (index < 0 || index >= anyOf.size()) { anyOf.add(builder); } else { anyOf.set(index, builder);}
     return (A)this;
  }
  public A addToAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").add(builder);this.anyOf.add(builder);} return (A)this;
  }
  public A addAllToAnyOf(Collection<JSONSchemaProps> items) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").add(builder);this.anyOf.add(builder);} return (A)this;
  }
  public A removeFromAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").remove(builder);if (this.anyOf != null) {this.anyOf.remove(builder);}} return (A)this;
  }
  public A removeAllFromAnyOf(Collection<JSONSchemaProps> items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").remove(builder);if (this.anyOf != null) {this.anyOf.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (anyOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = anyOf.iterator();
    final List visitables = _visitables.get("anyOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAnyOf instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<JSONSchemaProps> getAnyOf() {
    return anyOf != null ? build(anyOf) : null;
  }
  public List<JSONSchemaProps> buildAnyOf() {
    return anyOf != null ? build(anyOf) : null;
  }
  public JSONSchemaProps buildAnyOf(Integer index) {
    return this.anyOf.get(index).build();
  }
  public JSONSchemaProps buildFirstAnyOf() {
    return this.anyOf.get(0).build();
  }
  public JSONSchemaProps buildLastAnyOf() {
    return this.anyOf.get(anyOf.size() - 1).build();
  }
  public JSONSchemaProps buildMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: anyOf) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: anyOf) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAnyOf(List<JSONSchemaProps> anyOf) {
    if (this.anyOf != null) { _visitables.get("anyOf").removeAll(this.anyOf);}
    if (anyOf != null) {this.anyOf = new ArrayList(); for (JSONSchemaProps item : anyOf){this.addToAnyOf(item);}} else { this.anyOf = null;} return (A) this;
  }
  public A withAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... anyOf) {
    if (this.anyOf != null) {this.anyOf.clear();}
    if (anyOf != null) {for (JSONSchemaProps item :anyOf){ this.addToAnyOf(item);}} return (A) this;
  }
  public Boolean hasAnyOf() {
    return anyOf != null && !anyOf.isEmpty();
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> addNewAnyOf() {
    return new JSONSchemaPropsFluentImpl.AnyOfNestedImpl();
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> addNewAnyOfLike(JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.AnyOfNestedImpl(-1, item);
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> setNewAnyOfLike(Integer index,JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.AnyOfNestedImpl(index, item);
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> editAnyOf(Integer index) {
    if (anyOf.size() <= index) throw new RuntimeException("Can't edit anyOf. Index exceeds size.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> editFirstAnyOf() {
    if (anyOf.size() == 0) throw new RuntimeException("Can't edit first anyOf. The list is empty.");
    return setNewAnyOfLike(0, buildAnyOf(0));
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> editLastAnyOf() {
    int index = anyOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last anyOf. The list is empty.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  public JSONSchemaPropsFluent.AnyOfNested<A> editMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<anyOf.size();i++) { 
    if (predicate.test(anyOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching anyOf. No match found.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  public JsonNode getDefault() {
    return this._default;
  }
  public A withDefault(JsonNode _default) {
    this._default=_default; return (A) this;
  }
  public Boolean hasDefault() {
    return this._default != null;
  }
  public A addToDefinitions(String key,JSONSchemaProps value) {
    if(this.definitions == null && key != null && value != null) { this.definitions = new LinkedHashMap(); }
    if(key != null && value != null) {this.definitions.put(key, value);} return (A)this;
  }
  public A addToDefinitions(Map<String,JSONSchemaProps> map) {
    if(this.definitions == null && map != null) { this.definitions = new LinkedHashMap(); }
    if(map != null) { this.definitions.putAll(map);} return (A)this;
  }
  public A removeFromDefinitions(String key) {
    if(this.definitions == null) { return (A) this; }
    if(key != null && this.definitions != null) {this.definitions.remove(key);} return (A)this;
  }
  public A removeFromDefinitions(Map<String,JSONSchemaProps> map) {
    if(this.definitions == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.definitions != null){this.definitions.remove(key);}}} return (A)this;
  }
  public Map<String,JSONSchemaProps> getDefinitions() {
    return this.definitions;
  }
  public <K,V>A withDefinitions(Map<String,JSONSchemaProps> definitions) {
    if (definitions == null) { this.definitions =  null;} else {this.definitions = new LinkedHashMap(definitions);} return (A) this;
  }
  public Boolean hasDefinitions() {
    return this.definitions != null;
  }
  public A addToDependencies(String key,JSONSchemaPropsOrStringArray value) {
    if(this.dependencies == null && key != null && value != null) { this.dependencies = new LinkedHashMap(); }
    if(key != null && value != null) {this.dependencies.put(key, value);} return (A)this;
  }
  public A addToDependencies(Map<String,JSONSchemaPropsOrStringArray> map) {
    if(this.dependencies == null && map != null) { this.dependencies = new LinkedHashMap(); }
    if(map != null) { this.dependencies.putAll(map);} return (A)this;
  }
  public A removeFromDependencies(String key) {
    if(this.dependencies == null) { return (A) this; }
    if(key != null && this.dependencies != null) {this.dependencies.remove(key);} return (A)this;
  }
  public A removeFromDependencies(Map<String,JSONSchemaPropsOrStringArray> map) {
    if(this.dependencies == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.dependencies != null){this.dependencies.remove(key);}}} return (A)this;
  }
  public Map<String,JSONSchemaPropsOrStringArray> getDependencies() {
    return this.dependencies;
  }
  public <K,V>A withDependencies(Map<String,JSONSchemaPropsOrStringArray> dependencies) {
    if (dependencies == null) { this.dependencies =  null;} else {this.dependencies = new LinkedHashMap(dependencies);} return (A) this;
  }
  public Boolean hasDependencies() {
    return this.dependencies != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public A addToEnum(Integer index,JsonNode item) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    this._enum.add(index, item);
    return (A)this;
  }
  public A setToEnum(Integer index,JsonNode item) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    this._enum.set(index, item); return (A)this;
  }
  public A addToEnum(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this._enum.add(item);} return (A)this;
  }
  public A addAllToEnum(Collection<JsonNode> items) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this._enum.add(item);} return (A)this;
  }
  public A removeFromEnum(com.fasterxml.jackson.databind.JsonNode... items) {
    for (JsonNode item : items) {if (this._enum!= null){ this._enum.remove(item);}} return (A)this;
  }
  public A removeAllFromEnum(Collection<JsonNode> items) {
    for (JsonNode item : items) {if (this._enum!= null){ this._enum.remove(item);}} return (A)this;
  }
  public List<JsonNode> getEnum() {
    return this._enum;
  }
  public JsonNode getEnum(Integer index) {
    return this._enum.get(index);
  }
  public JsonNode getFirstEnum() {
    return this._enum.get(0);
  }
  public JsonNode getLastEnum() {
    return this._enum.get(_enum.size() - 1);
  }
  public JsonNode getMatchingEnum(Predicate<JsonNode> predicate) {
    for (JsonNode item: _enum) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingEnum(Predicate<JsonNode> predicate) {
    for (JsonNode item: _enum) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnum(List<JsonNode> _enum) {
    if (_enum != null) {this._enum = new ArrayList(); for (JsonNode item : _enum){this.addToEnum(item);}} else { this._enum = null;} return (A) this;
  }
  public A withEnum(com.fasterxml.jackson.databind.JsonNode... _enum) {
    if (this._enum != null) {this._enum.clear();}
    if (_enum != null) {for (JsonNode item :_enum){ this.addToEnum(item);}} return (A) this;
  }
  public Boolean hasEnum() {
    return _enum != null && !_enum.isEmpty();
  }
  public JsonNode getExample() {
    return this.example;
  }
  public A withExample(JsonNode example) {
    this.example=example; return (A) this;
  }
  public Boolean hasExample() {
    return this.example != null;
  }
  public Boolean getExclusiveMaximum() {
    return this.exclusiveMaximum;
  }
  public A withExclusiveMaximum(Boolean exclusiveMaximum) {
    this.exclusiveMaximum=exclusiveMaximum; return (A) this;
  }
  public Boolean hasExclusiveMaximum() {
    return this.exclusiveMaximum != null;
  }
  public Boolean getExclusiveMinimum() {
    return this.exclusiveMinimum;
  }
  public A withExclusiveMinimum(Boolean exclusiveMinimum) {
    this.exclusiveMinimum=exclusiveMinimum; return (A) this;
  }
  public Boolean hasExclusiveMinimum() {
    return this.exclusiveMinimum != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalDocs instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalDocumentation getExternalDocs() {
    return this.externalDocs!=null ?this.externalDocs.build():null;
  }
  public ExternalDocumentation buildExternalDocs() {
    return this.externalDocs!=null ?this.externalDocs.build():null;
  }
  public A withExternalDocs(ExternalDocumentation externalDocs) {
    _visitables.get("externalDocs").remove(this.externalDocs);
    if (externalDocs!=null){ this.externalDocs= new ExternalDocumentationBuilder(externalDocs); _visitables.get("externalDocs").add(this.externalDocs);} else { this.externalDocs = null; _visitables.get("externalDocs").remove(this.externalDocs); } return (A) this;
  }
  public Boolean hasExternalDocs() {
    return this.externalDocs != null;
  }
  public A withNewExternalDocs(String description,String url) {
    return (A)withExternalDocs(new ExternalDocumentation(description, url));
  }
  public JSONSchemaPropsFluent.ExternalDocsNested<A> withNewExternalDocs() {
    return new JSONSchemaPropsFluentImpl.ExternalDocsNestedImpl();
  }
  public JSONSchemaPropsFluent.ExternalDocsNested<A> withNewExternalDocsLike(ExternalDocumentation item) {
    return new JSONSchemaPropsFluentImpl.ExternalDocsNestedImpl(item);
  }
  public JSONSchemaPropsFluent.ExternalDocsNested<A> editExternalDocs() {
    return withNewExternalDocsLike(getExternalDocs());
  }
  public JSONSchemaPropsFluent.ExternalDocsNested<A> editOrNewExternalDocs() {
    return withNewExternalDocsLike(getExternalDocs() != null ? getExternalDocs(): new ExternalDocumentationBuilder().build());
  }
  public JSONSchemaPropsFluent.ExternalDocsNested<A> editOrNewExternalDocsLike(ExternalDocumentation item) {
    return withNewExternalDocsLike(getExternalDocs() != null ? getExternalDocs(): item);
  }
  public String getFormat() {
    return this.format;
  }
  public A withFormat(String format) {
    this.format=format; return (A) this;
  }
  public Boolean hasFormat() {
    return this.format != null;
  }
  public String getId() {
    return this.id;
  }
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  public Boolean hasId() {
    return this.id != null;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaPropsOrArray getItems() {
    return this.items!=null ?this.items.build():null;
  }
  public JSONSchemaPropsOrArray buildItems() {
    return this.items!=null ?this.items.build():null;
  }
  public A withItems(JSONSchemaPropsOrArray items) {
    _visitables.get("items").remove(this.items);
    if (items!=null){ this.items= new JSONSchemaPropsOrArrayBuilder(items); _visitables.get("items").add(this.items);} else { this.items = null; _visitables.get("items").remove(this.items); } return (A) this;
  }
  public Boolean hasItems() {
    return this.items != null;
  }
  public JSONSchemaPropsFluent.ItemsNested<A> withNewItems() {
    return new JSONSchemaPropsFluentImpl.ItemsNestedImpl();
  }
  public JSONSchemaPropsFluent.ItemsNested<A> withNewItemsLike(JSONSchemaPropsOrArray item) {
    return new JSONSchemaPropsFluentImpl.ItemsNestedImpl(item);
  }
  public JSONSchemaPropsFluent.ItemsNested<A> editItems() {
    return withNewItemsLike(getItems());
  }
  public JSONSchemaPropsFluent.ItemsNested<A> editOrNewItems() {
    return withNewItemsLike(getItems() != null ? getItems(): new JSONSchemaPropsOrArrayBuilder().build());
  }
  public JSONSchemaPropsFluent.ItemsNested<A> editOrNewItemsLike(JSONSchemaPropsOrArray item) {
    return withNewItemsLike(getItems() != null ? getItems(): item);
  }
  public Long getMaxItems() {
    return this.maxItems;
  }
  public A withMaxItems(Long maxItems) {
    this.maxItems=maxItems; return (A) this;
  }
  public Boolean hasMaxItems() {
    return this.maxItems != null;
  }
  public Long getMaxLength() {
    return this.maxLength;
  }
  public A withMaxLength(Long maxLength) {
    this.maxLength=maxLength; return (A) this;
  }
  public Boolean hasMaxLength() {
    return this.maxLength != null;
  }
  public Long getMaxProperties() {
    return this.maxProperties;
  }
  public A withMaxProperties(Long maxProperties) {
    this.maxProperties=maxProperties; return (A) this;
  }
  public Boolean hasMaxProperties() {
    return this.maxProperties != null;
  }
  public Double getMaximum() {
    return this.maximum;
  }
  public A withMaximum(Double maximum) {
    this.maximum=maximum; return (A) this;
  }
  public Boolean hasMaximum() {
    return this.maximum != null;
  }
  public Long getMinItems() {
    return this.minItems;
  }
  public A withMinItems(Long minItems) {
    this.minItems=minItems; return (A) this;
  }
  public Boolean hasMinItems() {
    return this.minItems != null;
  }
  public Long getMinLength() {
    return this.minLength;
  }
  public A withMinLength(Long minLength) {
    this.minLength=minLength; return (A) this;
  }
  public Boolean hasMinLength() {
    return this.minLength != null;
  }
  public Long getMinProperties() {
    return this.minProperties;
  }
  public A withMinProperties(Long minProperties) {
    this.minProperties=minProperties; return (A) this;
  }
  public Boolean hasMinProperties() {
    return this.minProperties != null;
  }
  public Double getMinimum() {
    return this.minimum;
  }
  public A withMinimum(Double minimum) {
    this.minimum=minimum; return (A) this;
  }
  public Boolean hasMinimum() {
    return this.minimum != null;
  }
  public Double getMultipleOf() {
    return this.multipleOf;
  }
  public A withMultipleOf(Double multipleOf) {
    this.multipleOf=multipleOf; return (A) this;
  }
  public Boolean hasMultipleOf() {
    return this.multipleOf != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNot instead.
   * @return The buildable object.
   */
  @Deprecated
  public JSONSchemaProps getNot() {
    return this.not!=null ?this.not.build():null;
  }
  public JSONSchemaProps buildNot() {
    return this.not!=null ?this.not.build():null;
  }
  public A withNot(JSONSchemaProps not) {
    _visitables.get("not").remove(this.not);
    if (not!=null){ this.not= new JSONSchemaPropsBuilder(not); _visitables.get("not").add(this.not);} else { this.not = null; _visitables.get("not").remove(this.not); } return (A) this;
  }
  public Boolean hasNot() {
    return this.not != null;
  }
  public JSONSchemaPropsFluent.NotNested<A> withNewNot() {
    return new JSONSchemaPropsFluentImpl.NotNestedImpl();
  }
  public JSONSchemaPropsFluent.NotNested<A> withNewNotLike(JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.NotNestedImpl(item);
  }
  public JSONSchemaPropsFluent.NotNested<A> editNot() {
    return withNewNotLike(getNot());
  }
  public JSONSchemaPropsFluent.NotNested<A> editOrNewNot() {
    return withNewNotLike(getNot() != null ? getNot(): new JSONSchemaPropsBuilder().build());
  }
  public JSONSchemaPropsFluent.NotNested<A> editOrNewNotLike(JSONSchemaProps item) {
    return withNewNotLike(getNot() != null ? getNot(): item);
  }
  public Boolean getNullable() {
    return this.nullable;
  }
  public A withNullable(Boolean nullable) {
    this.nullable=nullable; return (A) this;
  }
  public Boolean hasNullable() {
    return this.nullable != null;
  }
  public A addToOneOf(Integer index,JSONSchemaProps item) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").add(index >= 0 ? index : _visitables.get("oneOf").size(), builder);this.oneOf.add(index >= 0 ? index : oneOf.size(), builder); return (A)this;
  }
  public A setToOneOf(Integer index,JSONSchemaProps item) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= _visitables.get("oneOf").size()) { _visitables.get("oneOf").add(builder); } else { _visitables.get("oneOf").set(index, builder);}
    if (index < 0 || index >= oneOf.size()) { oneOf.add(builder); } else { oneOf.set(index, builder);}
     return (A)this;
  }
  public A addToOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").add(builder);this.oneOf.add(builder);} return (A)this;
  }
  public A addAllToOneOf(Collection<JSONSchemaProps> items) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").add(builder);this.oneOf.add(builder);} return (A)this;
  }
  public A removeFromOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").remove(builder);if (this.oneOf != null) {this.oneOf.remove(builder);}} return (A)this;
  }
  public A removeAllFromOneOf(Collection<JSONSchemaProps> items) {
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").remove(builder);if (this.oneOf != null) {this.oneOf.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (oneOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = oneOf.iterator();
    final List visitables = _visitables.get("oneOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOneOf instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<JSONSchemaProps> getOneOf() {
    return oneOf != null ? build(oneOf) : null;
  }
  public List<JSONSchemaProps> buildOneOf() {
    return oneOf != null ? build(oneOf) : null;
  }
  public JSONSchemaProps buildOneOf(Integer index) {
    return this.oneOf.get(index).build();
  }
  public JSONSchemaProps buildFirstOneOf() {
    return this.oneOf.get(0).build();
  }
  public JSONSchemaProps buildLastOneOf() {
    return this.oneOf.get(oneOf.size() - 1).build();
  }
  public JSONSchemaProps buildMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: oneOf) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    for (JSONSchemaPropsBuilder item: oneOf) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOneOf(List<JSONSchemaProps> oneOf) {
    if (this.oneOf != null) { _visitables.get("oneOf").removeAll(this.oneOf);}
    if (oneOf != null) {this.oneOf = new ArrayList(); for (JSONSchemaProps item : oneOf){this.addToOneOf(item);}} else { this.oneOf = null;} return (A) this;
  }
  public A withOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaProps... oneOf) {
    if (this.oneOf != null) {this.oneOf.clear();}
    if (oneOf != null) {for (JSONSchemaProps item :oneOf){ this.addToOneOf(item);}} return (A) this;
  }
  public Boolean hasOneOf() {
    return oneOf != null && !oneOf.isEmpty();
  }
  public JSONSchemaPropsFluent.OneOfNested<A> addNewOneOf() {
    return new JSONSchemaPropsFluentImpl.OneOfNestedImpl();
  }
  public JSONSchemaPropsFluent.OneOfNested<A> addNewOneOfLike(JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.OneOfNestedImpl(-1, item);
  }
  public JSONSchemaPropsFluent.OneOfNested<A> setNewOneOfLike(Integer index,JSONSchemaProps item) {
    return new JSONSchemaPropsFluentImpl.OneOfNestedImpl(index, item);
  }
  public JSONSchemaPropsFluent.OneOfNested<A> editOneOf(Integer index) {
    if (oneOf.size() <= index) throw new RuntimeException("Can't edit oneOf. Index exceeds size.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  public JSONSchemaPropsFluent.OneOfNested<A> editFirstOneOf() {
    if (oneOf.size() == 0) throw new RuntimeException("Can't edit first oneOf. The list is empty.");
    return setNewOneOfLike(0, buildOneOf(0));
  }
  public JSONSchemaPropsFluent.OneOfNested<A> editLastOneOf() {
    int index = oneOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last oneOf. The list is empty.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  public JSONSchemaPropsFluent.OneOfNested<A> editMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<oneOf.size();i++) { 
    if (predicate.test(oneOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching oneOf. No match found.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  public String getPattern() {
    return this.pattern;
  }
  public A withPattern(String pattern) {
    this.pattern=pattern; return (A) this;
  }
  public Boolean hasPattern() {
    return this.pattern != null;
  }
  public A addToPatternProperties(String key,JSONSchemaProps value) {
    if(this.patternProperties == null && key != null && value != null) { this.patternProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.patternProperties.put(key, value);} return (A)this;
  }
  public A addToPatternProperties(Map<String,JSONSchemaProps> map) {
    if(this.patternProperties == null && map != null) { this.patternProperties = new LinkedHashMap(); }
    if(map != null) { this.patternProperties.putAll(map);} return (A)this;
  }
  public A removeFromPatternProperties(String key) {
    if(this.patternProperties == null) { return (A) this; }
    if(key != null && this.patternProperties != null) {this.patternProperties.remove(key);} return (A)this;
  }
  public A removeFromPatternProperties(Map<String,JSONSchemaProps> map) {
    if(this.patternProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.patternProperties != null){this.patternProperties.remove(key);}}} return (A)this;
  }
  public Map<String,JSONSchemaProps> getPatternProperties() {
    return this.patternProperties;
  }
  public <K,V>A withPatternProperties(Map<String,JSONSchemaProps> patternProperties) {
    if (patternProperties == null) { this.patternProperties =  null;} else {this.patternProperties = new LinkedHashMap(patternProperties);} return (A) this;
  }
  public Boolean hasPatternProperties() {
    return this.patternProperties != null;
  }
  public A addToProperties(String key,JSONSchemaProps value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  public A addToProperties(Map<String,JSONSchemaProps> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  public A removeFromProperties(Map<String,JSONSchemaProps> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  public Map<String,JSONSchemaProps> getProperties() {
    return this.properties;
  }
  public <K,V>A withProperties(Map<String,JSONSchemaProps> properties) {
    if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap(properties);} return (A) this;
  }
  public Boolean hasProperties() {
    return this.properties != null;
  }
  public A addToRequired(Integer index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.add(index, item);
    return (A)this;
  }
  public A setToRequired(Integer index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.set(index, item); return (A)this;
  }
  public A addToRequired(java.lang.String... items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  public A addAllToRequired(Collection<String> items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  public A removeFromRequired(java.lang.String... items) {
    for (String item : items) {if (this.required!= null){ this.required.remove(item);}} return (A)this;
  }
  public A removeAllFromRequired(Collection<String> items) {
    for (String item : items) {if (this.required!= null){ this.required.remove(item);}} return (A)this;
  }
  public List<String> getRequired() {
    return this.required;
  }
  public String getRequired(Integer index) {
    return this.required.get(index);
  }
  public String getFirstRequired() {
    return this.required.get(0);
  }
  public String getLastRequired() {
    return this.required.get(required.size() - 1);
  }
  public String getMatchingRequired(Predicate<String> predicate) {
    for (String item: required) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRequired(Predicate<String> predicate) {
    for (String item: required) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequired(List<String> required) {
    if (required != null) {this.required = new ArrayList(); for (String item : required){this.addToRequired(item);}} else { this.required = null;} return (A) this;
  }
  public A withRequired(java.lang.String... required) {
    if (this.required != null) {this.required.clear();}
    if (required != null) {for (String item :required){ this.addToRequired(item);}} return (A) this;
  }
  public Boolean hasRequired() {
    return required != null && !required.isEmpty();
  }
  public String getTitle() {
    return this.title;
  }
  public A withTitle(String title) {
    this.title=title; return (A) this;
  }
  public Boolean hasTitle() {
    return this.title != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public Boolean getUniqueItems() {
    return this.uniqueItems;
  }
  public A withUniqueItems(Boolean uniqueItems) {
    this.uniqueItems=uniqueItems; return (A) this;
  }
  public Boolean hasUniqueItems() {
    return this.uniqueItems != null;
  }
  public Boolean getXKubernetesEmbeddedResource() {
    return this.xKubernetesEmbeddedResource;
  }
  public A withXKubernetesEmbeddedResource(Boolean xKubernetesEmbeddedResource) {
    this.xKubernetesEmbeddedResource=xKubernetesEmbeddedResource; return (A) this;
  }
  public Boolean hasXKubernetesEmbeddedResource() {
    return this.xKubernetesEmbeddedResource != null;
  }
  public Boolean getXKubernetesIntOrString() {
    return this.xKubernetesIntOrString;
  }
  public A withXKubernetesIntOrString(Boolean xKubernetesIntOrString) {
    this.xKubernetesIntOrString=xKubernetesIntOrString; return (A) this;
  }
  public Boolean hasXKubernetesIntOrString() {
    return this.xKubernetesIntOrString != null;
  }
  public A addToXKubernetesListMapKeys(Integer index,String item) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    this.xKubernetesListMapKeys.add(index, item);
    return (A)this;
  }
  public A setToXKubernetesListMapKeys(Integer index,String item) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    this.xKubernetesListMapKeys.set(index, item); return (A)this;
  }
  public A addToXKubernetesListMapKeys(java.lang.String... items) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    for (String item : items) {this.xKubernetesListMapKeys.add(item);} return (A)this;
  }
  public A addAllToXKubernetesListMapKeys(Collection<String> items) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    for (String item : items) {this.xKubernetesListMapKeys.add(item);} return (A)this;
  }
  public A removeFromXKubernetesListMapKeys(java.lang.String... items) {
    for (String item : items) {if (this.xKubernetesListMapKeys!= null){ this.xKubernetesListMapKeys.remove(item);}} return (A)this;
  }
  public A removeAllFromXKubernetesListMapKeys(Collection<String> items) {
    for (String item : items) {if (this.xKubernetesListMapKeys!= null){ this.xKubernetesListMapKeys.remove(item);}} return (A)this;
  }
  public List<String> getXKubernetesListMapKeys() {
    return this.xKubernetesListMapKeys;
  }
  public String getXKubernetesListMapKey(Integer index) {
    return this.xKubernetesListMapKeys.get(index);
  }
  public String getFirstXKubernetesListMapKey() {
    return this.xKubernetesListMapKeys.get(0);
  }
  public String getLastXKubernetesListMapKey() {
    return this.xKubernetesListMapKeys.get(xKubernetesListMapKeys.size() - 1);
  }
  public String getMatchingXKubernetesListMapKey(Predicate<String> predicate) {
    for (String item: xKubernetesListMapKeys) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingXKubernetesListMapKey(Predicate<String> predicate) {
    for (String item: xKubernetesListMapKeys) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withXKubernetesListMapKeys(List<String> xKubernetesListMapKeys) {
    if (xKubernetesListMapKeys != null) {this.xKubernetesListMapKeys = new ArrayList(); for (String item : xKubernetesListMapKeys){this.addToXKubernetesListMapKeys(item);}} else { this.xKubernetesListMapKeys = null;} return (A) this;
  }
  public A withXKubernetesListMapKeys(java.lang.String... xKubernetesListMapKeys) {
    if (this.xKubernetesListMapKeys != null) {this.xKubernetesListMapKeys.clear();}
    if (xKubernetesListMapKeys != null) {for (String item :xKubernetesListMapKeys){ this.addToXKubernetesListMapKeys(item);}} return (A) this;
  }
  public Boolean hasXKubernetesListMapKeys() {
    return xKubernetesListMapKeys != null && !xKubernetesListMapKeys.isEmpty();
  }
  public String getXKubernetesListType() {
    return this.xKubernetesListType;
  }
  public A withXKubernetesListType(String xKubernetesListType) {
    this.xKubernetesListType=xKubernetesListType; return (A) this;
  }
  public Boolean hasXKubernetesListType() {
    return this.xKubernetesListType != null;
  }
  public String getXKubernetesMapType() {
    return this.xKubernetesMapType;
  }
  public A withXKubernetesMapType(String xKubernetesMapType) {
    this.xKubernetesMapType=xKubernetesMapType; return (A) this;
  }
  public Boolean hasXKubernetesMapType() {
    return this.xKubernetesMapType != null;
  }
  public Boolean getXKubernetesPreserveUnknownFields() {
    return this.xKubernetesPreserveUnknownFields;
  }
  public A withXKubernetesPreserveUnknownFields(Boolean xKubernetesPreserveUnknownFields) {
    this.xKubernetesPreserveUnknownFields=xKubernetesPreserveUnknownFields; return (A) this;
  }
  public Boolean hasXKubernetesPreserveUnknownFields() {
    return this.xKubernetesPreserveUnknownFields != null;
  }
  public A addToXKubernetesValidations(Integer index,ValidationRule item) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").add(index >= 0 ? index : _visitables.get("xKubernetesValidations").size(), builder);this.xKubernetesValidations.add(index >= 0 ? index : xKubernetesValidations.size(), builder); return (A)this;
  }
  public A setToXKubernetesValidations(Integer index,ValidationRule item) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("xKubernetesValidations").size()) { _visitables.get("xKubernetesValidations").add(builder); } else { _visitables.get("xKubernetesValidations").set(index, builder);}
    if (index < 0 || index >= xKubernetesValidations.size()) { xKubernetesValidations.add(builder); } else { xKubernetesValidations.set(index, builder);}
     return (A)this;
  }
  public A addToXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule... items) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").add(builder);this.xKubernetesValidations.add(builder);} return (A)this;
  }
  public A addAllToXKubernetesValidations(Collection<ValidationRule> items) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").add(builder);this.xKubernetesValidations.add(builder);} return (A)this;
  }
  public A removeFromXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule... items) {
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").remove(builder);if (this.xKubernetesValidations != null) {this.xKubernetesValidations.remove(builder);}} return (A)this;
  }
  public A removeAllFromXKubernetesValidations(Collection<ValidationRule> items) {
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").remove(builder);if (this.xKubernetesValidations != null) {this.xKubernetesValidations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromXKubernetesValidations(Predicate<ValidationRuleBuilder> predicate) {
    if (xKubernetesValidations == null) return (A) this;
    final Iterator<ValidationRuleBuilder> each = xKubernetesValidations.iterator();
    final List visitables = _visitables.get("xKubernetesValidations");
    while (each.hasNext()) {
      ValidationRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildXKubernetesValidations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ValidationRule> getXKubernetesValidations() {
    return xKubernetesValidations != null ? build(xKubernetesValidations) : null;
  }
  public List<ValidationRule> buildXKubernetesValidations() {
    return xKubernetesValidations != null ? build(xKubernetesValidations) : null;
  }
  public ValidationRule buildXKubernetesValidation(Integer index) {
    return this.xKubernetesValidations.get(index).build();
  }
  public ValidationRule buildFirstXKubernetesValidation() {
    return this.xKubernetesValidations.get(0).build();
  }
  public ValidationRule buildLastXKubernetesValidation() {
    return this.xKubernetesValidations.get(xKubernetesValidations.size() - 1).build();
  }
  public ValidationRule buildMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
    for (ValidationRuleBuilder item: xKubernetesValidations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
    for (ValidationRuleBuilder item: xKubernetesValidations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withXKubernetesValidations(List<ValidationRule> xKubernetesValidations) {
    if (this.xKubernetesValidations != null) { _visitables.get("xKubernetesValidations").removeAll(this.xKubernetesValidations);}
    if (xKubernetesValidations != null) {this.xKubernetesValidations = new ArrayList(); for (ValidationRule item : xKubernetesValidations){this.addToXKubernetesValidations(item);}} else { this.xKubernetesValidations = null;} return (A) this;
  }
  public A withXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.ValidationRule... xKubernetesValidations) {
    if (this.xKubernetesValidations != null) {this.xKubernetesValidations.clear();}
    if (xKubernetesValidations != null) {for (ValidationRule item :xKubernetesValidations){ this.addToXKubernetesValidations(item);}} return (A) this;
  }
  public Boolean hasXKubernetesValidations() {
    return xKubernetesValidations != null && !xKubernetesValidations.isEmpty();
  }
  public A addNewXKubernetesValidation(String message,String rule) {
    return (A)addToXKubernetesValidations(new ValidationRule(message, rule));
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> addNewXKubernetesValidation() {
    return new JSONSchemaPropsFluentImpl.XKubernetesValidationsNestedImpl();
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> addNewXKubernetesValidationLike(ValidationRule item) {
    return new JSONSchemaPropsFluentImpl.XKubernetesValidationsNestedImpl(-1, item);
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> setNewXKubernetesValidationLike(Integer index,ValidationRule item) {
    return new JSONSchemaPropsFluentImpl.XKubernetesValidationsNestedImpl(index, item);
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> editXKubernetesValidation(Integer index) {
    if (xKubernetesValidations.size() <= index) throw new RuntimeException("Can't edit xKubernetesValidations. Index exceeds size.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> editFirstXKubernetesValidation() {
    if (xKubernetesValidations.size() == 0) throw new RuntimeException("Can't edit first xKubernetesValidations. The list is empty.");
    return setNewXKubernetesValidationLike(0, buildXKubernetesValidation(0));
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> editLastXKubernetesValidation() {
    int index = xKubernetesValidations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last xKubernetesValidations. The list is empty.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  public JSONSchemaPropsFluent.XKubernetesValidationsNested<A> editMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<xKubernetesValidations.size();i++) { 
    if (predicate.test(xKubernetesValidations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching xKubernetesValidations. No match found.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JSONSchemaPropsFluentImpl that = (JSONSchemaPropsFluentImpl) o;
    if ($ref != null ? !$ref.equals(that.$ref) :that.$ref != null) return false;
    if ($schema != null ? !$schema.equals(that.$schema) :that.$schema != null) return false;
    if (additionalItems != null ? !additionalItems.equals(that.additionalItems) :that.additionalItems != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    if (allOf != null ? !allOf.equals(that.allOf) :that.allOf != null) return false;
    if (anyOf != null ? !anyOf.equals(that.anyOf) :that.anyOf != null) return false;
    if (_default != null ? !_default.equals(that._default) :that._default != null) return false;
    if (definitions != null ? !definitions.equals(that.definitions) :that.definitions != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (_enum != null ? !_enum.equals(that._enum) :that._enum != null) return false;
    if (example != null ? !example.equals(that.example) :that.example != null) return false;
    if (exclusiveMaximum != null ? !exclusiveMaximum.equals(that.exclusiveMaximum) :that.exclusiveMaximum != null) return false;
    if (exclusiveMinimum != null ? !exclusiveMinimum.equals(that.exclusiveMinimum) :that.exclusiveMinimum != null) return false;
    if (externalDocs != null ? !externalDocs.equals(that.externalDocs) :that.externalDocs != null) return false;
    if (format != null ? !format.equals(that.format) :that.format != null) return false;
    if (id != null ? !id.equals(that.id) :that.id != null) return false;
    if (items != null ? !items.equals(that.items) :that.items != null) return false;
    if (maxItems != null ? !maxItems.equals(that.maxItems) :that.maxItems != null) return false;
    if (maxLength != null ? !maxLength.equals(that.maxLength) :that.maxLength != null) return false;
    if (maxProperties != null ? !maxProperties.equals(that.maxProperties) :that.maxProperties != null) return false;
    if (maximum != null ? !maximum.equals(that.maximum) :that.maximum != null) return false;
    if (minItems != null ? !minItems.equals(that.minItems) :that.minItems != null) return false;
    if (minLength != null ? !minLength.equals(that.minLength) :that.minLength != null) return false;
    if (minProperties != null ? !minProperties.equals(that.minProperties) :that.minProperties != null) return false;
    if (minimum != null ? !minimum.equals(that.minimum) :that.minimum != null) return false;
    if (multipleOf != null ? !multipleOf.equals(that.multipleOf) :that.multipleOf != null) return false;
    if (not != null ? !not.equals(that.not) :that.not != null) return false;
    if (nullable != null ? !nullable.equals(that.nullable) :that.nullable != null) return false;
    if (oneOf != null ? !oneOf.equals(that.oneOf) :that.oneOf != null) return false;
    if (pattern != null ? !pattern.equals(that.pattern) :that.pattern != null) return false;
    if (patternProperties != null ? !patternProperties.equals(that.patternProperties) :that.patternProperties != null) return false;
    if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
    if (required != null ? !required.equals(that.required) :that.required != null) return false;
    if (title != null ? !title.equals(that.title) :that.title != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (uniqueItems != null ? !uniqueItems.equals(that.uniqueItems) :that.uniqueItems != null) return false;
    if (xKubernetesEmbeddedResource != null ? !xKubernetesEmbeddedResource.equals(that.xKubernetesEmbeddedResource) :that.xKubernetesEmbeddedResource != null) return false;
    if (xKubernetesIntOrString != null ? !xKubernetesIntOrString.equals(that.xKubernetesIntOrString) :that.xKubernetesIntOrString != null) return false;
    if (xKubernetesListMapKeys != null ? !xKubernetesListMapKeys.equals(that.xKubernetesListMapKeys) :that.xKubernetesListMapKeys != null) return false;
    if (xKubernetesListType != null ? !xKubernetesListType.equals(that.xKubernetesListType) :that.xKubernetesListType != null) return false;
    if (xKubernetesMapType != null ? !xKubernetesMapType.equals(that.xKubernetesMapType) :that.xKubernetesMapType != null) return false;
    if (xKubernetesPreserveUnknownFields != null ? !xKubernetesPreserveUnknownFields.equals(that.xKubernetesPreserveUnknownFields) :that.xKubernetesPreserveUnknownFields != null) return false;
    if (xKubernetesValidations != null ? !xKubernetesValidations.equals(that.xKubernetesValidations) :that.xKubernetesValidations != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash($ref,  $schema,  additionalItems,  additionalProperties,  allOf,  anyOf,  _default,  definitions,  dependencies,  description,  _enum,  example,  exclusiveMaximum,  exclusiveMinimum,  externalDocs,  format,  id,  items,  maxItems,  maxLength,  maxProperties,  maximum,  minItems,  minLength,  minProperties,  minimum,  multipleOf,  not,  nullable,  oneOf,  pattern,  patternProperties,  properties,  required,  title,  type,  uniqueItems,  xKubernetesEmbeddedResource,  xKubernetesIntOrString,  xKubernetesListMapKeys,  xKubernetesListType,  xKubernetesMapType,  xKubernetesPreserveUnknownFields,  xKubernetesValidations,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if ($ref != null) { sb.append("$ref:"); sb.append($ref + ","); }
    if ($schema != null) { sb.append("$schema:"); sb.append($schema + ","); }
    if (additionalItems != null) { sb.append("additionalItems:"); sb.append(additionalItems + ","); }
    if (additionalProperties != null) { sb.append("additionalProperties:"); sb.append(additionalProperties + ","); }
    if (allOf != null && !allOf.isEmpty()) { sb.append("allOf:"); sb.append(allOf + ","); }
    if (anyOf != null && !anyOf.isEmpty()) { sb.append("anyOf:"); sb.append(anyOf + ","); }
    if (_default != null) { sb.append("_default:"); sb.append(_default + ","); }
    if (definitions != null && !definitions.isEmpty()) { sb.append("definitions:"); sb.append(definitions + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (_enum != null && !_enum.isEmpty()) { sb.append("_enum:"); sb.append(_enum + ","); }
    if (example != null) { sb.append("example:"); sb.append(example + ","); }
    if (exclusiveMaximum != null) { sb.append("exclusiveMaximum:"); sb.append(exclusiveMaximum + ","); }
    if (exclusiveMinimum != null) { sb.append("exclusiveMinimum:"); sb.append(exclusiveMinimum + ","); }
    if (externalDocs != null) { sb.append("externalDocs:"); sb.append(externalDocs + ","); }
    if (format != null) { sb.append("format:"); sb.append(format + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (maxItems != null) { sb.append("maxItems:"); sb.append(maxItems + ","); }
    if (maxLength != null) { sb.append("maxLength:"); sb.append(maxLength + ","); }
    if (maxProperties != null) { sb.append("maxProperties:"); sb.append(maxProperties + ","); }
    if (maximum != null) { sb.append("maximum:"); sb.append(maximum + ","); }
    if (minItems != null) { sb.append("minItems:"); sb.append(minItems + ","); }
    if (minLength != null) { sb.append("minLength:"); sb.append(minLength + ","); }
    if (minProperties != null) { sb.append("minProperties:"); sb.append(minProperties + ","); }
    if (minimum != null) { sb.append("minimum:"); sb.append(minimum + ","); }
    if (multipleOf != null) { sb.append("multipleOf:"); sb.append(multipleOf + ","); }
    if (not != null) { sb.append("not:"); sb.append(not + ","); }
    if (nullable != null) { sb.append("nullable:"); sb.append(nullable + ","); }
    if (oneOf != null && !oneOf.isEmpty()) { sb.append("oneOf:"); sb.append(oneOf + ","); }
    if (pattern != null) { sb.append("pattern:"); sb.append(pattern + ","); }
    if (patternProperties != null && !patternProperties.isEmpty()) { sb.append("patternProperties:"); sb.append(patternProperties + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (required != null && !required.isEmpty()) { sb.append("required:"); sb.append(required + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (uniqueItems != null) { sb.append("uniqueItems:"); sb.append(uniqueItems + ","); }
    if (xKubernetesEmbeddedResource != null) { sb.append("xKubernetesEmbeddedResource:"); sb.append(xKubernetesEmbeddedResource + ","); }
    if (xKubernetesIntOrString != null) { sb.append("xKubernetesIntOrString:"); sb.append(xKubernetesIntOrString + ","); }
    if (xKubernetesListMapKeys != null && !xKubernetesListMapKeys.isEmpty()) { sb.append("xKubernetesListMapKeys:"); sb.append(xKubernetesListMapKeys + ","); }
    if (xKubernetesListType != null) { sb.append("xKubernetesListType:"); sb.append(xKubernetesListType + ","); }
    if (xKubernetesMapType != null) { sb.append("xKubernetesMapType:"); sb.append(xKubernetesMapType + ","); }
    if (xKubernetesPreserveUnknownFields != null) { sb.append("xKubernetesPreserveUnknownFields:"); sb.append(xKubernetesPreserveUnknownFields + ","); }
    if (xKubernetesValidations != null && !xKubernetesValidations.isEmpty()) { sb.append("xKubernetesValidations:"); sb.append(xKubernetesValidations); }
    sb.append("}");
    return sb.toString();
  }
  public A withExclusiveMaximum() {
    return withExclusiveMaximum(true);
  }
  public A withExclusiveMinimum() {
    return withExclusiveMinimum(true);
  }
  public A withNullable() {
    return withNullable(true);
  }
  public A withUniqueItems() {
    return withUniqueItems(true);
  }
  public A withXKubernetesEmbeddedResource() {
    return withXKubernetesEmbeddedResource(true);
  }
  public A withXKubernetesIntOrString() {
    return withXKubernetesIntOrString(true);
  }
  public A withXKubernetesPreserveUnknownFields() {
    return withXKubernetesPreserveUnknownFields(true);
  }
  class AdditionalItemsNestedImpl<N> extends JSONSchemaPropsOrBoolFluentImpl<JSONSchemaPropsFluent.AdditionalItemsNested<N>> implements JSONSchemaPropsFluent.AdditionalItemsNested<N>,Nested<N>{
    AdditionalItemsNestedImpl(JSONSchemaPropsOrBool item) {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    AdditionalItemsNestedImpl() {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withAdditionalItems(builder.build());
    }
    public N endAdditionalItems() {
      return and();
    }
    
  }
  class AdditionalPropertiesNestedImpl<N> extends JSONSchemaPropsOrBoolFluentImpl<JSONSchemaPropsFluent.AdditionalPropertiesNested<N>> implements JSONSchemaPropsFluent.AdditionalPropertiesNested<N>,Nested<N>{
    AdditionalPropertiesNestedImpl(JSONSchemaPropsOrBool item) {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    AdditionalPropertiesNestedImpl() {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withAdditionalProperties(builder.build());
    }
    public N endAdditionalProperties() {
      return and();
    }
    
  }
  class AllOfNestedImpl<N> extends JSONSchemaPropsFluentImpl<JSONSchemaPropsFluent.AllOfNested<N>> implements JSONSchemaPropsFluent.AllOfNested<N>,Nested<N>{
    AllOfNestedImpl(Integer index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    AllOfNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    Integer index;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.setToAllOf(index,builder.build());
    }
    public N endAllOf() {
      return and();
    }
    
  }
  class AnyOfNestedImpl<N> extends JSONSchemaPropsFluentImpl<JSONSchemaPropsFluent.AnyOfNested<N>> implements JSONSchemaPropsFluent.AnyOfNested<N>,Nested<N>{
    AnyOfNestedImpl(Integer index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    AnyOfNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    Integer index;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.setToAnyOf(index,builder.build());
    }
    public N endAnyOf() {
      return and();
    }
    
  }
  class ExternalDocsNestedImpl<N> extends ExternalDocumentationFluentImpl<JSONSchemaPropsFluent.ExternalDocsNested<N>> implements JSONSchemaPropsFluent.ExternalDocsNested<N>,Nested<N>{
    ExternalDocsNestedImpl(ExternalDocumentation item) {
      this.builder = new ExternalDocumentationBuilder(this, item);
    }
    ExternalDocsNestedImpl() {
      this.builder = new ExternalDocumentationBuilder(this);
    }
    ExternalDocumentationBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withExternalDocs(builder.build());
    }
    public N endExternalDocs() {
      return and();
    }
    
  }
  class ItemsNestedImpl<N> extends JSONSchemaPropsOrArrayFluentImpl<JSONSchemaPropsFluent.ItemsNested<N>> implements JSONSchemaPropsFluent.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(JSONSchemaPropsOrArray item) {
      this.builder = new JSONSchemaPropsOrArrayBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.builder = new JSONSchemaPropsOrArrayBuilder(this);
    }
    JSONSchemaPropsOrArrayBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withItems(builder.build());
    }
    public N endItems() {
      return and();
    }
    
  }
  class NotNestedImpl<N> extends JSONSchemaPropsFluentImpl<JSONSchemaPropsFluent.NotNested<N>> implements JSONSchemaPropsFluent.NotNested<N>,Nested<N>{
    NotNestedImpl(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    NotNestedImpl() {
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.withNot(builder.build());
    }
    public N endNot() {
      return and();
    }
    
  }
  class OneOfNestedImpl<N> extends JSONSchemaPropsFluentImpl<JSONSchemaPropsFluent.OneOfNested<N>> implements JSONSchemaPropsFluent.OneOfNested<N>,Nested<N>{
    OneOfNestedImpl(Integer index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    OneOfNestedImpl() {
      this.index = -1;
      this.builder = new JSONSchemaPropsBuilder(this);
    }
    JSONSchemaPropsBuilder builder;
    Integer index;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.setToOneOf(index,builder.build());
    }
    public N endOneOf() {
      return and();
    }
    
  }
  class XKubernetesValidationsNestedImpl<N> extends ValidationRuleFluentImpl<JSONSchemaPropsFluent.XKubernetesValidationsNested<N>> implements JSONSchemaPropsFluent.XKubernetesValidationsNested<N>,Nested<N>{
    XKubernetesValidationsNestedImpl(Integer index,ValidationRule item) {
      this.index = index;
      this.builder = new ValidationRuleBuilder(this, item);
    }
    XKubernetesValidationsNestedImpl() {
      this.index = -1;
      this.builder = new ValidationRuleBuilder(this);
    }
    ValidationRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) JSONSchemaPropsFluentImpl.this.setToXKubernetesValidations(index,builder.build());
    }
    public N endXKubernetesValidation() {
      return and();
    }
    
  }
  
}