package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionSpecBuilder extends CustomResourceDefinitionSpecFluentImpl<CustomResourceDefinitionSpecBuilder> implements VisitableBuilder<CustomResourceDefinitionSpec,CustomResourceDefinitionSpecBuilder>{
  public CustomResourceDefinitionSpecBuilder() {
    this(false);
  }
  public CustomResourceDefinitionSpecBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionSpec(), validationEnabled);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionSpec(), validationEnabled);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
    fluent.withConversion(instance.getConversion()); 
    fluent.withGroup(instance.getGroup()); 
    fluent.withNames(instance.getNames()); 
    fluent.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
    fluent.withScope(instance.getScope()); 
    fluent.withSubresources(instance.getSubresources()); 
    fluent.withValidation(instance.getValidation()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withVersions(instance.getVersions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
    this.withConversion(instance.getConversion()); 
    this.withGroup(instance.getGroup()); 
    this.withNames(instance.getNames()); 
    this.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
    this.withScope(instance.getScope()); 
    this.withSubresources(instance.getSubresources()); 
    this.withValidation(instance.getValidation()); 
    this.withVersion(instance.getVersion()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionSpec build() {
    CustomResourceDefinitionSpec buildable = new CustomResourceDefinitionSpec(fluent.getAdditionalPrinterColumns(),fluent.getConversion(),fluent.getGroup(),fluent.getNames(),fluent.getPreserveUnknownFields(),fluent.getScope(),fluent.getSubresources(),fluent.getValidation(),fluent.getVersion(),fluent.getVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}