package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConversionRequestBuilder extends ConversionRequestFluentImpl<ConversionRequestBuilder> implements VisitableBuilder<ConversionRequest,ConversionRequestBuilder>{
  public ConversionRequestBuilder() {
    this(false);
  }
  public ConversionRequestBuilder(Boolean validationEnabled) {
    this(new ConversionRequest(), validationEnabled);
  }
  public ConversionRequestBuilder(ConversionRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public ConversionRequestBuilder(ConversionRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConversionRequest(), validationEnabled);
  }
  public ConversionRequestBuilder(ConversionRequestFluent<?> fluent,ConversionRequest instance) {
    this(fluent, instance, false);
  }
  public ConversionRequestBuilder(ConversionRequestFluent<?> fluent,ConversionRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDesiredAPIVersion(instance.getDesiredAPIVersion());
      fluent.withObjects(instance.getObjects());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConversionRequestBuilder(ConversionRequest instance) {
    this(instance,false);
  }
  public ConversionRequestBuilder(ConversionRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDesiredAPIVersion(instance.getDesiredAPIVersion());
      this.withObjects(instance.getObjects());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConversionRequestFluent<?> fluent;
  Boolean validationEnabled;
  public ConversionRequest build() {
    ConversionRequest buildable = new ConversionRequest(fluent.getDesiredAPIVersion(),fluent.getObjects(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}