package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionConditionBuilder extends CustomResourceDefinitionConditionFluentImpl<CustomResourceDefinitionConditionBuilder> implements VisitableBuilder<CustomResourceDefinitionCondition,CustomResourceDefinitionConditionBuilder>{
  public CustomResourceDefinitionConditionBuilder() {
    this(false);
  }
  public CustomResourceDefinitionConditionBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionCondition(), validationEnabled);
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionCondition(), validationEnabled);
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionConditionFluent<?> fluent,CustomResourceDefinitionCondition instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionConditionFluent<?> fluent,CustomResourceDefinitionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionCondition instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionConditionBuilder(CustomResourceDefinitionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionCondition build() {
    CustomResourceDefinitionCondition buildable = new CustomResourceDefinitionCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}