package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JSONSchemaPropsOrBoolBuilder extends JSONSchemaPropsOrBoolFluentImpl<JSONSchemaPropsOrBoolBuilder> implements VisitableBuilder<JSONSchemaPropsOrBool,JSONSchemaPropsOrBoolBuilder>{
  public JSONSchemaPropsOrBoolBuilder() {
    this(false);
  }
  public JSONSchemaPropsOrBoolBuilder(Boolean validationEnabled) {
    this(new JSONSchemaPropsOrBool(), validationEnabled);
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent) {
    this(fluent, false);
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JSONSchemaPropsOrBool(), validationEnabled);
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,JSONSchemaPropsOrBool instance) {
    this(fluent, instance, false);
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBoolFluent<?> fluent,JSONSchemaPropsOrBool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAllows(instance.getAllows());
      fluent.withSchema(instance.getSchema());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBool instance) {
    this(instance,false);
  }
  public JSONSchemaPropsOrBoolBuilder(JSONSchemaPropsOrBool instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAllows(instance.getAllows());
      this.withSchema(instance.getSchema());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JSONSchemaPropsOrBoolFluent<?> fluent;
  Boolean validationEnabled;
  public JSONSchemaPropsOrBool build() {
    JSONSchemaPropsOrBool buildable = new JSONSchemaPropsOrBool(fluent.getAllows(),fluent.getSchema());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}