package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidationRuleBuilder extends ValidationRuleFluentImpl<ValidationRuleBuilder> implements VisitableBuilder<ValidationRule,ValidationRuleBuilder>{
  public ValidationRuleBuilder() {
    this(false);
  }
  public ValidationRuleBuilder(Boolean validationEnabled) {
    this(new ValidationRule(), validationEnabled);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidationRule(), validationEnabled);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,ValidationRule instance) {
    this(fluent, instance, false);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,ValidationRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMessage(instance.getMessage());
      fluent.withRule(instance.getRule());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidationRuleBuilder(ValidationRule instance) {
    this(instance,false);
  }
  public ValidationRuleBuilder(ValidationRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMessage(instance.getMessage());
      this.withRule(instance.getRule());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidationRuleFluent<?> fluent;
  Boolean validationEnabled;
  public ValidationRule build() {
    ValidationRule buildable = new ValidationRule(fluent.getMessage(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}