package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceColumnDefinitionBuilder extends CustomResourceColumnDefinitionFluent<CustomResourceColumnDefinitionBuilder> implements VisitableBuilder<CustomResourceColumnDefinition,CustomResourceColumnDefinitionBuilder>{
  public CustomResourceColumnDefinitionBuilder() {
    this(false);
  }
  public CustomResourceColumnDefinitionBuilder(Boolean validationEnabled) {
    this(new CustomResourceColumnDefinition(), validationEnabled);
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceColumnDefinition(), validationEnabled);
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,CustomResourceColumnDefinition instance) {
    this(fluent, instance, false);
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinitionFluent<?> fluent,CustomResourceColumnDefinition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomResourceColumnDefinition());

    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withFormat(instance.getFormat());
      fluent.withJsonPath(instance.getJsonPath());
      fluent.withName(instance.getName());
      fluent.withPriority(instance.getPriority());
      fluent.withType(instance.getType());
      fluent.withDescription(instance.getDescription());
      fluent.withFormat(instance.getFormat());
      fluent.withJsonPath(instance.getJsonPath());
      fluent.withName(instance.getName());
      fluent.withPriority(instance.getPriority());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinition instance) {
    this(instance,false);
  }
  public CustomResourceColumnDefinitionBuilder(CustomResourceColumnDefinition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomResourceColumnDefinition());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withFormat(instance.getFormat());
      this.withJsonPath(instance.getJsonPath());
      this.withName(instance.getName());
      this.withPriority(instance.getPriority());
      this.withType(instance.getType());
      this.withDescription(instance.getDescription());
      this.withFormat(instance.getFormat());
      this.withJsonPath(instance.getJsonPath());
      this.withName(instance.getName());
      this.withPriority(instance.getPriority());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceColumnDefinitionFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceColumnDefinition build() {
    CustomResourceColumnDefinition buildable = new CustomResourceColumnDefinition(fluent.getDescription(),fluent.getFormat(),fluent.getJsonPath(),fluent.getName(),fluent.getPriority(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}