package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionNamesBuilder extends CustomResourceDefinitionNamesFluent<CustomResourceDefinitionNamesBuilder> implements VisitableBuilder<CustomResourceDefinitionNames,CustomResourceDefinitionNamesBuilder>{
  public CustomResourceDefinitionNamesBuilder() {
    this(false);
  }
  public CustomResourceDefinitionNamesBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionNames(), validationEnabled);
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNamesFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNamesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionNames(), validationEnabled);
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNamesFluent<?> fluent,CustomResourceDefinitionNames instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNamesFluent<?> fluent,CustomResourceDefinitionNames instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomResourceDefinitionNames());

    if (instance != null) {
      fluent.withCategories(instance.getCategories());
      fluent.withKind(instance.getKind());
      fluent.withListKind(instance.getListKind());
      fluent.withPlural(instance.getPlural());
      fluent.withShortNames(instance.getShortNames());
      fluent.withSingular(instance.getSingular());
      fluent.withCategories(instance.getCategories());
      fluent.withKind(instance.getKind());
      fluent.withListKind(instance.getListKind());
      fluent.withPlural(instance.getPlural());
      fluent.withShortNames(instance.getShortNames());
      fluent.withSingular(instance.getSingular());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNames instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionNamesBuilder(CustomResourceDefinitionNames instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomResourceDefinitionNames());

    if (instance != null) {
      this.withCategories(instance.getCategories());
      this.withKind(instance.getKind());
      this.withListKind(instance.getListKind());
      this.withPlural(instance.getPlural());
      this.withShortNames(instance.getShortNames());
      this.withSingular(instance.getSingular());
      this.withCategories(instance.getCategories());
      this.withKind(instance.getKind());
      this.withListKind(instance.getListKind());
      this.withPlural(instance.getPlural());
      this.withShortNames(instance.getShortNames());
      this.withSingular(instance.getSingular());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionNamesFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionNames build() {
    CustomResourceDefinitionNames buildable = new CustomResourceDefinitionNames(fluent.getCategories(),fluent.getKind(),fluent.getListKind(),fluent.getPlural(),fluent.getShortNames(),fluent.getSingular());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}