package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionListBuilder extends CustomResourceDefinitionListFluent<CustomResourceDefinitionListBuilder> implements VisitableBuilder<CustomResourceDefinitionList,CustomResourceDefinitionListBuilder>{
  public CustomResourceDefinitionListBuilder() {
    this(false);
  }
  public CustomResourceDefinitionListBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionList(), validationEnabled);
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionListFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionList(), validationEnabled);
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionListFluent<?> fluent,CustomResourceDefinitionList instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionListFluent<?> fluent,CustomResourceDefinitionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomResourceDefinitionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionList instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionListBuilder(CustomResourceDefinitionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomResourceDefinitionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionListFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionList build() {
    CustomResourceDefinitionList buildable = new CustomResourceDefinitionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}