package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionSpecBuilder extends CustomResourceDefinitionSpecFluent<CustomResourceDefinitionSpecBuilder> implements VisitableBuilder<CustomResourceDefinitionSpec,CustomResourceDefinitionSpecBuilder>{
  public CustomResourceDefinitionSpecBuilder() {
    this(false);
  }
  public CustomResourceDefinitionSpecBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionSpec(), validationEnabled);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionSpec(), validationEnabled);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpecFluent<?> fluent,CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomResourceDefinitionSpec());

    if (instance != null) {
      fluent.withConversion(instance.getConversion());
      fluent.withGroup(instance.getGroup());
      fluent.withNames(instance.getNames());
      fluent.withPreserveUnknownFields(instance.getPreserveUnknownFields());
      fluent.withScope(instance.getScope());
      fluent.withVersions(instance.getVersions());
      fluent.withConversion(instance.getConversion());
      fluent.withGroup(instance.getGroup());
      fluent.withNames(instance.getNames());
      fluent.withPreserveUnknownFields(instance.getPreserveUnknownFields());
      fluent.withScope(instance.getScope());
      fluent.withVersions(instance.getVersions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionSpecBuilder(CustomResourceDefinitionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomResourceDefinitionSpec());

    if (instance != null) {
      this.withConversion(instance.getConversion());
      this.withGroup(instance.getGroup());
      this.withNames(instance.getNames());
      this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
      this.withScope(instance.getScope());
      this.withVersions(instance.getVersions());
      this.withConversion(instance.getConversion());
      this.withGroup(instance.getGroup());
      this.withNames(instance.getNames());
      this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
      this.withScope(instance.getScope());
      this.withVersions(instance.getVersions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionSpec build() {
    CustomResourceDefinitionSpec buildable = new CustomResourceDefinitionSpec(fluent.buildConversion(),fluent.getGroup(),fluent.buildNames(),fluent.getPreserveUnknownFields(),fluent.getScope(),fluent.buildVersions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}