package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidationRuleBuilder extends ValidationRuleFluent<ValidationRuleBuilder> implements VisitableBuilder<ValidationRule,ValidationRuleBuilder>{
  public ValidationRuleBuilder() {
    this(false);
  }
  public ValidationRuleBuilder(Boolean validationEnabled) {
    this(new ValidationRule(), validationEnabled);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidationRule(), validationEnabled);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,ValidationRule instance) {
    this(fluent, instance, false);
  }
  public ValidationRuleBuilder(ValidationRuleFluent<?> fluent,ValidationRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidationRule());

    if (instance != null) {
      fluent.withMessage(instance.getMessage());
      fluent.withMessageExpression(instance.getMessageExpression());
      fluent.withRule(instance.getRule());
      fluent.withMessage(instance.getMessage());
      fluent.withMessageExpression(instance.getMessageExpression());
      fluent.withRule(instance.getRule());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidationRuleBuilder(ValidationRule instance) {
    this(instance,false);
  }
  public ValidationRuleBuilder(ValidationRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidationRule());

    if (instance != null) {
      this.withMessage(instance.getMessage());
      this.withMessageExpression(instance.getMessageExpression());
      this.withRule(instance.getRule());
      this.withMessage(instance.getMessage());
      this.withMessageExpression(instance.getMessageExpression());
      this.withRule(instance.getRule());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidationRuleFluent<?> fluent;
  Boolean validationEnabled;
  public ValidationRule build() {
    ValidationRule buildable = new ValidationRule(fluent.getMessage(),fluent.getMessageExpression(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}