package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConversionReviewFluent<A extends ConversionReviewFluent<A>> extends BaseFluent<A>{
  public ConversionReviewFluent() {
  }
  
  public ConversionReviewFluent(ConversionReview instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private String kind;
  private ConversionRequestBuilder request;
  private ConversionResponseBuilder response;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConversionReview instance) {
    instance = (instance != null ? instance : new ConversionReview());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withRequest(instance.getRequest());
        this.withResponse(instance.getResponse());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ConversionRequest buildRequest() {
    return this.request!=null ?this.request.build():null;
  }
  
  public A withRequest(ConversionRequest request) {
    _visitables.get("request").remove(this.request);
    if (request!=null){ this.request= new ConversionRequestBuilder(request); _visitables.get("request").add(this.request);} else { this.request = null; _visitables.get("request").remove(this.request); } return (A) this;
  }
  
  public boolean hasRequest() {
    return this.request != null;
  }
  
  public RequestNested<A> withNewRequest() {
    return new RequestNested(null);
  }
  
  public RequestNested<A> withNewRequestLike(ConversionRequest item) {
    return new RequestNested(item);
  }
  
  public RequestNested<A> editRequest() {
    return withNewRequestLike(java.util.Optional.ofNullable(buildRequest()).orElse(null));
  }
  
  public RequestNested<A> editOrNewRequest() {
    return withNewRequestLike(java.util.Optional.ofNullable(buildRequest()).orElse(new ConversionRequestBuilder().build()));
  }
  
  public RequestNested<A> editOrNewRequestLike(ConversionRequest item) {
    return withNewRequestLike(java.util.Optional.ofNullable(buildRequest()).orElse(item));
  }
  
  public ConversionResponse buildResponse() {
    return this.response!=null ?this.response.build():null;
  }
  
  public A withResponse(ConversionResponse response) {
    _visitables.get("response").remove(this.response);
    if (response!=null){ this.response= new ConversionResponseBuilder(response); _visitables.get("response").add(this.response);} else { this.response = null; _visitables.get("response").remove(this.response); } return (A) this;
  }
  
  public boolean hasResponse() {
    return this.response != null;
  }
  
  public ResponseNested<A> withNewResponse() {
    return new ResponseNested(null);
  }
  
  public ResponseNested<A> withNewResponseLike(ConversionResponse item) {
    return new ResponseNested(item);
  }
  
  public ResponseNested<A> editResponse() {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(null));
  }
  
  public ResponseNested<A> editOrNewResponse() {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(new ConversionResponseBuilder().build()));
  }
  
  public ResponseNested<A> editOrNewResponseLike(ConversionResponse item) {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConversionReviewFluent that = (ConversionReviewFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(request, that.request)) return false;
  
    if (!java.util.Objects.equals(response, that.response)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  request,  response,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (response != null) { sb.append("response:"); sb.append(response + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RequestNested<N> extends ConversionRequestFluent<RequestNested<N>> implements Nested<N>{
    RequestNested(ConversionRequest item) {
      this.builder = new ConversionRequestBuilder(this, item);
    }
    ConversionRequestBuilder builder;
    
    public N and() {
      return (N) ConversionReviewFluent.this.withRequest(builder.build());
    }
    
    public N endRequest() {
      return and();
    }
    
  
  }
  public class ResponseNested<N> extends ConversionResponseFluent<ResponseNested<N>> implements Nested<N>{
    ResponseNested(ConversionResponse item) {
      this.builder = new ConversionResponseBuilder(this, item);
    }
    ConversionResponseBuilder builder;
    
    public N and() {
      return (N) ConversionReviewFluent.this.withResponse(builder.build());
    }
    
    public N endResponse() {
      return and();
    }
    
  
  }

}