package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceValidationFluent<A extends CustomResourceValidationFluent<A>> extends BaseFluent<A>{
  public CustomResourceValidationFluent() {
  }
  
  public CustomResourceValidationFluent(CustomResourceValidation instance) {
    this.copyInstance(instance);
  }
  private JSONSchemaPropsBuilder openAPIV3Schema;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceValidation instance) {
    instance = (instance != null ? instance : new CustomResourceValidation());
  
    if (instance != null) {
        this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public JSONSchemaProps buildOpenAPIV3Schema() {
    return this.openAPIV3Schema!=null ?this.openAPIV3Schema.build():null;
  }
  
  public A withOpenAPIV3Schema(JSONSchemaProps openAPIV3Schema) {
    _visitables.get("openAPIV3Schema").remove(this.openAPIV3Schema);
    if (openAPIV3Schema!=null){ this.openAPIV3Schema= new JSONSchemaPropsBuilder(openAPIV3Schema); _visitables.get("openAPIV3Schema").add(this.openAPIV3Schema);} else { this.openAPIV3Schema = null; _visitables.get("openAPIV3Schema").remove(this.openAPIV3Schema); } return (A) this;
  }
  
  public boolean hasOpenAPIV3Schema() {
    return this.openAPIV3Schema != null;
  }
  
  public OpenAPIV3SchemaNested<A> withNewOpenAPIV3Schema() {
    return new OpenAPIV3SchemaNested(null);
  }
  
  public OpenAPIV3SchemaNested<A> withNewOpenAPIV3SchemaLike(JSONSchemaProps item) {
    return new OpenAPIV3SchemaNested(item);
  }
  
  public OpenAPIV3SchemaNested<A> editOpenAPIV3Schema() {
    return withNewOpenAPIV3SchemaLike(java.util.Optional.ofNullable(buildOpenAPIV3Schema()).orElse(null));
  }
  
  public OpenAPIV3SchemaNested<A> editOrNewOpenAPIV3Schema() {
    return withNewOpenAPIV3SchemaLike(java.util.Optional.ofNullable(buildOpenAPIV3Schema()).orElse(new JSONSchemaPropsBuilder().build()));
  }
  
  public OpenAPIV3SchemaNested<A> editOrNewOpenAPIV3SchemaLike(JSONSchemaProps item) {
    return withNewOpenAPIV3SchemaLike(java.util.Optional.ofNullable(buildOpenAPIV3Schema()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceValidationFluent that = (CustomResourceValidationFluent) o;
    if (!java.util.Objects.equals(openAPIV3Schema, that.openAPIV3Schema)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(openAPIV3Schema,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (openAPIV3Schema != null) { sb.append("openAPIV3Schema:"); sb.append(openAPIV3Schema + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OpenAPIV3SchemaNested<N> extends JSONSchemaPropsFluent<OpenAPIV3SchemaNested<N>> implements Nested<N>{
    OpenAPIV3SchemaNested(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    
    public N and() {
      return (N) CustomResourceValidationFluent.this.withOpenAPIV3Schema(builder.build());
    }
    
    public N endOpenAPIV3Schema() {
      return and();
    }
    
  
  }

}