package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>> extends BaseFluent<A>{
  public CustomResourceConversionFluent() {
  }
  
  public CustomResourceConversionFluent(CustomResourceConversion instance) {
    this.copyInstance(instance);
  }
  private List<String> conversionReviewVersions = new ArrayList<String>();
  private String strategy;
  private WebhookClientConfigBuilder webhookClientConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceConversion instance) {
    instance = (instance != null ? instance : new CustomResourceConversion());
  
    if (instance != null) {
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToConversionReviewVersions(int index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.add(index, item);
    return (A)this;
  }
  
  public A setToConversionReviewVersions(int index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.set(index, item); return (A)this;
  }
  
  public A addToConversionReviewVersions(java.lang.String... items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  
  public A addAllToConversionReviewVersions(Collection<String> items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  
  public A removeFromConversionReviewVersions(java.lang.String... items) {
    if (this.conversionReviewVersions == null) return (A)this;
    for (String item : items) { this.conversionReviewVersions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConversionReviewVersions(Collection<String> items) {
    if (this.conversionReviewVersions == null) return (A)this;
    for (String item : items) { this.conversionReviewVersions.remove(item);} return (A)this;
  }
  
  public List<String> getConversionReviewVersions() {
    return this.conversionReviewVersions;
  }
  
  public String getConversionReviewVersion(int index) {
    return this.conversionReviewVersions.get(index);
  }
  
  public String getFirstConversionReviewVersion() {
    return this.conversionReviewVersions.get(0);
  }
  
  public String getLastConversionReviewVersion() {
    return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
  }
  
  public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withConversionReviewVersions(List<String> conversionReviewVersions) {
    if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
  }
  
  public A withConversionReviewVersions(java.lang.String... conversionReviewVersions) {
    if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear(); _visitables.remove("conversionReviewVersions"); }
    if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
  }
  
  public boolean hasConversionReviewVersions() {
    return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
  }
  
  public String getStrategy() {
    return this.strategy;
  }
  
  public A withStrategy(String strategy) {
    this.strategy=strategy; return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public WebhookClientConfig buildWebhookClientConfig() {
    return this.webhookClientConfig!=null ?this.webhookClientConfig.build():null;
  }
  
  public A withWebhookClientConfig(WebhookClientConfig webhookClientConfig) {
    _visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
    if (webhookClientConfig!=null){ this.webhookClientConfig= new WebhookClientConfigBuilder(webhookClientConfig); _visitables.get("webhookClientConfig").add(this.webhookClientConfig);} else { this.webhookClientConfig = null; _visitables.get("webhookClientConfig").remove(this.webhookClientConfig); } return (A) this;
  }
  
  public boolean hasWebhookClientConfig() {
    return this.webhookClientConfig != null;
  }
  
  public WebhookClientConfigNested<A> withNewWebhookClientConfig() {
    return new WebhookClientConfigNested(null);
  }
  
  public WebhookClientConfigNested<A> withNewWebhookClientConfigLike(WebhookClientConfig item) {
    return new WebhookClientConfigNested(item);
  }
  
  public WebhookClientConfigNested<A> editWebhookClientConfig() {
    return withNewWebhookClientConfigLike(java.util.Optional.ofNullable(buildWebhookClientConfig()).orElse(null));
  }
  
  public WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
    return withNewWebhookClientConfigLike(java.util.Optional.ofNullable(buildWebhookClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
  }
  
  public WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(WebhookClientConfig item) {
    return withNewWebhookClientConfigLike(java.util.Optional.ofNullable(buildWebhookClientConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceConversionFluent that = (CustomResourceConversionFluent) o;
    if (!java.util.Objects.equals(conversionReviewVersions, that.conversionReviewVersions)) return false;
  
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
  
    if (!java.util.Objects.equals(webhookClientConfig, that.webhookClientConfig)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conversionReviewVersions,  strategy,  webhookClientConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conversionReviewVersions != null && !conversionReviewVersions.isEmpty()) { sb.append("conversionReviewVersions:"); sb.append(conversionReviewVersions + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (webhookClientConfig != null) { sb.append("webhookClientConfig:"); sb.append(webhookClientConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class WebhookClientConfigNested<N> extends WebhookClientConfigFluent<WebhookClientConfigNested<N>> implements Nested<N>{
    WebhookClientConfigNested(WebhookClientConfig item) {
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    WebhookClientConfigBuilder builder;
    
    public N and() {
      return (N) CustomResourceConversionFluent.this.withWebhookClientConfig(builder.build());
    }
    
    public N endWebhookClientConfig() {
      return and();
    }
    
  
  }

}