package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceConversionFluent<A extends CustomResourceConversionFluent<A>> extends BaseFluent<A>{
  public CustomResourceConversionFluent() {
  }
  
  public CustomResourceConversionFluent(CustomResourceConversion instance) {
    this.copyInstance(instance);
  }
  private String strategy;
  private WebhookConversionBuilder webhook;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceConversion instance) {
    instance = (instance != null ? instance : new CustomResourceConversion());
    if (instance != null) {
          this.withStrategy(instance.getStrategy());
          this.withWebhook(instance.getWebhook());
          this.withStrategy(instance.getStrategy());
          this.withWebhook(instance.getWebhook());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getStrategy() {
    return this.strategy;
  }
  
  public A withStrategy(String strategy) {
    this.strategy = strategy;
    return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public WebhookConversion buildWebhook() {
    return this.webhook != null ? this.webhook.build() : null;
  }
  
  public A withWebhook(WebhookConversion webhook) {
    this._visitables.remove(this.webhook);
    if (webhook != null) {
        this.webhook = new WebhookConversionBuilder(webhook);
        this._visitables.get("webhook").add(this.webhook);
    } else {
        this.webhook = null;
        this._visitables.get("webhook").remove(this.webhook);
    }
    return (A) this;
  }
  
  public boolean hasWebhook() {
    return this.webhook != null;
  }
  
  public WebhookNested<A> withNewWebhook() {
    return new WebhookNested(null);
  }
  
  public WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
    return new WebhookNested(item);
  }
  
  public WebhookNested<A> editWebhook() {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(null));
  }
  
  public WebhookNested<A> editOrNewWebhook() {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(new WebhookConversionBuilder().build()));
  }
  
  public WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
    return withNewWebhookLike(java.util.Optional.ofNullable(buildWebhook()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceConversionFluent that = (CustomResourceConversionFluent) o;
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
    if (!java.util.Objects.equals(webhook, that.webhook)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(strategy,  webhook,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (webhook != null) { sb.append("webhook:"); sb.append(webhook + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class WebhookNested<N> extends WebhookConversionFluent<WebhookNested<N>> implements Nested<N>{
    WebhookNested(WebhookConversion item) {
      this.builder = new WebhookConversionBuilder(this, item);
    }
    WebhookConversionBuilder builder;
    
    public N and() {
      return (N) CustomResourceConversionFluent.this.withWebhook(builder.build());
    }
    
    public N endWebhook() {
      return and();
    }
    
  
  }

}