package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JSONSchemaPropsFluent<A extends JSONSchemaPropsFluent<A>> extends BaseFluent<A>{
  public JSONSchemaPropsFluent() {
  }
  
  public JSONSchemaPropsFluent(JSONSchemaProps instance) {
    this.copyInstance(instance);
  }
  private String $ref;
  private String $schema;
  private JSONSchemaPropsOrBoolBuilder additionalItems;
  private JSONSchemaPropsOrBoolBuilder additionalProperties;
  private ArrayList<JSONSchemaPropsBuilder> allOf = new ArrayList<JSONSchemaPropsBuilder>();
  private ArrayList<JSONSchemaPropsBuilder> anyOf = new ArrayList<JSONSchemaPropsBuilder>();
  private JsonNode _default;
  private Map<String,JSONSchemaProps> definitions;
  private Map<String,JSONSchemaPropsOrStringArray> dependencies;
  private String description;
  private List<JsonNode> _enum = new ArrayList<JsonNode>();
  private JsonNode example;
  private Boolean exclusiveMaximum;
  private Boolean exclusiveMinimum;
  private ExternalDocumentationBuilder externalDocs;
  private String format;
  private String id;
  private JSONSchemaPropsOrArrayBuilder items;
  private Long maxItems;
  private Long maxLength;
  private Long maxProperties;
  private Double maximum;
  private Long minItems;
  private Long minLength;
  private Long minProperties;
  private Double minimum;
  private Double multipleOf;
  private JSONSchemaPropsBuilder not;
  private Boolean nullable;
  private ArrayList<JSONSchemaPropsBuilder> oneOf = new ArrayList<JSONSchemaPropsBuilder>();
  private String pattern;
  private Map<String,JSONSchemaProps> patternProperties;
  private Map<String,JSONSchemaProps> properties;
  private List<String> required = new ArrayList<String>();
  private String title;
  private String type;
  private Boolean uniqueItems;
  private Boolean xKubernetesEmbeddedResource;
  private Boolean xKubernetesIntOrString;
  private List<String> xKubernetesListMapKeys = new ArrayList<String>();
  private String xKubernetesListType;
  private String xKubernetesMapType;
  private Boolean xKubernetesPreserveUnknownFields;
  private ArrayList<ValidationRuleBuilder> xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();
  
  protected void copyInstance(JSONSchemaProps instance) {
    instance = (instance != null ? instance : new JSONSchemaProps());
    if (instance != null) {
          this.withRef(instance.get$ref());
          this.withSchema(instance.get$schema());
          this.withAdditionalItems(instance.getAdditionalItems());
          this.withAdditionalProperties(instance.getAdditionalProperties());
          this.withAllOf(instance.getAllOf());
          this.withAnyOf(instance.getAnyOf());
          this.withDefault(instance.getDefault());
          this.withDefinitions(instance.getDefinitions());
          this.withDependencies(instance.getDependencies());
          this.withDescription(instance.getDescription());
          this.withEnum(instance.getEnum());
          this.withExample(instance.getExample());
          this.withExclusiveMaximum(instance.getExclusiveMaximum());
          this.withExclusiveMinimum(instance.getExclusiveMinimum());
          this.withExternalDocs(instance.getExternalDocs());
          this.withFormat(instance.getFormat());
          this.withId(instance.getId());
          this.withItems(instance.getItems());
          this.withMaxItems(instance.getMaxItems());
          this.withMaxLength(instance.getMaxLength());
          this.withMaxProperties(instance.getMaxProperties());
          this.withMaximum(instance.getMaximum());
          this.withMinItems(instance.getMinItems());
          this.withMinLength(instance.getMinLength());
          this.withMinProperties(instance.getMinProperties());
          this.withMinimum(instance.getMinimum());
          this.withMultipleOf(instance.getMultipleOf());
          this.withNot(instance.getNot());
          this.withNullable(instance.getNullable());
          this.withOneOf(instance.getOneOf());
          this.withPattern(instance.getPattern());
          this.withPatternProperties(instance.getPatternProperties());
          this.withProperties(instance.getProperties());
          this.withRequired(instance.getRequired());
          this.withTitle(instance.getTitle());
          this.withType(instance.getType());
          this.withUniqueItems(instance.getUniqueItems());
          this.withXKubernetesEmbeddedResource(instance.getXKubernetesEmbeddedResource());
          this.withXKubernetesIntOrString(instance.getXKubernetesIntOrString());
          this.withXKubernetesListMapKeys(instance.getXKubernetesListMapKeys());
          this.withXKubernetesListType(instance.getXKubernetesListType());
          this.withXKubernetesMapType(instance.getXKubernetesMapType());
          this.withXKubernetesPreserveUnknownFields(instance.getXKubernetesPreserveUnknownFields());
          this.withXKubernetesValidations(instance.getXKubernetesValidations());
          this.withAdditionalItems(instance.getAdditionalItems());
          this.withAdditionalProperties(instance.getAdditionalProperties());
          this.withAllOf(instance.getAllOf());
          this.withAnyOf(instance.getAnyOf());
          this.withDefault(instance.getDefault());
          this.withDefinitions(instance.getDefinitions());
          this.withDependencies(instance.getDependencies());
          this.withDescription(instance.getDescription());
          this.withEnum(instance.getEnum());
          this.withExample(instance.getExample());
          this.withExclusiveMaximum(instance.getExclusiveMaximum());
          this.withExclusiveMinimum(instance.getExclusiveMinimum());
          this.withExternalDocs(instance.getExternalDocs());
          this.withFormat(instance.getFormat());
          this.withId(instance.getId());
          this.withItems(instance.getItems());
          this.withMaxItems(instance.getMaxItems());
          this.withMaxLength(instance.getMaxLength());
          this.withMaxProperties(instance.getMaxProperties());
          this.withMaximum(instance.getMaximum());
          this.withMinItems(instance.getMinItems());
          this.withMinLength(instance.getMinLength());
          this.withMinProperties(instance.getMinProperties());
          this.withMinimum(instance.getMinimum());
          this.withMultipleOf(instance.getMultipleOf());
          this.withNot(instance.getNot());
          this.withNullable(instance.getNullable());
          this.withOneOf(instance.getOneOf());
          this.withPattern(instance.getPattern());
          this.withPatternProperties(instance.getPatternProperties());
          this.withProperties(instance.getProperties());
          this.withRequired(instance.getRequired());
          this.withTitle(instance.getTitle());
          this.withType(instance.getType());
          this.withUniqueItems(instance.getUniqueItems());
          this.withXKubernetesEmbeddedResource(instance.getXKubernetesEmbeddedResource());
          this.withXKubernetesIntOrString(instance.getXKubernetesIntOrString());
          this.withXKubernetesListMapKeys(instance.getXKubernetesListMapKeys());
          this.withXKubernetesListType(instance.getXKubernetesListType());
          this.withXKubernetesMapType(instance.getXKubernetesMapType());
          this.withXKubernetesPreserveUnknownFields(instance.getXKubernetesPreserveUnknownFields());
          this.withXKubernetesValidations(instance.getXKubernetesValidations());
        }
  }
  
  public String getRef() {
    return this.$ref;
  }
  
  public A withRef(String $ref) {
    this.$ref = $ref;
    return (A) this;
  }
  
  public boolean hasRef() {
    return this.$ref != null;
  }
  
  public String getSchema() {
    return this.$schema;
  }
  
  public A withSchema(String $schema) {
    this.$schema = $schema;
    return (A) this;
  }
  
  public boolean hasSchema() {
    return this.$schema != null;
  }
  
  public JSONSchemaPropsOrBool buildAdditionalItems() {
    return this.additionalItems != null ? this.additionalItems.build() : null;
  }
  
  public A withAdditionalItems(JSONSchemaPropsOrBool additionalItems) {
    this._visitables.remove(this.additionalItems);
    if (additionalItems != null) {
        this.additionalItems = new JSONSchemaPropsOrBoolBuilder(additionalItems);
        this._visitables.get("additionalItems").add(this.additionalItems);
    } else {
        this.additionalItems = null;
        this._visitables.get("additionalItems").remove(this.additionalItems);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalItems() {
    return this.additionalItems != null;
  }
  
  public AdditionalItemsNested<A> withNewAdditionalItems() {
    return new AdditionalItemsNested(null);
  }
  
  public AdditionalItemsNested<A> withNewAdditionalItemsLike(JSONSchemaPropsOrBool item) {
    return new AdditionalItemsNested(item);
  }
  
  public AdditionalItemsNested<A> editAdditionalItems() {
    return withNewAdditionalItemsLike(java.util.Optional.ofNullable(buildAdditionalItems()).orElse(null));
  }
  
  public AdditionalItemsNested<A> editOrNewAdditionalItems() {
    return withNewAdditionalItemsLike(java.util.Optional.ofNullable(buildAdditionalItems()).orElse(new JSONSchemaPropsOrBoolBuilder().build()));
  }
  
  public AdditionalItemsNested<A> editOrNewAdditionalItemsLike(JSONSchemaPropsOrBool item) {
    return withNewAdditionalItemsLike(java.util.Optional.ofNullable(buildAdditionalItems()).orElse(item));
  }
  
  public JSONSchemaPropsOrBool buildAdditionalProperties() {
    return this.additionalProperties != null ? this.additionalProperties.build() : null;
  }
  
  public A withAdditionalProperties(JSONSchemaPropsOrBool additionalProperties) {
    this._visitables.remove(this.additionalProperties);
    if (additionalProperties != null) {
        this.additionalProperties = new JSONSchemaPropsOrBoolBuilder(additionalProperties);
        this._visitables.get("additionalProperties").add(this.additionalProperties);
    } else {
        this.additionalProperties = null;
        this._visitables.get("additionalProperties").remove(this.additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public AdditionalPropertiesNested<A> withNewAdditionalProperties() {
    return new AdditionalPropertiesNested(null);
  }
  
  public AdditionalPropertiesNested<A> withNewAdditionalPropertiesLike(JSONSchemaPropsOrBool item) {
    return new AdditionalPropertiesNested(item);
  }
  
  public AdditionalPropertiesNested<A> editAdditionalProperties() {
    return withNewAdditionalPropertiesLike(java.util.Optional.ofNullable(buildAdditionalProperties()).orElse(null));
  }
  
  public AdditionalPropertiesNested<A> editOrNewAdditionalProperties() {
    return withNewAdditionalPropertiesLike(java.util.Optional.ofNullable(buildAdditionalProperties()).orElse(new JSONSchemaPropsOrBoolBuilder().build()));
  }
  
  public AdditionalPropertiesNested<A> editOrNewAdditionalPropertiesLike(JSONSchemaPropsOrBool item) {
    return withNewAdditionalPropertiesLike(java.util.Optional.ofNullable(buildAdditionalProperties()).orElse(item));
  }
  
  public A addToAllOf(int index,JSONSchemaProps item) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= allOf.size()) { _visitables.get("allOf").add(builder); allOf.add(builder); } else { _visitables.get("allOf").add(index, builder); allOf.add(index, builder);}
    return (A)this;
  }
  
  public A setToAllOf(int index,JSONSchemaProps item) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= allOf.size()) { _visitables.get("allOf").add(builder); allOf.add(builder); } else { _visitables.get("allOf").set(index, builder); allOf.set(index, builder);}
    return (A)this;
  }
  
  public A addToAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").add(builder);this.allOf.add(builder);} return (A)this;
  }
  
  public A addAllToAllOf(Collection<JSONSchemaProps> items) {
    if (this.allOf == null) {this.allOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").add(builder);this.allOf.add(builder);} return (A)this;
  }
  
  public A removeFromAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.allOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").remove(builder); this.allOf.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAllOf(Collection<JSONSchemaProps> items) {
    if (this.allOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("allOf").remove(builder); this.allOf.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (allOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = allOf.iterator();
    final List visitables = _visitables.get("allOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JSONSchemaProps> buildAllOf() {
    return this.allOf != null ? build(allOf) : null;
  }
  
  public JSONSchemaProps buildAllOf(int index) {
    return this.allOf.get(index).build();
  }
  
  public JSONSchemaProps buildFirstAllOf() {
    return this.allOf.get(0).build();
  }
  
  public JSONSchemaProps buildLastAllOf() {
    return this.allOf.get(allOf.size() - 1).build();
  }
  
  public JSONSchemaProps buildMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : allOf) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : allOf) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAllOf(List<JSONSchemaProps> allOf) {
    if (this.allOf != null) {
      this._visitables.get("allOf").clear();
    }
    if (allOf != null) {
        this.allOf = new ArrayList();
        for (JSONSchemaProps item : allOf) {
          this.addToAllOf(item);
        }
    } else {
      this.allOf = null;
    }
    return (A) this;
  }
  
  public A withAllOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... allOf) {
    if (this.allOf != null) {this.allOf.clear(); _visitables.remove("allOf"); }
    if (allOf != null) {for (JSONSchemaProps item :allOf){ this.addToAllOf(item);}} return (A) this;
  }
  
  public boolean hasAllOf() {
    return this.allOf != null && !this.allOf.isEmpty();
  }
  
  public AllOfNested<A> addNewAllOf() {
    return new AllOfNested(-1, null);
  }
  
  public AllOfNested<A> addNewAllOfLike(JSONSchemaProps item) {
    return new AllOfNested(-1, item);
  }
  
  public AllOfNested<A> setNewAllOfLike(int index,JSONSchemaProps item) {
    return new AllOfNested(index, item);
  }
  
  public AllOfNested<A> editAllOf(int index) {
    if (allOf.size() <= index) throw new RuntimeException("Can't edit allOf. Index exceeds size.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  
  public AllOfNested<A> editFirstAllOf() {
    if (allOf.size() == 0) throw new RuntimeException("Can't edit first allOf. The list is empty.");
    return setNewAllOfLike(0, buildAllOf(0));
  }
  
  public AllOfNested<A> editLastAllOf() {
    int index = allOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allOf. The list is empty.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  
  public AllOfNested<A> editMatchingAllOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allOf.size();i++) { 
    if (predicate.test(allOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allOf. No match found.");
    return setNewAllOfLike(index, buildAllOf(index));
  }
  
  public A addToAnyOf(int index,JSONSchemaProps item) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= anyOf.size()) { _visitables.get("anyOf").add(builder); anyOf.add(builder); } else { _visitables.get("anyOf").add(index, builder); anyOf.add(index, builder);}
    return (A)this;
  }
  
  public A setToAnyOf(int index,JSONSchemaProps item) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= anyOf.size()) { _visitables.get("anyOf").add(builder); anyOf.add(builder); } else { _visitables.get("anyOf").set(index, builder); anyOf.set(index, builder);}
    return (A)this;
  }
  
  public A addToAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").add(builder);this.anyOf.add(builder);} return (A)this;
  }
  
  public A addAllToAnyOf(Collection<JSONSchemaProps> items) {
    if (this.anyOf == null) {this.anyOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").add(builder);this.anyOf.add(builder);} return (A)this;
  }
  
  public A removeFromAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.anyOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").remove(builder); this.anyOf.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAnyOf(Collection<JSONSchemaProps> items) {
    if (this.anyOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("anyOf").remove(builder); this.anyOf.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (anyOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = anyOf.iterator();
    final List visitables = _visitables.get("anyOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JSONSchemaProps> buildAnyOf() {
    return this.anyOf != null ? build(anyOf) : null;
  }
  
  public JSONSchemaProps buildAnyOf(int index) {
    return this.anyOf.get(index).build();
  }
  
  public JSONSchemaProps buildFirstAnyOf() {
    return this.anyOf.get(0).build();
  }
  
  public JSONSchemaProps buildLastAnyOf() {
    return this.anyOf.get(anyOf.size() - 1).build();
  }
  
  public JSONSchemaProps buildMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : anyOf) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : anyOf) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAnyOf(List<JSONSchemaProps> anyOf) {
    if (this.anyOf != null) {
      this._visitables.get("anyOf").clear();
    }
    if (anyOf != null) {
        this.anyOf = new ArrayList();
        for (JSONSchemaProps item : anyOf) {
          this.addToAnyOf(item);
        }
    } else {
      this.anyOf = null;
    }
    return (A) this;
  }
  
  public A withAnyOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... anyOf) {
    if (this.anyOf != null) {this.anyOf.clear(); _visitables.remove("anyOf"); }
    if (anyOf != null) {for (JSONSchemaProps item :anyOf){ this.addToAnyOf(item);}} return (A) this;
  }
  
  public boolean hasAnyOf() {
    return this.anyOf != null && !this.anyOf.isEmpty();
  }
  
  public AnyOfNested<A> addNewAnyOf() {
    return new AnyOfNested(-1, null);
  }
  
  public AnyOfNested<A> addNewAnyOfLike(JSONSchemaProps item) {
    return new AnyOfNested(-1, item);
  }
  
  public AnyOfNested<A> setNewAnyOfLike(int index,JSONSchemaProps item) {
    return new AnyOfNested(index, item);
  }
  
  public AnyOfNested<A> editAnyOf(int index) {
    if (anyOf.size() <= index) throw new RuntimeException("Can't edit anyOf. Index exceeds size.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  
  public AnyOfNested<A> editFirstAnyOf() {
    if (anyOf.size() == 0) throw new RuntimeException("Can't edit first anyOf. The list is empty.");
    return setNewAnyOfLike(0, buildAnyOf(0));
  }
  
  public AnyOfNested<A> editLastAnyOf() {
    int index = anyOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last anyOf. The list is empty.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  
  public AnyOfNested<A> editMatchingAnyOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<anyOf.size();i++) { 
    if (predicate.test(anyOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching anyOf. No match found.");
    return setNewAnyOfLike(index, buildAnyOf(index));
  }
  
  public JsonNode getDefault() {
    return this._default;
  }
  
  public A withDefault(JsonNode _default) {
    this._default = _default;
    return (A) this;
  }
  
  public boolean hasDefault() {
    return this._default != null;
  }
  
  public A addToDefinitions(String key,JSONSchemaProps value) {
    if(this.definitions == null && key != null && value != null) { this.definitions = new LinkedHashMap(); }
    if(key != null && value != null) {this.definitions.put(key, value);} return (A)this;
  }
  
  public A addToDefinitions(Map<String,JSONSchemaProps> map) {
    if(this.definitions == null && map != null) { this.definitions = new LinkedHashMap(); }
    if(map != null) { this.definitions.putAll(map);} return (A)this;
  }
  
  public A removeFromDefinitions(String key) {
    if(this.definitions == null) { return (A) this; }
    if(key != null && this.definitions != null) {this.definitions.remove(key);} return (A)this;
  }
  
  public A removeFromDefinitions(Map<String,JSONSchemaProps> map) {
    if(this.definitions == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.definitions != null){this.definitions.remove(key);}}} return (A)this;
  }
  
  public Map<String,JSONSchemaProps> getDefinitions() {
    return this.definitions;
  }
  
  public <K,V>A withDefinitions(Map<String,JSONSchemaProps> definitions) {
    if (definitions == null) {
      this.definitions = null;
    } else {
      this.definitions = new LinkedHashMap(definitions);
    }
    return (A) this;
  }
  
  public boolean hasDefinitions() {
    return this.definitions != null;
  }
  
  public A addToDependencies(String key,JSONSchemaPropsOrStringArray value) {
    if(this.dependencies == null && key != null && value != null) { this.dependencies = new LinkedHashMap(); }
    if(key != null && value != null) {this.dependencies.put(key, value);} return (A)this;
  }
  
  public A addToDependencies(Map<String,JSONSchemaPropsOrStringArray> map) {
    if(this.dependencies == null && map != null) { this.dependencies = new LinkedHashMap(); }
    if(map != null) { this.dependencies.putAll(map);} return (A)this;
  }
  
  public A removeFromDependencies(String key) {
    if(this.dependencies == null) { return (A) this; }
    if(key != null && this.dependencies != null) {this.dependencies.remove(key);} return (A)this;
  }
  
  public A removeFromDependencies(Map<String,JSONSchemaPropsOrStringArray> map) {
    if(this.dependencies == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.dependencies != null){this.dependencies.remove(key);}}} return (A)this;
  }
  
  public Map<String,JSONSchemaPropsOrStringArray> getDependencies() {
    return this.dependencies;
  }
  
  public <K,V>A withDependencies(Map<String,JSONSchemaPropsOrStringArray> dependencies) {
    if (dependencies == null) {
      this.dependencies = null;
    } else {
      this.dependencies = new LinkedHashMap(dependencies);
    }
    return (A) this;
  }
  
  public boolean hasDependencies() {
    return this.dependencies != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public A addToEnum(int index,JsonNode item) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    this._enum.add(index, item);
    return (A)this;
  }
  
  public A setToEnum(int index,JsonNode item) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    this._enum.set(index, item); return (A)this;
  }
  
  public A addToEnum(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this._enum.add(item);} return (A)this;
  }
  
  public A addAllToEnum(Collection<JsonNode> items) {
    if (this._enum == null) {this._enum = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this._enum.add(item);} return (A)this;
  }
  
  public A removeFromEnum(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this._enum == null) return (A)this;
    for (JsonNode item : items) { this._enum.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnum(Collection<JsonNode> items) {
    if (this._enum == null) return (A)this;
    for (JsonNode item : items) { this._enum.remove(item);} return (A)this;
  }
  
  public List<JsonNode> getEnum() {
    return this._enum;
  }
  
  public JsonNode getEnum(int index) {
    return this._enum.get(index);
  }
  
  public JsonNode getFirstEnum() {
    return this._enum.get(0);
  }
  
  public JsonNode getLastEnum() {
    return this._enum.get(_enum.size() - 1);
  }
  
  public JsonNode getMatchingEnum(Predicate<JsonNode> predicate) {
      for (JsonNode item : _enum) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnum(Predicate<JsonNode> predicate) {
      for (JsonNode item : _enum) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnum(List<JsonNode> _enum) {
    if (_enum != null) {
        this._enum = new ArrayList();
        for (JsonNode item : _enum) {
          this.addToEnum(item);
        }
    } else {
      this._enum = null;
    }
    return (A) this;
  }
  
  public A withEnum(com.fasterxml.jackson.databind.JsonNode... _enum) {
    if (this._enum != null) {this._enum.clear(); _visitables.remove("_enum"); }
    if (_enum != null) {for (JsonNode item :_enum){ this.addToEnum(item);}} return (A) this;
  }
  
  public boolean hasEnum() {
    return this._enum != null && !this._enum.isEmpty();
  }
  
  public JsonNode getExample() {
    return this.example;
  }
  
  public A withExample(JsonNode example) {
    this.example = example;
    return (A) this;
  }
  
  public boolean hasExample() {
    return this.example != null;
  }
  
  public Boolean getExclusiveMaximum() {
    return this.exclusiveMaximum;
  }
  
  public A withExclusiveMaximum(Boolean exclusiveMaximum) {
    this.exclusiveMaximum = exclusiveMaximum;
    return (A) this;
  }
  
  public boolean hasExclusiveMaximum() {
    return this.exclusiveMaximum != null;
  }
  
  public Boolean getExclusiveMinimum() {
    return this.exclusiveMinimum;
  }
  
  public A withExclusiveMinimum(Boolean exclusiveMinimum) {
    this.exclusiveMinimum = exclusiveMinimum;
    return (A) this;
  }
  
  public boolean hasExclusiveMinimum() {
    return this.exclusiveMinimum != null;
  }
  
  public ExternalDocumentation buildExternalDocs() {
    return this.externalDocs != null ? this.externalDocs.build() : null;
  }
  
  public A withExternalDocs(ExternalDocumentation externalDocs) {
    this._visitables.remove(this.externalDocs);
    if (externalDocs != null) {
        this.externalDocs = new ExternalDocumentationBuilder(externalDocs);
        this._visitables.get("externalDocs").add(this.externalDocs);
    } else {
        this.externalDocs = null;
        this._visitables.get("externalDocs").remove(this.externalDocs);
    }
    return (A) this;
  }
  
  public boolean hasExternalDocs() {
    return this.externalDocs != null;
  }
  
  public A withNewExternalDocs(String description,String url) {
    return (A)withExternalDocs(new ExternalDocumentation(description, url));
  }
  
  public ExternalDocsNested<A> withNewExternalDocs() {
    return new ExternalDocsNested(null);
  }
  
  public ExternalDocsNested<A> withNewExternalDocsLike(ExternalDocumentation item) {
    return new ExternalDocsNested(item);
  }
  
  public ExternalDocsNested<A> editExternalDocs() {
    return withNewExternalDocsLike(java.util.Optional.ofNullable(buildExternalDocs()).orElse(null));
  }
  
  public ExternalDocsNested<A> editOrNewExternalDocs() {
    return withNewExternalDocsLike(java.util.Optional.ofNullable(buildExternalDocs()).orElse(new ExternalDocumentationBuilder().build()));
  }
  
  public ExternalDocsNested<A> editOrNewExternalDocsLike(ExternalDocumentation item) {
    return withNewExternalDocsLike(java.util.Optional.ofNullable(buildExternalDocs()).orElse(item));
  }
  
  public String getFormat() {
    return this.format;
  }
  
  public A withFormat(String format) {
    this.format = format;
    return (A) this;
  }
  
  public boolean hasFormat() {
    return this.format != null;
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public JSONSchemaPropsOrArray buildItems() {
    return this.items != null ? this.items.build() : null;
  }
  
  public A withItems(JSONSchemaPropsOrArray items) {
    this._visitables.remove(this.items);
    if (items != null) {
        this.items = new JSONSchemaPropsOrArrayBuilder(items);
        this._visitables.get("items").add(this.items);
    } else {
        this.items = null;
        this._visitables.get("items").remove(this.items);
    }
    return (A) this;
  }
  
  public boolean hasItems() {
    return this.items != null;
  }
  
  public ItemsNested<A> withNewItems() {
    return new ItemsNested(null);
  }
  
  public ItemsNested<A> withNewItemsLike(JSONSchemaPropsOrArray item) {
    return new ItemsNested(item);
  }
  
  public ItemsNested<A> editItems() {
    return withNewItemsLike(java.util.Optional.ofNullable(buildItems()).orElse(null));
  }
  
  public ItemsNested<A> editOrNewItems() {
    return withNewItemsLike(java.util.Optional.ofNullable(buildItems()).orElse(new JSONSchemaPropsOrArrayBuilder().build()));
  }
  
  public ItemsNested<A> editOrNewItemsLike(JSONSchemaPropsOrArray item) {
    return withNewItemsLike(java.util.Optional.ofNullable(buildItems()).orElse(item));
  }
  
  public Long getMaxItems() {
    return this.maxItems;
  }
  
  public A withMaxItems(Long maxItems) {
    this.maxItems = maxItems;
    return (A) this;
  }
  
  public boolean hasMaxItems() {
    return this.maxItems != null;
  }
  
  public Long getMaxLength() {
    return this.maxLength;
  }
  
  public A withMaxLength(Long maxLength) {
    this.maxLength = maxLength;
    return (A) this;
  }
  
  public boolean hasMaxLength() {
    return this.maxLength != null;
  }
  
  public Long getMaxProperties() {
    return this.maxProperties;
  }
  
  public A withMaxProperties(Long maxProperties) {
    this.maxProperties = maxProperties;
    return (A) this;
  }
  
  public boolean hasMaxProperties() {
    return this.maxProperties != null;
  }
  
  public Double getMaximum() {
    return this.maximum;
  }
  
  public A withMaximum(Double maximum) {
    this.maximum = maximum;
    return (A) this;
  }
  
  public boolean hasMaximum() {
    return this.maximum != null;
  }
  
  public Long getMinItems() {
    return this.minItems;
  }
  
  public A withMinItems(Long minItems) {
    this.minItems = minItems;
    return (A) this;
  }
  
  public boolean hasMinItems() {
    return this.minItems != null;
  }
  
  public Long getMinLength() {
    return this.minLength;
  }
  
  public A withMinLength(Long minLength) {
    this.minLength = minLength;
    return (A) this;
  }
  
  public boolean hasMinLength() {
    return this.minLength != null;
  }
  
  public Long getMinProperties() {
    return this.minProperties;
  }
  
  public A withMinProperties(Long minProperties) {
    this.minProperties = minProperties;
    return (A) this;
  }
  
  public boolean hasMinProperties() {
    return this.minProperties != null;
  }
  
  public Double getMinimum() {
    return this.minimum;
  }
  
  public A withMinimum(Double minimum) {
    this.minimum = minimum;
    return (A) this;
  }
  
  public boolean hasMinimum() {
    return this.minimum != null;
  }
  
  public Double getMultipleOf() {
    return this.multipleOf;
  }
  
  public A withMultipleOf(Double multipleOf) {
    this.multipleOf = multipleOf;
    return (A) this;
  }
  
  public boolean hasMultipleOf() {
    return this.multipleOf != null;
  }
  
  public JSONSchemaProps buildNot() {
    return this.not != null ? this.not.build() : null;
  }
  
  public A withNot(JSONSchemaProps not) {
    this._visitables.remove(this.not);
    if (not != null) {
        this.not = new JSONSchemaPropsBuilder(not);
        this._visitables.get("not").add(this.not);
    } else {
        this.not = null;
        this._visitables.get("not").remove(this.not);
    }
    return (A) this;
  }
  
  public boolean hasNot() {
    return this.not != null;
  }
  
  public NotNested<A> withNewNot() {
    return new NotNested(null);
  }
  
  public NotNested<A> withNewNotLike(JSONSchemaProps item) {
    return new NotNested(item);
  }
  
  public NotNested<A> editNot() {
    return withNewNotLike(java.util.Optional.ofNullable(buildNot()).orElse(null));
  }
  
  public NotNested<A> editOrNewNot() {
    return withNewNotLike(java.util.Optional.ofNullable(buildNot()).orElse(new JSONSchemaPropsBuilder().build()));
  }
  
  public NotNested<A> editOrNewNotLike(JSONSchemaProps item) {
    return withNewNotLike(java.util.Optional.ofNullable(buildNot()).orElse(item));
  }
  
  public Boolean getNullable() {
    return this.nullable;
  }
  
  public A withNullable(Boolean nullable) {
    this.nullable = nullable;
    return (A) this;
  }
  
  public boolean hasNullable() {
    return this.nullable != null;
  }
  
  public A addToOneOf(int index,JSONSchemaProps item) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= oneOf.size()) { _visitables.get("oneOf").add(builder); oneOf.add(builder); } else { _visitables.get("oneOf").add(index, builder); oneOf.add(index, builder);}
    return (A)this;
  }
  
  public A setToOneOf(int index,JSONSchemaProps item) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
    if (index < 0 || index >= oneOf.size()) { _visitables.get("oneOf").add(builder); oneOf.add(builder); } else { _visitables.get("oneOf").set(index, builder); oneOf.set(index, builder);}
    return (A)this;
  }
  
  public A addToOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").add(builder);this.oneOf.add(builder);} return (A)this;
  }
  
  public A addAllToOneOf(Collection<JSONSchemaProps> items) {
    if (this.oneOf == null) {this.oneOf = new ArrayList<JSONSchemaPropsBuilder>();}
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").add(builder);this.oneOf.add(builder);} return (A)this;
  }
  
  public A removeFromOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... items) {
    if (this.oneOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").remove(builder); this.oneOf.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOneOf(Collection<JSONSchemaProps> items) {
    if (this.oneOf == null) return (A)this;
    for (JSONSchemaProps item : items) {JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);_visitables.get("oneOf").remove(builder); this.oneOf.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    if (oneOf == null) return (A) this;
    final Iterator<JSONSchemaPropsBuilder> each = oneOf.iterator();
    final List visitables = _visitables.get("oneOf");
    while (each.hasNext()) {
      JSONSchemaPropsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JSONSchemaProps> buildOneOf() {
    return this.oneOf != null ? build(oneOf) : null;
  }
  
  public JSONSchemaProps buildOneOf(int index) {
    return this.oneOf.get(index).build();
  }
  
  public JSONSchemaProps buildFirstOneOf() {
    return this.oneOf.get(0).build();
  }
  
  public JSONSchemaProps buildLastOneOf() {
    return this.oneOf.get(oneOf.size() - 1).build();
  }
  
  public JSONSchemaProps buildMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : oneOf) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
      for (JSONSchemaPropsBuilder item : oneOf) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOneOf(List<JSONSchemaProps> oneOf) {
    if (this.oneOf != null) {
      this._visitables.get("oneOf").clear();
    }
    if (oneOf != null) {
        this.oneOf = new ArrayList();
        for (JSONSchemaProps item : oneOf) {
          this.addToOneOf(item);
        }
    } else {
      this.oneOf = null;
    }
    return (A) this;
  }
  
  public A withOneOf(io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps... oneOf) {
    if (this.oneOf != null) {this.oneOf.clear(); _visitables.remove("oneOf"); }
    if (oneOf != null) {for (JSONSchemaProps item :oneOf){ this.addToOneOf(item);}} return (A) this;
  }
  
  public boolean hasOneOf() {
    return this.oneOf != null && !this.oneOf.isEmpty();
  }
  
  public OneOfNested<A> addNewOneOf() {
    return new OneOfNested(-1, null);
  }
  
  public OneOfNested<A> addNewOneOfLike(JSONSchemaProps item) {
    return new OneOfNested(-1, item);
  }
  
  public OneOfNested<A> setNewOneOfLike(int index,JSONSchemaProps item) {
    return new OneOfNested(index, item);
  }
  
  public OneOfNested<A> editOneOf(int index) {
    if (oneOf.size() <= index) throw new RuntimeException("Can't edit oneOf. Index exceeds size.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  
  public OneOfNested<A> editFirstOneOf() {
    if (oneOf.size() == 0) throw new RuntimeException("Can't edit first oneOf. The list is empty.");
    return setNewOneOfLike(0, buildOneOf(0));
  }
  
  public OneOfNested<A> editLastOneOf() {
    int index = oneOf.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last oneOf. The list is empty.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  
  public OneOfNested<A> editMatchingOneOf(Predicate<JSONSchemaPropsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<oneOf.size();i++) { 
    if (predicate.test(oneOf.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching oneOf. No match found.");
    return setNewOneOfLike(index, buildOneOf(index));
  }
  
  public String getPattern() {
    return this.pattern;
  }
  
  public A withPattern(String pattern) {
    this.pattern = pattern;
    return (A) this;
  }
  
  public boolean hasPattern() {
    return this.pattern != null;
  }
  
  public A addToPatternProperties(String key,JSONSchemaProps value) {
    if(this.patternProperties == null && key != null && value != null) { this.patternProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.patternProperties.put(key, value);} return (A)this;
  }
  
  public A addToPatternProperties(Map<String,JSONSchemaProps> map) {
    if(this.patternProperties == null && map != null) { this.patternProperties = new LinkedHashMap(); }
    if(map != null) { this.patternProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromPatternProperties(String key) {
    if(this.patternProperties == null) { return (A) this; }
    if(key != null && this.patternProperties != null) {this.patternProperties.remove(key);} return (A)this;
  }
  
  public A removeFromPatternProperties(Map<String,JSONSchemaProps> map) {
    if(this.patternProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.patternProperties != null){this.patternProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,JSONSchemaProps> getPatternProperties() {
    return this.patternProperties;
  }
  
  public <K,V>A withPatternProperties(Map<String,JSONSchemaProps> patternProperties) {
    if (patternProperties == null) {
      this.patternProperties = null;
    } else {
      this.patternProperties = new LinkedHashMap(patternProperties);
    }
    return (A) this;
  }
  
  public boolean hasPatternProperties() {
    return this.patternProperties != null;
  }
  
  public A addToProperties(String key,JSONSchemaProps value) {
    if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap(); }
    if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
  }
  
  public A addToProperties(Map<String,JSONSchemaProps> map) {
    if(this.properties == null && map != null) { this.properties = new LinkedHashMap(); }
    if(map != null) { this.properties.putAll(map);} return (A)this;
  }
  
  public A removeFromProperties(String key) {
    if(this.properties == null) { return (A) this; }
    if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
  }
  
  public A removeFromProperties(Map<String,JSONSchemaProps> map) {
    if(this.properties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
  }
  
  public Map<String,JSONSchemaProps> getProperties() {
    return this.properties;
  }
  
  public <K,V>A withProperties(Map<String,JSONSchemaProps> properties) {
    if (properties == null) {
      this.properties = null;
    } else {
      this.properties = new LinkedHashMap(properties);
    }
    return (A) this;
  }
  
  public boolean hasProperties() {
    return this.properties != null;
  }
  
  public A addToRequired(int index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.add(index, item);
    return (A)this;
  }
  
  public A setToRequired(int index,String item) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    this.required.set(index, item); return (A)this;
  }
  
  public A addToRequired(java.lang.String... items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  
  public A addAllToRequired(Collection<String> items) {
    if (this.required == null) {this.required = new ArrayList<String>();}
    for (String item : items) {this.required.add(item);} return (A)this;
  }
  
  public A removeFromRequired(java.lang.String... items) {
    if (this.required == null) return (A)this;
    for (String item : items) { this.required.remove(item);} return (A)this;
  }
  
  public A removeAllFromRequired(Collection<String> items) {
    if (this.required == null) return (A)this;
    for (String item : items) { this.required.remove(item);} return (A)this;
  }
  
  public List<String> getRequired() {
    return this.required;
  }
  
  public String getRequired(int index) {
    return this.required.get(index);
  }
  
  public String getFirstRequired() {
    return this.required.get(0);
  }
  
  public String getLastRequired() {
    return this.required.get(required.size() - 1);
  }
  
  public String getMatchingRequired(Predicate<String> predicate) {
      for (String item : required) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingRequired(Predicate<String> predicate) {
      for (String item : required) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRequired(List<String> required) {
    if (required != null) {
        this.required = new ArrayList();
        for (String item : required) {
          this.addToRequired(item);
        }
    } else {
      this.required = null;
    }
    return (A) this;
  }
  
  public A withRequired(java.lang.String... required) {
    if (this.required != null) {this.required.clear(); _visitables.remove("required"); }
    if (required != null) {for (String item :required){ this.addToRequired(item);}} return (A) this;
  }
  
  public boolean hasRequired() {
    return this.required != null && !this.required.isEmpty();
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public Boolean getUniqueItems() {
    return this.uniqueItems;
  }
  
  public A withUniqueItems(Boolean uniqueItems) {
    this.uniqueItems = uniqueItems;
    return (A) this;
  }
  
  public boolean hasUniqueItems() {
    return this.uniqueItems != null;
  }
  
  public Boolean getXKubernetesEmbeddedResource() {
    return this.xKubernetesEmbeddedResource;
  }
  
  public A withXKubernetesEmbeddedResource(Boolean xKubernetesEmbeddedResource) {
    this.xKubernetesEmbeddedResource = xKubernetesEmbeddedResource;
    return (A) this;
  }
  
  public boolean hasXKubernetesEmbeddedResource() {
    return this.xKubernetesEmbeddedResource != null;
  }
  
  public Boolean getXKubernetesIntOrString() {
    return this.xKubernetesIntOrString;
  }
  
  public A withXKubernetesIntOrString(Boolean xKubernetesIntOrString) {
    this.xKubernetesIntOrString = xKubernetesIntOrString;
    return (A) this;
  }
  
  public boolean hasXKubernetesIntOrString() {
    return this.xKubernetesIntOrString != null;
  }
  
  public A addToXKubernetesListMapKeys(int index,String item) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    this.xKubernetesListMapKeys.add(index, item);
    return (A)this;
  }
  
  public A setToXKubernetesListMapKeys(int index,String item) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    this.xKubernetesListMapKeys.set(index, item); return (A)this;
  }
  
  public A addToXKubernetesListMapKeys(java.lang.String... items) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    for (String item : items) {this.xKubernetesListMapKeys.add(item);} return (A)this;
  }
  
  public A addAllToXKubernetesListMapKeys(Collection<String> items) {
    if (this.xKubernetesListMapKeys == null) {this.xKubernetesListMapKeys = new ArrayList<String>();}
    for (String item : items) {this.xKubernetesListMapKeys.add(item);} return (A)this;
  }
  
  public A removeFromXKubernetesListMapKeys(java.lang.String... items) {
    if (this.xKubernetesListMapKeys == null) return (A)this;
    for (String item : items) { this.xKubernetesListMapKeys.remove(item);} return (A)this;
  }
  
  public A removeAllFromXKubernetesListMapKeys(Collection<String> items) {
    if (this.xKubernetesListMapKeys == null) return (A)this;
    for (String item : items) { this.xKubernetesListMapKeys.remove(item);} return (A)this;
  }
  
  public List<String> getXKubernetesListMapKeys() {
    return this.xKubernetesListMapKeys;
  }
  
  public String getXKubernetesListMapKey(int index) {
    return this.xKubernetesListMapKeys.get(index);
  }
  
  public String getFirstXKubernetesListMapKey() {
    return this.xKubernetesListMapKeys.get(0);
  }
  
  public String getLastXKubernetesListMapKey() {
    return this.xKubernetesListMapKeys.get(xKubernetesListMapKeys.size() - 1);
  }
  
  public String getMatchingXKubernetesListMapKey(Predicate<String> predicate) {
      for (String item : xKubernetesListMapKeys) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingXKubernetesListMapKey(Predicate<String> predicate) {
      for (String item : xKubernetesListMapKeys) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withXKubernetesListMapKeys(List<String> xKubernetesListMapKeys) {
    if (xKubernetesListMapKeys != null) {
        this.xKubernetesListMapKeys = new ArrayList();
        for (String item : xKubernetesListMapKeys) {
          this.addToXKubernetesListMapKeys(item);
        }
    } else {
      this.xKubernetesListMapKeys = null;
    }
    return (A) this;
  }
  
  public A withXKubernetesListMapKeys(java.lang.String... xKubernetesListMapKeys) {
    if (this.xKubernetesListMapKeys != null) {this.xKubernetesListMapKeys.clear(); _visitables.remove("xKubernetesListMapKeys"); }
    if (xKubernetesListMapKeys != null) {for (String item :xKubernetesListMapKeys){ this.addToXKubernetesListMapKeys(item);}} return (A) this;
  }
  
  public boolean hasXKubernetesListMapKeys() {
    return this.xKubernetesListMapKeys != null && !this.xKubernetesListMapKeys.isEmpty();
  }
  
  public String getXKubernetesListType() {
    return this.xKubernetesListType;
  }
  
  public A withXKubernetesListType(String xKubernetesListType) {
    this.xKubernetesListType = xKubernetesListType;
    return (A) this;
  }
  
  public boolean hasXKubernetesListType() {
    return this.xKubernetesListType != null;
  }
  
  public String getXKubernetesMapType() {
    return this.xKubernetesMapType;
  }
  
  public A withXKubernetesMapType(String xKubernetesMapType) {
    this.xKubernetesMapType = xKubernetesMapType;
    return (A) this;
  }
  
  public boolean hasXKubernetesMapType() {
    return this.xKubernetesMapType != null;
  }
  
  public Boolean getXKubernetesPreserveUnknownFields() {
    return this.xKubernetesPreserveUnknownFields;
  }
  
  public A withXKubernetesPreserveUnknownFields(Boolean xKubernetesPreserveUnknownFields) {
    this.xKubernetesPreserveUnknownFields = xKubernetesPreserveUnknownFields;
    return (A) this;
  }
  
  public boolean hasXKubernetesPreserveUnknownFields() {
    return this.xKubernetesPreserveUnknownFields != null;
  }
  
  public A addToXKubernetesValidations(int index,ValidationRule item) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);
    if (index < 0 || index >= xKubernetesValidations.size()) { _visitables.get("xKubernetesValidations").add(builder); xKubernetesValidations.add(builder); } else { _visitables.get("xKubernetesValidations").add(index, builder); xKubernetesValidations.add(index, builder);}
    return (A)this;
  }
  
  public A setToXKubernetesValidations(int index,ValidationRule item) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    ValidationRuleBuilder builder = new ValidationRuleBuilder(item);
    if (index < 0 || index >= xKubernetesValidations.size()) { _visitables.get("xKubernetesValidations").add(builder); xKubernetesValidations.add(builder); } else { _visitables.get("xKubernetesValidations").set(index, builder); xKubernetesValidations.set(index, builder);}
    return (A)this;
  }
  
  public A addToXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1.ValidationRule... items) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").add(builder);this.xKubernetesValidations.add(builder);} return (A)this;
  }
  
  public A addAllToXKubernetesValidations(Collection<ValidationRule> items) {
    if (this.xKubernetesValidations == null) {this.xKubernetesValidations = new ArrayList<ValidationRuleBuilder>();}
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").add(builder);this.xKubernetesValidations.add(builder);} return (A)this;
  }
  
  public A removeFromXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1.ValidationRule... items) {
    if (this.xKubernetesValidations == null) return (A)this;
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").remove(builder); this.xKubernetesValidations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromXKubernetesValidations(Collection<ValidationRule> items) {
    if (this.xKubernetesValidations == null) return (A)this;
    for (ValidationRule item : items) {ValidationRuleBuilder builder = new ValidationRuleBuilder(item);_visitables.get("xKubernetesValidations").remove(builder); this.xKubernetesValidations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromXKubernetesValidations(Predicate<ValidationRuleBuilder> predicate) {
    if (xKubernetesValidations == null) return (A) this;
    final Iterator<ValidationRuleBuilder> each = xKubernetesValidations.iterator();
    final List visitables = _visitables.get("xKubernetesValidations");
    while (each.hasNext()) {
      ValidationRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ValidationRule> buildXKubernetesValidations() {
    return this.xKubernetesValidations != null ? build(xKubernetesValidations) : null;
  }
  
  public ValidationRule buildXKubernetesValidation(int index) {
    return this.xKubernetesValidations.get(index).build();
  }
  
  public ValidationRule buildFirstXKubernetesValidation() {
    return this.xKubernetesValidations.get(0).build();
  }
  
  public ValidationRule buildLastXKubernetesValidation() {
    return this.xKubernetesValidations.get(xKubernetesValidations.size() - 1).build();
  }
  
  public ValidationRule buildMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
      for (ValidationRuleBuilder item : xKubernetesValidations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
      for (ValidationRuleBuilder item : xKubernetesValidations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withXKubernetesValidations(List<ValidationRule> xKubernetesValidations) {
    if (this.xKubernetesValidations != null) {
      this._visitables.get("xKubernetesValidations").clear();
    }
    if (xKubernetesValidations != null) {
        this.xKubernetesValidations = new ArrayList();
        for (ValidationRule item : xKubernetesValidations) {
          this.addToXKubernetesValidations(item);
        }
    } else {
      this.xKubernetesValidations = null;
    }
    return (A) this;
  }
  
  public A withXKubernetesValidations(io.fabric8.kubernetes.api.model.apiextensions.v1.ValidationRule... xKubernetesValidations) {
    if (this.xKubernetesValidations != null) {this.xKubernetesValidations.clear(); _visitables.remove("xKubernetesValidations"); }
    if (xKubernetesValidations != null) {for (ValidationRule item :xKubernetesValidations){ this.addToXKubernetesValidations(item);}} return (A) this;
  }
  
  public boolean hasXKubernetesValidations() {
    return this.xKubernetesValidations != null && !this.xKubernetesValidations.isEmpty();
  }
  
  public A addNewXKubernetesValidation(String fieldPath,String message,String messageExpression,String reason,String rule) {
    return (A)addToXKubernetesValidations(new ValidationRule(fieldPath, message, messageExpression, reason, rule));
  }
  
  public XKubernetesValidationsNested<A> addNewXKubernetesValidation() {
    return new XKubernetesValidationsNested(-1, null);
  }
  
  public XKubernetesValidationsNested<A> addNewXKubernetesValidationLike(ValidationRule item) {
    return new XKubernetesValidationsNested(-1, item);
  }
  
  public XKubernetesValidationsNested<A> setNewXKubernetesValidationLike(int index,ValidationRule item) {
    return new XKubernetesValidationsNested(index, item);
  }
  
  public XKubernetesValidationsNested<A> editXKubernetesValidation(int index) {
    if (xKubernetesValidations.size() <= index) throw new RuntimeException("Can't edit xKubernetesValidations. Index exceeds size.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  
  public XKubernetesValidationsNested<A> editFirstXKubernetesValidation() {
    if (xKubernetesValidations.size() == 0) throw new RuntimeException("Can't edit first xKubernetesValidations. The list is empty.");
    return setNewXKubernetesValidationLike(0, buildXKubernetesValidation(0));
  }
  
  public XKubernetesValidationsNested<A> editLastXKubernetesValidation() {
    int index = xKubernetesValidations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last xKubernetesValidations. The list is empty.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  
  public XKubernetesValidationsNested<A> editMatchingXKubernetesValidation(Predicate<ValidationRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<xKubernetesValidations.size();i++) { 
    if (predicate.test(xKubernetesValidations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching xKubernetesValidations. No match found.");
    return setNewXKubernetesValidationLike(index, buildXKubernetesValidation(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JSONSchemaPropsFluent that = (JSONSchemaPropsFluent) o;
    if (!java.util.Objects.equals($ref, that.$ref)) return false;
    if (!java.util.Objects.equals($schema, that.$schema)) return false;
    if (!java.util.Objects.equals(additionalItems, that.additionalItems)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    if (!java.util.Objects.equals(allOf, that.allOf)) return false;
    if (!java.util.Objects.equals(anyOf, that.anyOf)) return false;
    if (!java.util.Objects.equals(_default, that._default)) return false;
    if (!java.util.Objects.equals(definitions, that.definitions)) return false;
    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(_enum, that._enum)) return false;
    if (!java.util.Objects.equals(example, that.example)) return false;
    if (!java.util.Objects.equals(exclusiveMaximum, that.exclusiveMaximum)) return false;
    if (!java.util.Objects.equals(exclusiveMinimum, that.exclusiveMinimum)) return false;
    if (!java.util.Objects.equals(externalDocs, that.externalDocs)) return false;
    if (!java.util.Objects.equals(format, that.format)) return false;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(items, that.items)) return false;
    if (!java.util.Objects.equals(maxItems, that.maxItems)) return false;
    if (!java.util.Objects.equals(maxLength, that.maxLength)) return false;
    if (!java.util.Objects.equals(maxProperties, that.maxProperties)) return false;
    if (!java.util.Objects.equals(maximum, that.maximum)) return false;
    if (!java.util.Objects.equals(minItems, that.minItems)) return false;
    if (!java.util.Objects.equals(minLength, that.minLength)) return false;
    if (!java.util.Objects.equals(minProperties, that.minProperties)) return false;
    if (!java.util.Objects.equals(minimum, that.minimum)) return false;
    if (!java.util.Objects.equals(multipleOf, that.multipleOf)) return false;
    if (!java.util.Objects.equals(not, that.not)) return false;
    if (!java.util.Objects.equals(nullable, that.nullable)) return false;
    if (!java.util.Objects.equals(oneOf, that.oneOf)) return false;
    if (!java.util.Objects.equals(pattern, that.pattern)) return false;
    if (!java.util.Objects.equals(patternProperties, that.patternProperties)) return false;
    if (!java.util.Objects.equals(properties, that.properties)) return false;
    if (!java.util.Objects.equals(required, that.required)) return false;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(uniqueItems, that.uniqueItems)) return false;
    if (!java.util.Objects.equals(xKubernetesEmbeddedResource, that.xKubernetesEmbeddedResource)) return false;
    if (!java.util.Objects.equals(xKubernetesIntOrString, that.xKubernetesIntOrString)) return false;
    if (!java.util.Objects.equals(xKubernetesListMapKeys, that.xKubernetesListMapKeys)) return false;
    if (!java.util.Objects.equals(xKubernetesListType, that.xKubernetesListType)) return false;
    if (!java.util.Objects.equals(xKubernetesMapType, that.xKubernetesMapType)) return false;
    if (!java.util.Objects.equals(xKubernetesPreserveUnknownFields, that.xKubernetesPreserveUnknownFields)) return false;
    if (!java.util.Objects.equals(xKubernetesValidations, that.xKubernetesValidations)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash($ref,  $schema,  additionalItems,  additionalProperties,  allOf,  anyOf,  _default,  definitions,  dependencies,  description,  _enum,  example,  exclusiveMaximum,  exclusiveMinimum,  externalDocs,  format,  id,  items,  maxItems,  maxLength,  maxProperties,  maximum,  minItems,  minLength,  minProperties,  minimum,  multipleOf,  not,  nullable,  oneOf,  pattern,  patternProperties,  properties,  required,  title,  type,  uniqueItems,  xKubernetesEmbeddedResource,  xKubernetesIntOrString,  xKubernetesListMapKeys,  xKubernetesListType,  xKubernetesMapType,  xKubernetesPreserveUnknownFields,  xKubernetesValidations,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if ($ref != null) { sb.append("$ref:"); sb.append($ref + ","); }
    if ($schema != null) { sb.append("$schema:"); sb.append($schema + ","); }
    if (additionalItems != null) { sb.append("additionalItems:"); sb.append(additionalItems + ","); }
    if (additionalProperties != null) { sb.append("additionalProperties:"); sb.append(additionalProperties + ","); }
    if (allOf != null && !allOf.isEmpty()) { sb.append("allOf:"); sb.append(allOf + ","); }
    if (anyOf != null && !anyOf.isEmpty()) { sb.append("anyOf:"); sb.append(anyOf + ","); }
    if (_default != null) { sb.append("_default:"); sb.append(_default + ","); }
    if (definitions != null && !definitions.isEmpty()) { sb.append("definitions:"); sb.append(definitions + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (_enum != null && !_enum.isEmpty()) { sb.append("_enum:"); sb.append(_enum + ","); }
    if (example != null) { sb.append("example:"); sb.append(example + ","); }
    if (exclusiveMaximum != null) { sb.append("exclusiveMaximum:"); sb.append(exclusiveMaximum + ","); }
    if (exclusiveMinimum != null) { sb.append("exclusiveMinimum:"); sb.append(exclusiveMinimum + ","); }
    if (externalDocs != null) { sb.append("externalDocs:"); sb.append(externalDocs + ","); }
    if (format != null) { sb.append("format:"); sb.append(format + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (items != null) { sb.append("items:"); sb.append(items + ","); }
    if (maxItems != null) { sb.append("maxItems:"); sb.append(maxItems + ","); }
    if (maxLength != null) { sb.append("maxLength:"); sb.append(maxLength + ","); }
    if (maxProperties != null) { sb.append("maxProperties:"); sb.append(maxProperties + ","); }
    if (maximum != null) { sb.append("maximum:"); sb.append(maximum + ","); }
    if (minItems != null) { sb.append("minItems:"); sb.append(minItems + ","); }
    if (minLength != null) { sb.append("minLength:"); sb.append(minLength + ","); }
    if (minProperties != null) { sb.append("minProperties:"); sb.append(minProperties + ","); }
    if (minimum != null) { sb.append("minimum:"); sb.append(minimum + ","); }
    if (multipleOf != null) { sb.append("multipleOf:"); sb.append(multipleOf + ","); }
    if (not != null) { sb.append("not:"); sb.append(not + ","); }
    if (nullable != null) { sb.append("nullable:"); sb.append(nullable + ","); }
    if (oneOf != null && !oneOf.isEmpty()) { sb.append("oneOf:"); sb.append(oneOf + ","); }
    if (pattern != null) { sb.append("pattern:"); sb.append(pattern + ","); }
    if (patternProperties != null && !patternProperties.isEmpty()) { sb.append("patternProperties:"); sb.append(patternProperties + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties + ","); }
    if (required != null && !required.isEmpty()) { sb.append("required:"); sb.append(required + ","); }
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (uniqueItems != null) { sb.append("uniqueItems:"); sb.append(uniqueItems + ","); }
    if (xKubernetesEmbeddedResource != null) { sb.append("xKubernetesEmbeddedResource:"); sb.append(xKubernetesEmbeddedResource + ","); }
    if (xKubernetesIntOrString != null) { sb.append("xKubernetesIntOrString:"); sb.append(xKubernetesIntOrString + ","); }
    if (xKubernetesListMapKeys != null && !xKubernetesListMapKeys.isEmpty()) { sb.append("xKubernetesListMapKeys:"); sb.append(xKubernetesListMapKeys + ","); }
    if (xKubernetesListType != null) { sb.append("xKubernetesListType:"); sb.append(xKubernetesListType + ","); }
    if (xKubernetesMapType != null) { sb.append("xKubernetesMapType:"); sb.append(xKubernetesMapType + ","); }
    if (xKubernetesPreserveUnknownFields != null) { sb.append("xKubernetesPreserveUnknownFields:"); sb.append(xKubernetesPreserveUnknownFields + ","); }
    if (xKubernetesValidations != null && !xKubernetesValidations.isEmpty()) { sb.append("xKubernetesValidations:"); sb.append(xKubernetesValidations); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withExclusiveMaximum() {
    return withExclusiveMaximum(true);
  }
  
  public A withExclusiveMinimum() {
    return withExclusiveMinimum(true);
  }
  
  public A withNullable() {
    return withNullable(true);
  }
  
  public A withUniqueItems() {
    return withUniqueItems(true);
  }
  
  public A withXKubernetesEmbeddedResource() {
    return withXKubernetesEmbeddedResource(true);
  }
  
  public A withXKubernetesIntOrString() {
    return withXKubernetesIntOrString(true);
  }
  
  public A withXKubernetesPreserveUnknownFields() {
    return withXKubernetesPreserveUnknownFields(true);
  }
  public class AdditionalItemsNested<N> extends JSONSchemaPropsOrBoolFluent<AdditionalItemsNested<N>> implements Nested<N>{
    AdditionalItemsNested(JSONSchemaPropsOrBool item) {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.withAdditionalItems(builder.build());
    }
    
    public N endAdditionalItems() {
      return and();
    }
    
  
  }
  public class AdditionalPropertiesNested<N> extends JSONSchemaPropsOrBoolFluent<AdditionalPropertiesNested<N>> implements Nested<N>{
    AdditionalPropertiesNested(JSONSchemaPropsOrBool item) {
      this.builder = new JSONSchemaPropsOrBoolBuilder(this, item);
    }
    JSONSchemaPropsOrBoolBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.withAdditionalProperties(builder.build());
    }
    
    public N endAdditionalProperties() {
      return and();
    }
    
  
  }
  public class AllOfNested<N> extends JSONSchemaPropsFluent<AllOfNested<N>> implements Nested<N>{
    AllOfNested(int index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.setToAllOf(index,builder.build());
    }
    
    public N endAllOf() {
      return and();
    }
    
  
  }
  public class AnyOfNested<N> extends JSONSchemaPropsFluent<AnyOfNested<N>> implements Nested<N>{
    AnyOfNested(int index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.setToAnyOf(index,builder.build());
    }
    
    public N endAnyOf() {
      return and();
    }
    
  
  }
  public class ExternalDocsNested<N> extends ExternalDocumentationFluent<ExternalDocsNested<N>> implements Nested<N>{
    ExternalDocsNested(ExternalDocumentation item) {
      this.builder = new ExternalDocumentationBuilder(this, item);
    }
    ExternalDocumentationBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.withExternalDocs(builder.build());
    }
    
    public N endExternalDocs() {
      return and();
    }
    
  
  }
  public class ItemsNested<N> extends JSONSchemaPropsOrArrayFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(JSONSchemaPropsOrArray item) {
      this.builder = new JSONSchemaPropsOrArrayBuilder(this, item);
    }
    JSONSchemaPropsOrArrayBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.withItems(builder.build());
    }
    
    public N endItems() {
      return and();
    }
    
  
  }
  public class NotNested<N> extends JSONSchemaPropsFluent<NotNested<N>> implements Nested<N>{
    NotNested(JSONSchemaProps item) {
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.withNot(builder.build());
    }
    
    public N endNot() {
      return and();
    }
    
  
  }
  public class OneOfNested<N> extends JSONSchemaPropsFluent<OneOfNested<N>> implements Nested<N>{
    OneOfNested(int index,JSONSchemaProps item) {
      this.index = index;
      this.builder = new JSONSchemaPropsBuilder(this, item);
    }
    JSONSchemaPropsBuilder builder;
    int index;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.setToOneOf(index,builder.build());
    }
    
    public N endOneOf() {
      return and();
    }
    
  
  }
  public class XKubernetesValidationsNested<N> extends ValidationRuleFluent<XKubernetesValidationsNested<N>> implements Nested<N>{
    XKubernetesValidationsNested(int index,ValidationRule item) {
      this.index = index;
      this.builder = new ValidationRuleBuilder(this, item);
    }
    ValidationRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) JSONSchemaPropsFluent.this.setToXKubernetesValidations(index,builder.build());
    }
    
    public N endXKubernetesValidation() {
      return and();
    }
    
  
  }

}