package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;

public class ControllerRevisionFluentImpl<A extends io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent<A> {

    private java.lang.String apiVersion;
    private io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.fabric8.kubernetes.api.model.HasMetadata,?> data;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.lang.Long revision;

    public ControllerRevisionFluentImpl() {
    }

    public ControllerRevisionFluentImpl(io.fabric8.kubernetes.api.model.apps.ControllerRevision instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withData(instance.getData()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withRevision(instance.getRevision()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildData instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.HasMetadata getData() {
        return this.data!=null?this.data.build():null;
    }

    public io.fabric8.kubernetes.api.model.HasMetadata buildData() {
        return this.data!=null?this.data.build():null;
    }

    public A withData(io.fabric8.kubernetes.api.model.HasMetadata data) {
        if (data instanceof io.fabric8.kubernetes.api.model.apps.ReplicaSet){ this.data= new io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder((io.fabric8.kubernetes.api.model.apps.ReplicaSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof io.fabric8.kubernetes.api.model.apps.DaemonSet){ this.data= new io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder((io.fabric8.kubernetes.api.model.apps.DaemonSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof io.fabric8.kubernetes.api.model.apps.ControllerRevision){ this.data= new io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder((io.fabric8.kubernetes.api.model.apps.ControllerRevision)data); _visitables.get("data").add(this.data);}
        if (data instanceof io.fabric8.kubernetes.api.model.apps.StatefulSet){ this.data= new io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder((io.fabric8.kubernetes.api.model.apps.StatefulSet)data); _visitables.get("data").add(this.data);}
        if (data instanceof io.fabric8.kubernetes.api.model.PersistentVolumeClaim){ this.data= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder((io.fabric8.kubernetes.api.model.PersistentVolumeClaim)data); _visitables.get("data").add(this.data);}
        if (data instanceof io.fabric8.kubernetes.api.model.apps.Deployment){ this.data= new io.fabric8.kubernetes.api.model.apps.DeploymentBuilder((io.fabric8.kubernetes.api.model.apps.Deployment)data); _visitables.get("data").add(this.data);}
        return (A) this;
    }

    public java.lang.Boolean hasData() {
        return this.data != null;
    }

    public A withReplicaSetData(io.fabric8.kubernetes.api.model.apps.ReplicaSet replicaSetData) {
        _visitables.get("data").remove(this.data);
        if (replicaSetData!=null){ this.data= new io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder(replicaSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(io.fabric8.kubernetes.api.model.apps.ReplicaSet item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl(item);
    }

    public A withDaemonSetData(io.fabric8.kubernetes.api.model.apps.DaemonSet daemonSetData) {
        _visitables.get("data").remove(this.data);
        if (daemonSetData!=null){ this.data= new io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder(daemonSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.DaemonSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(io.fabric8.kubernetes.api.model.apps.DaemonSet item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.DaemonSetDataNestedImpl(item);
    }

    public A withControllerRevisionData(io.fabric8.kubernetes.api.model.apps.ControllerRevision controllerRevisionData) {
        _visitables.get("data").remove(this.data);
        if (controllerRevisionData!=null){ this.data= new io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder(controllerRevisionData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(io.fabric8.kubernetes.api.model.apps.ControllerRevision item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl(item);
    }

    public A withStatefulSetData(io.fabric8.kubernetes.api.model.apps.StatefulSet statefulSetData) {
        _visitables.get("data").remove(this.data);
        if (statefulSetData!=null){ this.data= new io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder(statefulSetData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.StatefulSetDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(io.fabric8.kubernetes.api.model.apps.StatefulSet item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.StatefulSetDataNestedImpl(item);
    }

    public A withPersistentVolumeClaimData(io.fabric8.kubernetes.api.model.PersistentVolumeClaim persistentVolumeClaimData) {
        _visitables.get("data").remove(this.data);
        if (persistentVolumeClaimData!=null){ this.data= new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(persistentVolumeClaimData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl(item);
    }

    public A withDeploymentData(io.fabric8.kubernetes.api.model.apps.Deployment deploymentData) {
        _visitables.get("data").remove(this.data);
        if (deploymentData!=null){ this.data= new io.fabric8.kubernetes.api.model.apps.DeploymentBuilder(deploymentData); _visitables.get("data").add(this.data);} return (A) this;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.DeploymentDataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(io.fabric8.kubernetes.api.model.apps.Deployment item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.DeploymentDataNestedImpl(item);
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public java.lang.Long getRevision() {
        return this.revision;
    }

    public A withRevision(java.lang.Long revision) {
        this.revision=revision; return (A) this;
    }

    public java.lang.Boolean hasRevision() {
        return this.revision != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (data != null ? !data.equals(that.data) :that.data != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  revision,  super.hashCode());
    }

    public class ReplicaSetDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.ReplicaSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ReplicaSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder builder;

            ReplicaSetDataNestedImpl(io.fabric8.kubernetes.api.model.apps.ReplicaSet item) {
                this.builder = new io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder(this, item);
                        
            }

            ReplicaSetDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endReplicaSetData() {
                return and();
            }
    }


    public class DaemonSetDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.DaemonSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DaemonSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder builder;

            DaemonSetDataNestedImpl(io.fabric8.kubernetes.api.model.apps.DaemonSet item) {
                this.builder = new io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder(this, item);
                        
            }

            DaemonSetDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endDaemonSetData() {
                return and();
            }
    }


    public class ControllerRevisionDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.ControllerRevisionDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder builder;

            ControllerRevisionDataNestedImpl(io.fabric8.kubernetes.api.model.apps.ControllerRevision item) {
                this.builder = new io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder(this, item);
                        
            }

            ControllerRevisionDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endControllerRevisionData() {
                return and();
            }
    }


    public class StatefulSetDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.StatefulSetFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.StatefulSetDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder builder;

            StatefulSetDataNestedImpl(io.fabric8.kubernetes.api.model.apps.StatefulSet item) {
                this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder(this, item);
                        
            }

            StatefulSetDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endStatefulSetData() {
                return and();
            }
    }


    public class PersistentVolumeClaimDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;

            PersistentVolumeClaimDataNestedImpl(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
                        
            }

            PersistentVolumeClaimDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endPersistentVolumeClaimData() {
                return and();
            }
    }


    public class DeploymentDataNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.DeploymentFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.DeploymentDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.apps.DeploymentBuilder builder;

            DeploymentDataNestedImpl(io.fabric8.kubernetes.api.model.apps.Deployment item) {
                this.builder = new io.fabric8.kubernetes.api.model.apps.DeploymentBuilder(this, item);
                        
            }

            DeploymentDataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.apps.DeploymentBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
            }

            public N endDeploymentData() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ControllerRevisionFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
