package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetListBuilder extends StatefulSetListFluentImpl<StatefulSetListBuilder> implements VisitableBuilder<StatefulSetList,StatefulSetListBuilder>{
  public StatefulSetListBuilder() {
    this(false);
  }
  public StatefulSetListBuilder(Boolean validationEnabled) {
    this(new StatefulSetList(), validationEnabled);
  }
  public StatefulSetListBuilder(StatefulSetListFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetListBuilder(StatefulSetListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetList(), validationEnabled);
  }
  public StatefulSetListBuilder(StatefulSetListFluent<?> fluent,StatefulSetList instance) {
    this(fluent, instance, false);
  }
  public StatefulSetListBuilder(StatefulSetListFluent<?> fluent,StatefulSetList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetListBuilder(StatefulSetList instance) {
    this(instance,false);
  }
  public StatefulSetListBuilder(StatefulSetList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StatefulSetListFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetList build() {
    StatefulSetList buildable = new StatefulSetList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}