package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface StatefulSetStatusFluent<A extends StatefulSetStatusFluent<A>> extends Fluent<A>{
  public Integer getAvailableReplicas();
  public A withAvailableReplicas(Integer availableReplicas);
  public Boolean hasAvailableReplicas();
  public Integer getCollisionCount();
  public A withCollisionCount(Integer collisionCount);
  public Boolean hasCollisionCount();
  public A addToConditions(int index,StatefulSetCondition item);
  public A setToConditions(int index,StatefulSetCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items);
  public A addAllToConditions(Collection<StatefulSetCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... items);
  public A removeAllFromConditions(Collection<StatefulSetCondition> items);
  public A removeMatchingFromConditions(Predicate<StatefulSetConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StatefulSetCondition> getConditions();
  public List<StatefulSetCondition> buildConditions();
  public StatefulSetCondition buildCondition(int index);
  public StatefulSetCondition buildFirstCondition();
  public StatefulSetCondition buildLastCondition();
  public StatefulSetCondition buildMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate);
  public A withConditions(List<StatefulSetCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.apps.StatefulSetCondition... conditions);
  public Boolean hasConditions();
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
  public StatefulSetStatusFluent.ConditionsNested<A> addNewCondition();
  public StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(StatefulSetCondition item);
  public StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,StatefulSetCondition item);
  public StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index);
  public StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition();
  public StatefulSetStatusFluent.ConditionsNested<A> editLastCondition();
  public StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate);
  public Integer getCurrentReplicas();
  public A withCurrentReplicas(Integer currentReplicas);
  public Boolean hasCurrentReplicas();
  public String getCurrentRevision();
  public A withCurrentRevision(String currentRevision);
  public Boolean hasCurrentRevision();
  public Long getObservedGeneration();
  public A withObservedGeneration(Long observedGeneration);
  public Boolean hasObservedGeneration();
  public Integer getReadyReplicas();
  public A withReadyReplicas(Integer readyReplicas);
  public Boolean hasReadyReplicas();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  public String getUpdateRevision();
  public A withUpdateRevision(String updateRevision);
  public Boolean hasUpdateRevision();
  public Integer getUpdatedReplicas();
  public A withUpdatedReplicas(Integer updatedReplicas);
  public Boolean hasUpdatedReplicas();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,StatefulSetConditionFluent<StatefulSetStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  
}