package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DaemonSetConditionBuilder extends DaemonSetConditionFluent<DaemonSetConditionBuilder> implements VisitableBuilder<DaemonSetCondition,DaemonSetConditionBuilder>{
  public DaemonSetConditionBuilder() {
    this(new DaemonSetCondition());
  }
  
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent) {
    this(fluent, new DaemonSetCondition());
  }
  
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent,DaemonSetCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DaemonSetConditionBuilder(DaemonSetCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DaemonSetConditionFluent<?> fluent;
  
  public DaemonSetCondition build() {
    DaemonSetCondition buildable = new DaemonSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}