package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusBuilder>{

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerStatusBuilder(){
            this(true);
    }
    public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled){
            this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance){
            this(fluent, instance, true);
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withCurrentMetrics(instance.getCurrentMetrics()); 
            fluent.withCurrentReplicas(instance.getCurrentReplicas()); 
            fluent.withDesiredReplicas(instance.getDesiredReplicas()); 
            fluent.withLastScaleTime(instance.getLastScaleTime()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance){
            this(instance,true);
    }
    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withCurrentMetrics(instance.getCurrentMetrics()); 
            this.withCurrentReplicas(instance.getCurrentReplicas()); 
            this.withDesiredReplicas(instance.getDesiredReplicas()); 
            this.withLastScaleTime(instance.getLastScaleTime()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerStatus build(){
            HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(fluent.getConditions(),fluent.getCurrentMetrics(),fluent.getCurrentReplicas(),fluent.getDesiredReplicas(),fluent.getLastScaleTime(),fluent.getObservedGeneration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
