package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ContainerResourceMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusBuilder>{
  public ContainerResourceMetricStatusBuilder() {
    this(false);
  }
  public ContainerResourceMetricStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ContainerResourceMetricStatus(), validationEnabled);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainer(instance.getContainer()); 
    fluent.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
    fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus instance) {
    this(instance,false);
  }
  public ContainerResourceMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainer(instance.getContainer()); 
    this.withCurrentAverageUtilization(instance.getCurrentAverageUtilization()); 
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ContainerResourceMetricStatus build() {
    ContainerResourceMetricStatus buildable = new ContainerResourceMetricStatus(fluent.getContainer(),fluent.getCurrentAverageUtilization(),fluent.getCurrentAverageValue(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerResourceMetricStatusBuilder that = (ContainerResourceMetricStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}