package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HorizontalPodAutoscalerStatusBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); 
        fluent.withCurrentReplicas(instance.getCurrentReplicas()); 
        fluent.withDesiredReplicas(instance.getDesiredReplicas()); 
        fluent.withLastScaleTime(instance.getLastScaleTime()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus instance) {
        this(instance,true);
    }

    public HorizontalPodAutoscalerStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); 
        this.withCurrentReplicas(instance.getCurrentReplicas()); 
        this.withDesiredReplicas(instance.getDesiredReplicas()); 
        this.withLastScaleTime(instance.getLastScaleTime()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v1.HorizontalPodAutoscalerStatus build() {
        HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(fluent.getCurrentCPUUtilizationPercentage(),fluent.getCurrentReplicas(),fluent.getDesiredReplicas(),fluent.getLastScaleTime(),fluent.getObservedGeneration());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HorizontalPodAutoscalerStatusBuilder that = (HorizontalPodAutoscalerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
