package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerBehaviorBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HorizontalPodAutoscalerBehaviorBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(java.lang.Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerBehavior(), validationEnabled);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent) {
        this(fluent, true);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerBehavior(), validationEnabled);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehaviorFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withScaleDown(instance.getScaleDown()); 
        fluent.withScaleUp(instance.getScaleUp()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance) {
        this(instance,true);
    }

    public HorizontalPodAutoscalerBehaviorBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withScaleDown(instance.getScaleDown()); 
        this.withScaleUp(instance.getScaleUp()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior build() {
        HorizontalPodAutoscalerBehavior buildable = new HorizontalPodAutoscalerBehavior(fluent.getScaleDown(),fluent.getScaleUp());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HorizontalPodAutoscalerBehaviorBuilder that = (HorizontalPodAutoscalerBehaviorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
