package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerSpecBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HorizontalPodAutoscalerSpecBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBehavior(instance.getBehavior()); 
        fluent.withMaxReplicas(instance.getMaxReplicas()); 
        fluent.withMetrics(instance.getMetrics()); 
        fluent.withMinReplicas(instance.getMinReplicas()); 
        fluent.withScaleTargetRef(instance.getScaleTargetRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec instance) {
        this(instance,true);
    }

    public HorizontalPodAutoscalerSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBehavior(instance.getBehavior()); 
        this.withMaxReplicas(instance.getMaxReplicas()); 
        this.withMetrics(instance.getMetrics()); 
        this.withMinReplicas(instance.getMinReplicas()); 
        this.withScaleTargetRef(instance.getScaleTargetRef()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerSpec build() {
        HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getBehavior(),fluent.getMaxReplicas(),fluent.getMetrics(),fluent.getMinReplicas(),fluent.getScaleTargetRef());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HorizontalPodAutoscalerSpecBuilder that = (HorizontalPodAutoscalerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
