package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleSpecBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ScaleSpecBuilder() {
        this(true);
    }

    public ScaleSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ScaleSpec(), validationEnabled);
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
        this(fluent, instance, true);
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance) {
        this(instance,true);
    }

    public ScaleSpecBuilder(io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleSpec build() {
        ScaleSpec buildable = new ScaleSpec(fluent.getReplicas());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleSpecBuilder that = (ScaleSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
