package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ExternalMetricStatusBuilder() {
        this(true);
    }

    public ExternalMetricStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ExternalMetricStatus(), validationEnabled);
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ExternalMetricStatus(), validationEnabled);
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance) {
        this(fluent, instance, true);
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        fluent.withCurrentValue(instance.getCurrentValue()); 
        fluent.withMetricName(instance.getMetricName()); 
        fluent.withMetricSelector(instance.getMetricSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance) {
        this(instance,true);
    }

    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
        this.withCurrentValue(instance.getCurrentValue()); 
        this.withMetricName(instance.getMetricName()); 
        this.withMetricSelector(instance.getMetricSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ExternalMetricStatus build() {
        ExternalMetricStatus buildable = new ExternalMetricStatus(fluent.getCurrentAverageValue(),fluent.getCurrentValue(),fluent.getMetricName(),fluent.getMetricSelector());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalMetricStatusBuilder that = (ExternalMetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
