package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HPAScalingPolicyBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyBuilder> {

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public HPAScalingPolicyBuilder() {
        this(true);
    }

    public HPAScalingPolicyBuilder(java.lang.Boolean validationEnabled) {
        this(new HPAScalingPolicy(), validationEnabled);
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent) {
        this(fluent, true);
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new HPAScalingPolicy(), validationEnabled);
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance) {
        this(fluent, instance, true);
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPeriodSeconds(instance.getPeriodSeconds()); 
        fluent.withType(instance.getType()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance) {
        this(instance,true);
    }

    public HPAScalingPolicyBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withPeriodSeconds(instance.getPeriodSeconds()); 
        this.withType(instance.getType()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy build() {
        HPAScalingPolicy buildable = new HPAScalingPolicy(fluent.getPeriodSeconds(),fluent.getType(),fluent.getValue());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HPAScalingPolicyBuilder that = (HPAScalingPolicyBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
