/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicy;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HPAScalingPolicyFluentImpl;
import java.util.Objects;

public class HPAScalingPolicyBuilder
extends HPAScalingPolicyFluentImpl<HPAScalingPolicyBuilder>
implements VisitableBuilder<HPAScalingPolicy, HPAScalingPolicyBuilder> {
    HPAScalingPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public HPAScalingPolicyBuilder() {
        this(false);
    }

    public HPAScalingPolicyBuilder(Boolean validationEnabled) {
        this(new HPAScalingPolicy(), validationEnabled);
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HPAScalingPolicy(), validationEnabled);
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent, HPAScalingPolicy instance) {
        this(fluent, instance, false);
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent, HPAScalingPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withType(instance.getType());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicy instance) {
        this(instance, (Boolean)false);
    }

    public HPAScalingPolicyBuilder(HPAScalingPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withType(instance.getType());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public HPAScalingPolicy build() {
        HPAScalingPolicy buildable = new HPAScalingPolicy(this.fluent.getPeriodSeconds(), this.fluent.getType(), this.fluent.getValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HPAScalingPolicyBuilder that = (HPAScalingPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

