package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExternalMetricStatusFluentImpl<A extends ExternalMetricStatusFluent<A>> extends BaseFluent<A> implements ExternalMetricStatusFluent<A>{
  public ExternalMetricStatusFluentImpl() {
  }
  public ExternalMetricStatusFluentImpl(ExternalMetricStatus instance) {
    this.withCurrentAverageValue(instance.getCurrentAverageValue()); 
    this.withCurrentValue(instance.getCurrentValue()); 
    this.withMetricName(instance.getMetricName()); 
    this.withMetricSelector(instance.getMetricSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Quantity currentAverageValue;
  private Quantity currentValue;
  private String metricName;
  private LabelSelectorBuilder metricSelector;
  private Map<String,Object> additionalProperties;
  public Quantity getCurrentAverageValue() {
    return this.currentAverageValue;
  }
  public A withCurrentAverageValue(Quantity currentAverageValue) {
    this.currentAverageValue=currentAverageValue; return (A) this;
  }
  public Boolean hasCurrentAverageValue() {
    return this.currentAverageValue != null;
  }
  public A withNewCurrentAverageValue(String amount,String format) {
    return (A)withCurrentAverageValue(new Quantity(amount, format));
  }
  public A withNewCurrentAverageValue(String amount) {
    return (A)withCurrentAverageValue(new Quantity(amount));
  }
  public Quantity getCurrentValue() {
    return this.currentValue;
  }
  public A withCurrentValue(Quantity currentValue) {
    this.currentValue=currentValue; return (A) this;
  }
  public Boolean hasCurrentValue() {
    return this.currentValue != null;
  }
  public A withNewCurrentValue(String amount,String format) {
    return (A)withCurrentValue(new Quantity(amount, format));
  }
  public A withNewCurrentValue(String amount) {
    return (A)withCurrentValue(new Quantity(amount));
  }
  public String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public LabelSelector buildMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public A withMetricSelector(LabelSelector metricSelector) {
    _visitables.get("metricSelector").remove(this.metricSelector);
    if (metricSelector!=null){ this.metricSelector= new LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} else { this.metricSelector = null; _visitables.get("metricSelector").remove(this.metricSelector); } return (A) this;
  }
  public Boolean hasMetricSelector() {
    return this.metricSelector != null;
  }
  public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector() {
    return new ExternalMetricStatusFluentImpl.MetricSelectorNestedImpl();
  }
  public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
    return new ExternalMetricStatusFluentImpl.MetricSelectorNestedImpl(item);
  }
  public ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector());
  }
  public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new LabelSelectorBuilder().build());
  }
  public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExternalMetricStatusFluentImpl that = (ExternalMetricStatusFluentImpl) o;
    if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
    if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
    if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
    if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(currentAverageValue,  currentValue,  metricName,  metricSelector,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (currentAverageValue != null) { sb.append("currentAverageValue:"); sb.append(currentAverageValue + ","); }
    if (currentValue != null) { sb.append("currentValue:"); sb.append(currentValue + ","); }
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (metricSelector != null) { sb.append("metricSelector:"); sb.append(metricSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetricSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ExternalMetricStatusFluent.MetricSelectorNested<N>> implements ExternalMetricStatusFluent.MetricSelectorNested<N>,Nested<N>{
    MetricSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    MetricSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ExternalMetricStatusFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector() {
      return and();
    }
    
  }
  
}