package io.fabric8.kubernetes.api.model.autoscaling.v2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ObjectMetricSourceFluentImpl<A extends ObjectMetricSourceFluent<A>> extends BaseFluent<A> implements ObjectMetricSourceFluent<A>{
  public ObjectMetricSourceFluentImpl() {
  }
  public ObjectMetricSourceFluentImpl(ObjectMetricSource instance) {
    if (instance != null) {
      this.withDescribedObject(instance.getDescribedObject());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private CrossVersionObjectReferenceBuilder describedObject;
  private MetricIdentifierBuilder metric;
  private MetricTargetBuilder target;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildDescribedObject instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getDescribedObject() {
    return this.describedObject!=null ?this.describedObject.build():null;
  }
  public CrossVersionObjectReference buildDescribedObject() {
    return this.describedObject!=null ?this.describedObject.build():null;
  }
  public A withDescribedObject(CrossVersionObjectReference describedObject) {
    _visitables.get("describedObject").remove(this.describedObject);
    if (describedObject!=null){ this.describedObject= new CrossVersionObjectReferenceBuilder(describedObject); _visitables.get("describedObject").add(this.describedObject);} else { this.describedObject = null; _visitables.get("describedObject").remove(this.describedObject); } return (A) this;
  }
  public Boolean hasDescribedObject() {
    return this.describedObject != null;
  }
  public A withNewDescribedObject(String apiVersion,String kind,String name) {
    return (A)withDescribedObject(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public ObjectMetricSourceFluentImpl.DescribedObjectNested<A> withNewDescribedObject() {
    return new ObjectMetricSourceFluentImpl.DescribedObjectNestedImpl();
  }
  public ObjectMetricSourceFluentImpl.DescribedObjectNested<A> withNewDescribedObjectLike(CrossVersionObjectReference item) {
    return new ObjectMetricSourceFluentImpl.DescribedObjectNestedImpl(item);
  }
  public ObjectMetricSourceFluentImpl.DescribedObjectNested<A> editDescribedObject() {
    return withNewDescribedObjectLike(getDescribedObject());
  }
  public ObjectMetricSourceFluentImpl.DescribedObjectNested<A> editOrNewDescribedObject() {
    return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): new CrossVersionObjectReferenceBuilder().build());
  }
  public ObjectMetricSourceFluentImpl.DescribedObjectNested<A> editOrNewDescribedObjectLike(CrossVersionObjectReference item) {
    return withNewDescribedObjectLike(getDescribedObject() != null ? getDescribedObject(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildMetric instead.
   * @return The buildable object.
   */
  @Deprecated
  public MetricIdentifier getMetric() {
    return this.metric!=null ?this.metric.build():null;
  }
  public MetricIdentifier buildMetric() {
    return this.metric!=null ?this.metric.build():null;
  }
  public A withMetric(MetricIdentifier metric) {
    _visitables.get("metric").remove(this.metric);
    if (metric!=null){ this.metric= new MetricIdentifierBuilder(metric); _visitables.get("metric").add(this.metric);} else { this.metric = null; _visitables.get("metric").remove(this.metric); } return (A) this;
  }
  public Boolean hasMetric() {
    return this.metric != null;
  }
  public ObjectMetricSourceFluentImpl.MetricNested<A> withNewMetric() {
    return new ObjectMetricSourceFluentImpl.MetricNestedImpl();
  }
  public ObjectMetricSourceFluentImpl.MetricNested<A> withNewMetricLike(MetricIdentifier item) {
    return new ObjectMetricSourceFluentImpl.MetricNestedImpl(item);
  }
  public ObjectMetricSourceFluentImpl.MetricNested<A> editMetric() {
    return withNewMetricLike(getMetric());
  }
  public ObjectMetricSourceFluentImpl.MetricNested<A> editOrNewMetric() {
    return withNewMetricLike(getMetric() != null ? getMetric(): new MetricIdentifierBuilder().build());
  }
  public ObjectMetricSourceFluentImpl.MetricNested<A> editOrNewMetricLike(MetricIdentifier item) {
    return withNewMetricLike(getMetric() != null ? getMetric(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public MetricTarget getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public MetricTarget buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(MetricTarget target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new MetricTargetBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public ObjectMetricSourceFluentImpl.TargetNested<A> withNewTarget() {
    return new ObjectMetricSourceFluentImpl.TargetNestedImpl();
  }
  public ObjectMetricSourceFluentImpl.TargetNested<A> withNewTargetLike(MetricTarget item) {
    return new ObjectMetricSourceFluentImpl.TargetNestedImpl(item);
  }
  public ObjectMetricSourceFluentImpl.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public ObjectMetricSourceFluentImpl.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new MetricTargetBuilder().build());
  }
  public ObjectMetricSourceFluentImpl.TargetNested<A> editOrNewTargetLike(MetricTarget item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ObjectMetricSourceFluentImpl that = (ObjectMetricSourceFluentImpl) o;
    if (!java.util.Objects.equals(describedObject, that.describedObject)) return false;

    if (!java.util.Objects.equals(metric, that.metric)) return false;

    if (!java.util.Objects.equals(target, that.target)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(describedObject,  metric,  target,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (describedObject != null) { sb.append("describedObject:"); sb.append(describedObject + ","); }
    if (metric != null) { sb.append("metric:"); sb.append(metric + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DescribedObjectNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<ObjectMetricSourceFluentImpl.DescribedObjectNested<N>> implements ObjectMetricSourceFluentImpl.DescribedObjectNested<N>,Nested<N>{
    DescribedObjectNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    DescribedObjectNestedImpl() {
      this.builder = new CrossVersionObjectReferenceBuilder(this);
    }
    CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) ObjectMetricSourceFluentImpl.this.withDescribedObject(builder.build());
    }
    public N endDescribedObject() {
      return and();
    }
    
  }
  class MetricNestedImpl<N> extends MetricIdentifierFluentImpl<ObjectMetricSourceFluentImpl.MetricNested<N>> implements ObjectMetricSourceFluentImpl.MetricNested<N>,Nested<N>{
    MetricNestedImpl(MetricIdentifier item) {
      this.builder = new MetricIdentifierBuilder(this, item);
    }
    MetricNestedImpl() {
      this.builder = new MetricIdentifierBuilder(this);
    }
    MetricIdentifierBuilder builder;
    public N and() {
      return (N) ObjectMetricSourceFluentImpl.this.withMetric(builder.build());
    }
    public N endMetric() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends MetricTargetFluentImpl<ObjectMetricSourceFluentImpl.TargetNested<N>> implements ObjectMetricSourceFluentImpl.TargetNested<N>,Nested<N>{
    TargetNestedImpl(MetricTarget item) {
      this.builder = new MetricTargetBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new MetricTargetBuilder(this);
    }
    MetricTargetBuilder builder;
    public N and() {
      return (N) ObjectMetricSourceFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}