package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>> extends BaseFluent<A> implements ExternalMetricSourceFluent<A>{
  public ExternalMetricSourceFluentImpl() {
  }
  public ExternalMetricSourceFluentImpl(ExternalMetricSource instance) {
    if (instance != null) {
      this.withMetricName(instance.getMetricName());
      this.withMetricSelector(instance.getMetricSelector());
      this.withTargetAverageValue(instance.getTargetAverageValue());
      this.withTargetValue(instance.getTargetValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String metricName;
  private LabelSelectorBuilder metricSelector;
  private Quantity targetAverageValue;
  private Quantity targetValue;
  private Map<String,Object> additionalProperties;
  public String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetricSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public LabelSelector buildMetricSelector() {
    return this.metricSelector!=null ?this.metricSelector.build():null;
  }
  public A withMetricSelector(LabelSelector metricSelector) {
    _visitables.get("metricSelector").remove(this.metricSelector);
    if (metricSelector!=null){ this.metricSelector= new LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} else { this.metricSelector = null; _visitables.get("metricSelector").remove(this.metricSelector); } return (A) this;
  }
  public Boolean hasMetricSelector() {
    return this.metricSelector != null;
  }
  public ExternalMetricSourceFluentImpl.MetricSelectorNested<A> withNewMetricSelector() {
    return new ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl();
  }
  public ExternalMetricSourceFluentImpl.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
    return new ExternalMetricSourceFluentImpl.MetricSelectorNestedImpl(item);
  }
  public ExternalMetricSourceFluentImpl.MetricSelectorNested<A> editMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector());
  }
  public ExternalMetricSourceFluentImpl.MetricSelectorNested<A> editOrNewMetricSelector() {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new LabelSelectorBuilder().build());
  }
  public ExternalMetricSourceFluentImpl.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
    return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
  }
  public Quantity getTargetAverageValue() {
    return this.targetAverageValue;
  }
  public A withTargetAverageValue(Quantity targetAverageValue) {
    this.targetAverageValue=targetAverageValue; return (A) this;
  }
  public Boolean hasTargetAverageValue() {
    return this.targetAverageValue != null;
  }
  public A withNewTargetAverageValue(String amount,String format) {
    return (A)withTargetAverageValue(new Quantity(amount, format));
  }
  public A withNewTargetAverageValue(String amount) {
    return (A)withTargetAverageValue(new Quantity(amount));
  }
  public Quantity getTargetValue() {
    return this.targetValue;
  }
  public A withTargetValue(Quantity targetValue) {
    this.targetValue=targetValue; return (A) this;
  }
  public Boolean hasTargetValue() {
    return this.targetValue != null;
  }
  public A withNewTargetValue(String amount,String format) {
    return (A)withTargetValue(new Quantity(amount, format));
  }
  public A withNewTargetValue(String amount) {
    return (A)withTargetValue(new Quantity(amount));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl) o;
    if (!java.util.Objects.equals(metricName, that.metricName)) return false;

    if (!java.util.Objects.equals(metricSelector, that.metricSelector)) return false;

    if (!java.util.Objects.equals(targetAverageValue, that.targetAverageValue)) return false;

    if (!java.util.Objects.equals(targetValue, that.targetValue)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(metricName,  metricSelector,  targetAverageValue,  targetValue,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (metricSelector != null) { sb.append("metricSelector:"); sb.append(metricSelector + ","); }
    if (targetAverageValue != null) { sb.append("targetAverageValue:"); sb.append(targetAverageValue + ","); }
    if (targetValue != null) { sb.append("targetValue:"); sb.append(targetValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetricSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ExternalMetricSourceFluentImpl.MetricSelectorNested<N>> implements ExternalMetricSourceFluentImpl.MetricSelectorNested<N>,Nested<N>{
    MetricSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    MetricSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ExternalMetricSourceFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector() {
      return and();
    }
    
  }
  
}