package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodsMetricSourceFluentImpl<A extends PodsMetricSourceFluent<A>> extends BaseFluent<A> implements PodsMetricSourceFluent<A>{
  public PodsMetricSourceFluentImpl() {
  }
  public PodsMetricSourceFluentImpl(PodsMetricSource instance) {
    if (instance != null) {
      this.withMetricName(instance.getMetricName());
      this.withSelector(instance.getSelector());
      this.withTargetAverageValue(instance.getTargetAverageValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String metricName;
  private LabelSelectorBuilder selector;
  private Quantity targetAverageValue;
  private Map<String,Object> additionalProperties;
  public String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public PodsMetricSourceFluentImpl.SelectorNested<A> withNewSelector() {
    return new PodsMetricSourceFluentImpl.SelectorNestedImpl();
  }
  public PodsMetricSourceFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new PodsMetricSourceFluentImpl.SelectorNestedImpl(item);
  }
  public PodsMetricSourceFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public PodsMetricSourceFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public PodsMetricSourceFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public Quantity getTargetAverageValue() {
    return this.targetAverageValue;
  }
  public A withTargetAverageValue(Quantity targetAverageValue) {
    this.targetAverageValue=targetAverageValue; return (A) this;
  }
  public Boolean hasTargetAverageValue() {
    return this.targetAverageValue != null;
  }
  public A withNewTargetAverageValue(String amount,String format) {
    return (A)withTargetAverageValue(new Quantity(amount, format));
  }
  public A withNewTargetAverageValue(String amount) {
    return (A)withTargetAverageValue(new Quantity(amount));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodsMetricSourceFluentImpl that = (PodsMetricSourceFluentImpl) o;
    if (!java.util.Objects.equals(metricName, that.metricName)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(targetAverageValue, that.targetAverageValue)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(metricName,  selector,  targetAverageValue,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (targetAverageValue != null) { sb.append("targetAverageValue:"); sb.append(targetAverageValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PodsMetricSourceFluentImpl.SelectorNested<N>> implements PodsMetricSourceFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PodsMetricSourceFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}