package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricIdentifierBuilder extends MetricIdentifierFluent<MetricIdentifierBuilder> implements VisitableBuilder<MetricIdentifier,MetricIdentifierBuilder>{
  public MetricIdentifierBuilder() {
    this(false);
  }
  public MetricIdentifierBuilder(Boolean validationEnabled) {
    this(new MetricIdentifier(), validationEnabled);
  }
  public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricIdentifier(), validationEnabled);
  }
  public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,MetricIdentifier instance) {
    this(fluent, instance, false);
  }
  public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,MetricIdentifier instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MetricIdentifier());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withSelector(instance.getSelector());
      fluent.withName(instance.getName());
      fluent.withSelector(instance.getSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricIdentifierBuilder(MetricIdentifier instance) {
    this(instance,false);
  }
  public MetricIdentifierBuilder(MetricIdentifier instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MetricIdentifier());

    if (instance != null) {
      this.withName(instance.getName());
      this.withSelector(instance.getSelector());
      this.withName(instance.getName());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricIdentifierFluent<?> fluent;
  Boolean validationEnabled;
  public MetricIdentifier build() {
    MetricIdentifier buildable = new MetricIdentifier(fluent.getName(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}