package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodsMetricSourceBuilder extends PodsMetricSourceFluent<PodsMetricSourceBuilder> implements VisitableBuilder<PodsMetricSource,PodsMetricSourceBuilder>{
  public PodsMetricSourceBuilder() {
    this(false);
  }
  public PodsMetricSourceBuilder(Boolean validationEnabled) {
    this(new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodsMetricSource(), validationEnabled);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance) {
    this(fluent, instance, false);
  }
  public PodsMetricSourceBuilder(PodsMetricSourceFluent<?> fluent,PodsMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodsMetricSource());

    if (instance != null) {
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodsMetricSourceBuilder(PodsMetricSource instance) {
    this(instance,false);
  }
  public PodsMetricSourceBuilder(PodsMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodsMetricSource());

    if (instance != null) {
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodsMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PodsMetricSource build() {
    PodsMetricSource buildable = new PodsMetricSource(fluent.buildMetric(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}