package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerSpecBuilder extends HorizontalPodAutoscalerSpecFluent<HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<HorizontalPodAutoscalerSpec,HorizontalPodAutoscalerSpecBuilder>{
  public HorizontalPodAutoscalerSpecBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerSpec(), validationEnabled);
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerSpec(), validationEnabled);
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpecFluent<?> fluent,HorizontalPodAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerSpec());

    if (instance != null) {
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withScaleTargetRef(instance.getScaleTargetRef());
      fluent.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
      fluent.withMaxReplicas(instance.getMaxReplicas());
      fluent.withMinReplicas(instance.getMinReplicas());
      fluent.withScaleTargetRef(instance.getScaleTargetRef());
      fluent.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerSpecBuilder(HorizontalPodAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerSpec());

    if (instance != null) {
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withScaleTargetRef(instance.getScaleTargetRef());
      this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
      this.withMaxReplicas(instance.getMaxReplicas());
      this.withMinReplicas(instance.getMinReplicas());
      this.withScaleTargetRef(instance.getScaleTargetRef());
      this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HorizontalPodAutoscalerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public HorizontalPodAutoscalerSpec build() {
    HorizontalPodAutoscalerSpec buildable = new HorizontalPodAutoscalerSpec(fluent.getMaxReplicas(),fluent.getMinReplicas(),fluent.buildScaleTargetRef(),fluent.getTargetCPUUtilizationPercentage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}