package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ExternalMetricSourceFluent<A extends ExternalMetricSourceFluent<A>> extends BaseFluent<A>{
  public ExternalMetricSourceFluent() {
  }
  
  public ExternalMetricSourceFluent(ExternalMetricSource instance) {
    this.copyInstance(instance);
  }
  private String metricName;
  private LabelSelectorBuilder metricSelector;
  private Quantity targetAverageValue;
  private Quantity targetValue;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ExternalMetricSource instance) {
    instance = (instance != null ? instance : new ExternalMetricSource());
    if (instance != null) {
          this.withMetricName(instance.getMetricName());
          this.withMetricSelector(instance.getMetricSelector());
          this.withTargetAverageValue(instance.getTargetAverageValue());
          this.withTargetValue(instance.getTargetValue());
          this.withMetricName(instance.getMetricName());
          this.withMetricSelector(instance.getMetricSelector());
          this.withTargetAverageValue(instance.getTargetAverageValue());
          this.withTargetValue(instance.getTargetValue());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getMetricName() {
    return this.metricName;
  }
  
  public A withMetricName(String metricName) {
    this.metricName = metricName;
    return (A) this;
  }
  
  public boolean hasMetricName() {
    return this.metricName != null;
  }
  
  public LabelSelector buildMetricSelector() {
    return this.metricSelector != null ? this.metricSelector.build() : null;
  }
  
  public A withMetricSelector(LabelSelector metricSelector) {
    this._visitables.remove(this.metricSelector);
    if (metricSelector != null) {
        this.metricSelector = new LabelSelectorBuilder(metricSelector);
        this._visitables.get("metricSelector").add(this.metricSelector);
    } else {
        this.metricSelector = null;
        this._visitables.get("metricSelector").remove(this.metricSelector);
    }
    return (A) this;
  }
  
  public boolean hasMetricSelector() {
    return this.metricSelector != null;
  }
  
  public MetricSelectorNested<A> withNewMetricSelector() {
    return new MetricSelectorNested(null);
  }
  
  public MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
    return new MetricSelectorNested(item);
  }
  
  public MetricSelectorNested<A> editMetricSelector() {
    return withNewMetricSelectorLike(java.util.Optional.ofNullable(buildMetricSelector()).orElse(null));
  }
  
  public MetricSelectorNested<A> editOrNewMetricSelector() {
    return withNewMetricSelectorLike(java.util.Optional.ofNullable(buildMetricSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
    return withNewMetricSelectorLike(java.util.Optional.ofNullable(buildMetricSelector()).orElse(item));
  }
  
  public Quantity getTargetAverageValue() {
    return this.targetAverageValue;
  }
  
  public A withTargetAverageValue(Quantity targetAverageValue) {
    this.targetAverageValue = targetAverageValue;
    return (A) this;
  }
  
  public boolean hasTargetAverageValue() {
    return this.targetAverageValue != null;
  }
  
  public A withNewTargetAverageValue(String amount,String format) {
    return (A)withTargetAverageValue(new Quantity(amount, format));
  }
  
  public A withNewTargetAverageValue(String amount) {
    return (A)withTargetAverageValue(new Quantity(amount));
  }
  
  public Quantity getTargetValue() {
    return this.targetValue;
  }
  
  public A withTargetValue(Quantity targetValue) {
    this.targetValue = targetValue;
    return (A) this;
  }
  
  public boolean hasTargetValue() {
    return this.targetValue != null;
  }
  
  public A withNewTargetValue(String amount,String format) {
    return (A)withTargetValue(new Quantity(amount, format));
  }
  
  public A withNewTargetValue(String amount) {
    return (A)withTargetValue(new Quantity(amount));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ExternalMetricSourceFluent that = (ExternalMetricSourceFluent) o;
    if (!java.util.Objects.equals(metricName, that.metricName)) return false;
    if (!java.util.Objects.equals(metricSelector, that.metricSelector)) return false;
    if (!java.util.Objects.equals(targetAverageValue, that.targetAverageValue)) return false;
    if (!java.util.Objects.equals(targetValue, that.targetValue)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(metricName,  metricSelector,  targetAverageValue,  targetValue,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (metricSelector != null) { sb.append("metricSelector:"); sb.append(metricSelector + ","); }
    if (targetAverageValue != null) { sb.append("targetAverageValue:"); sb.append(targetAverageValue + ","); }
    if (targetValue != null) { sb.append("targetValue:"); sb.append(targetValue + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetricSelectorNested<N> extends LabelSelectorFluent<MetricSelectorNested<N>> implements Nested<N>{
    MetricSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ExternalMetricSourceFluent.this.withMetricSelector(builder.build());
    }
    
    public N endMetricSelector() {
      return and();
    }
    
  
  }

}