package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JobConditionBuilder extends io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluentImpl<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.batch.v1.JobCondition,io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> {

    io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JobConditionBuilder() {
        this(true);
    }

    public JobConditionBuilder(java.lang.Boolean validationEnabled) {
        this(new JobCondition(), validationEnabled);
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JobCondition(), validationEnabled);
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance) {
        this(fluent, instance, true);
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastProbeTime(instance.getLastProbeTime()); 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance) {
        this(instance,true);
    }

    public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastProbeTime(instance.getLastProbeTime()); 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.batch.v1.JobCondition build() {
        JobCondition buildable = new JobCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JobConditionBuilder that = (JobConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
