package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodFailurePolicyBuilder extends PodFailurePolicyFluentImpl<PodFailurePolicyBuilder> implements VisitableBuilder<PodFailurePolicy,PodFailurePolicyBuilder>{
  public PodFailurePolicyBuilder() {
    this(false);
  }
  public PodFailurePolicyBuilder(Boolean validationEnabled) {
    this(new PodFailurePolicy(), validationEnabled);
  }
  public PodFailurePolicyBuilder(PodFailurePolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public PodFailurePolicyBuilder(PodFailurePolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodFailurePolicy(), validationEnabled);
  }
  public PodFailurePolicyBuilder(PodFailurePolicyFluent<?> fluent,PodFailurePolicy instance) {
    this(fluent, instance, false);
  }
  public PodFailurePolicyBuilder(PodFailurePolicyFluent<?> fluent,PodFailurePolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRules(instance.getRules()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodFailurePolicyBuilder(PodFailurePolicy instance) {
    this(instance,false);
  }
  public PodFailurePolicyBuilder(PodFailurePolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRules(instance.getRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodFailurePolicyFluent<?> fluent;
  Boolean validationEnabled;
  public PodFailurePolicy build() {
    PodFailurePolicy buildable = new PodFailurePolicy(fluent.getRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}