package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodFailurePolicyRuleFluentImpl<A extends PodFailurePolicyRuleFluent<A>> extends BaseFluent<A> implements PodFailurePolicyRuleFluent<A>{
  public PodFailurePolicyRuleFluentImpl() {
  }
  public PodFailurePolicyRuleFluentImpl(PodFailurePolicyRule instance) {
    this.withAction(instance.getAction()); 
    this.withOnExitCodes(instance.getOnExitCodes()); 
    this.withOnPodConditions(instance.getOnPodConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String action;
  private PodFailurePolicyOnExitCodesRequirementBuilder onExitCodes;
  private ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder> onPodConditions = new ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder>();
  private Map<String,Object> additionalProperties;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOnExitCodes instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodFailurePolicyOnExitCodesRequirement getOnExitCodes() {
    return this.onExitCodes!=null ?this.onExitCodes.build():null;
  }
  public PodFailurePolicyOnExitCodesRequirement buildOnExitCodes() {
    return this.onExitCodes!=null ?this.onExitCodes.build():null;
  }
  public A withOnExitCodes(PodFailurePolicyOnExitCodesRequirement onExitCodes) {
    _visitables.get("onExitCodes").remove(this.onExitCodes);
    if (onExitCodes!=null){ this.onExitCodes= new PodFailurePolicyOnExitCodesRequirementBuilder(onExitCodes); _visitables.get("onExitCodes").add(this.onExitCodes);} else { this.onExitCodes = null; _visitables.get("onExitCodes").remove(this.onExitCodes); } return (A) this;
  }
  public Boolean hasOnExitCodes() {
    return this.onExitCodes != null;
  }
  public PodFailurePolicyRuleFluent.OnExitCodesNested<A> withNewOnExitCodes() {
    return new PodFailurePolicyRuleFluentImpl.OnExitCodesNestedImpl();
  }
  public PodFailurePolicyRuleFluent.OnExitCodesNested<A> withNewOnExitCodesLike(PodFailurePolicyOnExitCodesRequirement item) {
    return new PodFailurePolicyRuleFluentImpl.OnExitCodesNestedImpl(item);
  }
  public PodFailurePolicyRuleFluent.OnExitCodesNested<A> editOnExitCodes() {
    return withNewOnExitCodesLike(getOnExitCodes());
  }
  public PodFailurePolicyRuleFluent.OnExitCodesNested<A> editOrNewOnExitCodes() {
    return withNewOnExitCodesLike(getOnExitCodes() != null ? getOnExitCodes(): new PodFailurePolicyOnExitCodesRequirementBuilder().build());
  }
  public PodFailurePolicyRuleFluent.OnExitCodesNested<A> editOrNewOnExitCodesLike(PodFailurePolicyOnExitCodesRequirement item) {
    return withNewOnExitCodesLike(getOnExitCodes() != null ? getOnExitCodes(): item);
  }
  public A addToOnPodConditions(Integer index,PodFailurePolicyOnPodConditionsPattern item) {
    if (this.onPodConditions == null) {this.onPodConditions = new ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder>();}
    PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);_visitables.get("onPodConditions").add(index >= 0 ? index : _visitables.get("onPodConditions").size(), builder);this.onPodConditions.add(index >= 0 ? index : onPodConditions.size(), builder); return (A)this;
  }
  public A setToOnPodConditions(Integer index,PodFailurePolicyOnPodConditionsPattern item) {
    if (this.onPodConditions == null) {this.onPodConditions = new ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder>();}
    PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);
    if (index < 0 || index >= _visitables.get("onPodConditions").size()) { _visitables.get("onPodConditions").add(builder); } else { _visitables.get("onPodConditions").set(index, builder);}
    if (index < 0 || index >= onPodConditions.size()) { onPodConditions.add(builder); } else { onPodConditions.set(index, builder);}
     return (A)this;
  }
  public A addToOnPodConditions(io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyOnPodConditionsPattern... items) {
    if (this.onPodConditions == null) {this.onPodConditions = new ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder>();}
    for (PodFailurePolicyOnPodConditionsPattern item : items) {PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);_visitables.get("onPodConditions").add(builder);this.onPodConditions.add(builder);} return (A)this;
  }
  public A addAllToOnPodConditions(Collection<PodFailurePolicyOnPodConditionsPattern> items) {
    if (this.onPodConditions == null) {this.onPodConditions = new ArrayList<PodFailurePolicyOnPodConditionsPatternBuilder>();}
    for (PodFailurePolicyOnPodConditionsPattern item : items) {PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);_visitables.get("onPodConditions").add(builder);this.onPodConditions.add(builder);} return (A)this;
  }
  public A removeFromOnPodConditions(io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyOnPodConditionsPattern... items) {
    for (PodFailurePolicyOnPodConditionsPattern item : items) {PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);_visitables.get("onPodConditions").remove(builder);if (this.onPodConditions != null) {this.onPodConditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromOnPodConditions(Collection<PodFailurePolicyOnPodConditionsPattern> items) {
    for (PodFailurePolicyOnPodConditionsPattern item : items) {PodFailurePolicyOnPodConditionsPatternBuilder builder = new PodFailurePolicyOnPodConditionsPatternBuilder(item);_visitables.get("onPodConditions").remove(builder);if (this.onPodConditions != null) {this.onPodConditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromOnPodConditions(Predicate<PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
    if (onPodConditions == null) return (A) this;
    final Iterator<PodFailurePolicyOnPodConditionsPatternBuilder> each = onPodConditions.iterator();
    final List visitables = _visitables.get("onPodConditions");
    while (each.hasNext()) {
      PodFailurePolicyOnPodConditionsPatternBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildOnPodConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodFailurePolicyOnPodConditionsPattern> getOnPodConditions() {
    return onPodConditions != null ? build(onPodConditions) : null;
  }
  public List<PodFailurePolicyOnPodConditionsPattern> buildOnPodConditions() {
    return onPodConditions != null ? build(onPodConditions) : null;
  }
  public PodFailurePolicyOnPodConditionsPattern buildOnPodCondition(Integer index) {
    return this.onPodConditions.get(index).build();
  }
  public PodFailurePolicyOnPodConditionsPattern buildFirstOnPodCondition() {
    return this.onPodConditions.get(0).build();
  }
  public PodFailurePolicyOnPodConditionsPattern buildLastOnPodCondition() {
    return this.onPodConditions.get(onPodConditions.size() - 1).build();
  }
  public PodFailurePolicyOnPodConditionsPattern buildMatchingOnPodCondition(Predicate<PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
    for (PodFailurePolicyOnPodConditionsPatternBuilder item: onPodConditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingOnPodCondition(Predicate<PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
    for (PodFailurePolicyOnPodConditionsPatternBuilder item: onPodConditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOnPodConditions(List<PodFailurePolicyOnPodConditionsPattern> onPodConditions) {
    if (this.onPodConditions != null) { _visitables.get("onPodConditions").removeAll(this.onPodConditions);}
    if (onPodConditions != null) {this.onPodConditions = new ArrayList(); for (PodFailurePolicyOnPodConditionsPattern item : onPodConditions){this.addToOnPodConditions(item);}} else { this.onPodConditions = null;} return (A) this;
  }
  public A withOnPodConditions(io.fabric8.kubernetes.api.model.batch.v1.PodFailurePolicyOnPodConditionsPattern... onPodConditions) {
    if (this.onPodConditions != null) {this.onPodConditions.clear();}
    if (onPodConditions != null) {for (PodFailurePolicyOnPodConditionsPattern item :onPodConditions){ this.addToOnPodConditions(item);}} return (A) this;
  }
  public Boolean hasOnPodConditions() {
    return onPodConditions != null && !onPodConditions.isEmpty();
  }
  public A addNewOnPodCondition(String status,String type) {
    return (A)addToOnPodConditions(new PodFailurePolicyOnPodConditionsPattern(status, type));
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> addNewOnPodCondition() {
    return new PodFailurePolicyRuleFluentImpl.OnPodConditionsNestedImpl();
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> addNewOnPodConditionLike(PodFailurePolicyOnPodConditionsPattern item) {
    return new PodFailurePolicyRuleFluentImpl.OnPodConditionsNestedImpl(-1, item);
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> setNewOnPodConditionLike(Integer index,PodFailurePolicyOnPodConditionsPattern item) {
    return new PodFailurePolicyRuleFluentImpl.OnPodConditionsNestedImpl(index, item);
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> editOnPodCondition(Integer index) {
    if (onPodConditions.size() <= index) throw new RuntimeException("Can't edit onPodConditions. Index exceeds size.");
    return setNewOnPodConditionLike(index, buildOnPodCondition(index));
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> editFirstOnPodCondition() {
    if (onPodConditions.size() == 0) throw new RuntimeException("Can't edit first onPodConditions. The list is empty.");
    return setNewOnPodConditionLike(0, buildOnPodCondition(0));
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> editLastOnPodCondition() {
    int index = onPodConditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last onPodConditions. The list is empty.");
    return setNewOnPodConditionLike(index, buildOnPodCondition(index));
  }
  public PodFailurePolicyRuleFluent.OnPodConditionsNested<A> editMatchingOnPodCondition(Predicate<PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
    int index = -1;
    for (int i=0;i<onPodConditions.size();i++) { 
    if (predicate.test(onPodConditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching onPodConditions. No match found.");
    return setNewOnPodConditionLike(index, buildOnPodCondition(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodFailurePolicyRuleFluentImpl that = (PodFailurePolicyRuleFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (onExitCodes != null ? !onExitCodes.equals(that.onExitCodes) :that.onExitCodes != null) return false;
    if (onPodConditions != null ? !onPodConditions.equals(that.onPodConditions) :that.onPodConditions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  onExitCodes,  onPodConditions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (onExitCodes != null) { sb.append("onExitCodes:"); sb.append(onExitCodes + ","); }
    if (onPodConditions != null && !onPodConditions.isEmpty()) { sb.append("onPodConditions:"); sb.append(onPodConditions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class OnExitCodesNestedImpl<N> extends PodFailurePolicyOnExitCodesRequirementFluentImpl<PodFailurePolicyRuleFluent.OnExitCodesNested<N>> implements PodFailurePolicyRuleFluent.OnExitCodesNested<N>,Nested<N>{
    OnExitCodesNestedImpl(PodFailurePolicyOnExitCodesRequirement item) {
      this.builder = new PodFailurePolicyOnExitCodesRequirementBuilder(this, item);
    }
    OnExitCodesNestedImpl() {
      this.builder = new PodFailurePolicyOnExitCodesRequirementBuilder(this);
    }
    PodFailurePolicyOnExitCodesRequirementBuilder builder;
    public N and() {
      return (N) PodFailurePolicyRuleFluentImpl.this.withOnExitCodes(builder.build());
    }
    public N endOnExitCodes() {
      return and();
    }
    
  }
  class OnPodConditionsNestedImpl<N> extends PodFailurePolicyOnPodConditionsPatternFluentImpl<PodFailurePolicyRuleFluent.OnPodConditionsNested<N>> implements PodFailurePolicyRuleFluent.OnPodConditionsNested<N>,Nested<N>{
    OnPodConditionsNestedImpl(Integer index,PodFailurePolicyOnPodConditionsPattern item) {
      this.index = index;
      this.builder = new PodFailurePolicyOnPodConditionsPatternBuilder(this, item);
    }
    OnPodConditionsNestedImpl() {
      this.index = -1;
      this.builder = new PodFailurePolicyOnPodConditionsPatternBuilder(this);
    }
    PodFailurePolicyOnPodConditionsPatternBuilder builder;
    Integer index;
    public N and() {
      return (N) PodFailurePolicyRuleFluentImpl.this.setToOnPodConditions(index,builder.build());
    }
    public N endOnPodCondition() {
      return and();
    }
    
  }
  
}