package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JobSpecFluentImpl<A extends JobSpecFluent<A>> extends BaseFluent<A> implements JobSpecFluent<A>{
  public JobSpecFluentImpl() {
  }
  public JobSpecFluentImpl(JobSpec instance) {
    if (instance != null) {
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withBackoffLimit(instance.getBackoffLimit());
      this.withCompletionMode(instance.getCompletionMode());
      this.withCompletions(instance.getCompletions());
      this.withManualSelector(instance.getManualSelector());
      this.withParallelism(instance.getParallelism());
      this.withPodFailurePolicy(instance.getPodFailurePolicy());
      this.withSelector(instance.getSelector());
      this.withSuspend(instance.getSuspend());
      this.withTemplate(instance.getTemplate());
      this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Long activeDeadlineSeconds;
  private Integer backoffLimit;
  private String completionMode;
  private Integer completions;
  private Boolean manualSelector;
  private Integer parallelism;
  private PodFailurePolicyBuilder podFailurePolicy;
  private LabelSelectorBuilder selector;
  private Boolean suspend;
  private PodTemplateSpecBuilder template;
  private Integer ttlSecondsAfterFinished;
  private Map<String,Object> additionalProperties;
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public Integer getBackoffLimit() {
    return this.backoffLimit;
  }
  public A withBackoffLimit(Integer backoffLimit) {
    this.backoffLimit=backoffLimit; return (A) this;
  }
  public Boolean hasBackoffLimit() {
    return this.backoffLimit != null;
  }
  public String getCompletionMode() {
    return this.completionMode;
  }
  public A withCompletionMode(String completionMode) {
    this.completionMode=completionMode; return (A) this;
  }
  public Boolean hasCompletionMode() {
    return this.completionMode != null;
  }
  public Integer getCompletions() {
    return this.completions;
  }
  public A withCompletions(Integer completions) {
    this.completions=completions; return (A) this;
  }
  public Boolean hasCompletions() {
    return this.completions != null;
  }
  public Boolean getManualSelector() {
    return this.manualSelector;
  }
  public A withManualSelector(Boolean manualSelector) {
    this.manualSelector=manualSelector; return (A) this;
  }
  public Boolean hasManualSelector() {
    return this.manualSelector != null;
  }
  public Integer getParallelism() {
    return this.parallelism;
  }
  public A withParallelism(Integer parallelism) {
    this.parallelism=parallelism; return (A) this;
  }
  public Boolean hasParallelism() {
    return this.parallelism != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPodFailurePolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodFailurePolicy getPodFailurePolicy() {
    return this.podFailurePolicy!=null ?this.podFailurePolicy.build():null;
  }
  public PodFailurePolicy buildPodFailurePolicy() {
    return this.podFailurePolicy!=null ?this.podFailurePolicy.build():null;
  }
  public A withPodFailurePolicy(PodFailurePolicy podFailurePolicy) {
    _visitables.get("podFailurePolicy").remove(this.podFailurePolicy);
    if (podFailurePolicy!=null){ this.podFailurePolicy= new PodFailurePolicyBuilder(podFailurePolicy); _visitables.get("podFailurePolicy").add(this.podFailurePolicy);} else { this.podFailurePolicy = null; _visitables.get("podFailurePolicy").remove(this.podFailurePolicy); } return (A) this;
  }
  public Boolean hasPodFailurePolicy() {
    return this.podFailurePolicy != null;
  }
  public JobSpecFluentImpl.PodFailurePolicyNested<A> withNewPodFailurePolicy() {
    return new JobSpecFluentImpl.PodFailurePolicyNestedImpl();
  }
  public JobSpecFluentImpl.PodFailurePolicyNested<A> withNewPodFailurePolicyLike(PodFailurePolicy item) {
    return new JobSpecFluentImpl.PodFailurePolicyNestedImpl(item);
  }
  public JobSpecFluentImpl.PodFailurePolicyNested<A> editPodFailurePolicy() {
    return withNewPodFailurePolicyLike(getPodFailurePolicy());
  }
  public JobSpecFluentImpl.PodFailurePolicyNested<A> editOrNewPodFailurePolicy() {
    return withNewPodFailurePolicyLike(getPodFailurePolicy() != null ? getPodFailurePolicy(): new PodFailurePolicyBuilder().build());
  }
  public JobSpecFluentImpl.PodFailurePolicyNested<A> editOrNewPodFailurePolicyLike(PodFailurePolicy item) {
    return withNewPodFailurePolicyLike(getPodFailurePolicy() != null ? getPodFailurePolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public JobSpecFluentImpl.SelectorNested<A> withNewSelector() {
    return new JobSpecFluentImpl.SelectorNestedImpl();
  }
  public JobSpecFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new JobSpecFluentImpl.SelectorNestedImpl(item);
  }
  public JobSpecFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public JobSpecFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public JobSpecFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public Boolean getSuspend() {
    return this.suspend;
  }
  public A withSuspend(Boolean suspend) {
    this.suspend=suspend; return (A) this;
  }
  public Boolean hasSuspend() {
    return this.suspend != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public JobSpecFluentImpl.TemplateNested<A> withNewTemplate() {
    return new JobSpecFluentImpl.TemplateNestedImpl();
  }
  public JobSpecFluentImpl.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new JobSpecFluentImpl.TemplateNestedImpl(item);
  }
  public JobSpecFluentImpl.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public JobSpecFluentImpl.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
  }
  public JobSpecFluentImpl.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public Integer getTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished;
  }
  public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
    this.ttlSecondsAfterFinished=ttlSecondsAfterFinished; return (A) this;
  }
  public Boolean hasTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobSpecFluentImpl that = (JobSpecFluentImpl) o;
    if (!java.util.Objects.equals(activeDeadlineSeconds, that.activeDeadlineSeconds)) return false;

    if (!java.util.Objects.equals(backoffLimit, that.backoffLimit)) return false;

    if (!java.util.Objects.equals(completionMode, that.completionMode)) return false;

    if (!java.util.Objects.equals(completions, that.completions)) return false;

    if (!java.util.Objects.equals(manualSelector, that.manualSelector)) return false;

    if (!java.util.Objects.equals(parallelism, that.parallelism)) return false;

    if (!java.util.Objects.equals(podFailurePolicy, that.podFailurePolicy)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(suspend, that.suspend)) return false;

    if (!java.util.Objects.equals(template, that.template)) return false;

    if (!java.util.Objects.equals(ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  backoffLimit,  completionMode,  completions,  manualSelector,  parallelism,  podFailurePolicy,  selector,  suspend,  template,  ttlSecondsAfterFinished,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (backoffLimit != null) { sb.append("backoffLimit:"); sb.append(backoffLimit + ","); }
    if (completionMode != null) { sb.append("completionMode:"); sb.append(completionMode + ","); }
    if (completions != null) { sb.append("completions:"); sb.append(completions + ","); }
    if (manualSelector != null) { sb.append("manualSelector:"); sb.append(manualSelector + ","); }
    if (parallelism != null) { sb.append("parallelism:"); sb.append(parallelism + ","); }
    if (podFailurePolicy != null) { sb.append("podFailurePolicy:"); sb.append(podFailurePolicy + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (suspend != null) { sb.append("suspend:"); sb.append(suspend + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (ttlSecondsAfterFinished != null) { sb.append("ttlSecondsAfterFinished:"); sb.append(ttlSecondsAfterFinished + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withManualSelector() {
    return withManualSelector(true);
  }
  public A withSuspend() {
    return withSuspend(true);
  }
  class PodFailurePolicyNestedImpl<N> extends PodFailurePolicyFluentImpl<JobSpecFluentImpl.PodFailurePolicyNested<N>> implements JobSpecFluentImpl.PodFailurePolicyNested<N>,Nested<N>{
    PodFailurePolicyNestedImpl(PodFailurePolicy item) {
      this.builder = new PodFailurePolicyBuilder(this, item);
    }
    PodFailurePolicyNestedImpl() {
      this.builder = new PodFailurePolicyBuilder(this);
    }
    PodFailurePolicyBuilder builder;
    public N and() {
      return (N) JobSpecFluentImpl.this.withPodFailurePolicy(builder.build());
    }
    public N endPodFailurePolicy() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<JobSpecFluentImpl.SelectorNested<N>> implements JobSpecFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) JobSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<JobSpecFluentImpl.TemplateNested<N>> implements JobSpecFluentImpl.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) JobSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}