package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class LeaseBuilder extends io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluentImpl<io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.coordination.v1.Lease,io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder>{
  public LeaseBuilder() {
    this(false);
  }
  public LeaseBuilder(java.lang.Boolean validationEnabled) {
    this(new Lease(), validationEnabled);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent) {
    this(fluent, false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Lease(), validationEnabled);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.Lease instance) {
    this(fluent, instance, false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent,io.fabric8.kubernetes.api.model.coordination.v1.Lease instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.Lease instance) {
    this(instance,false);
  }
  public LeaseBuilder(io.fabric8.kubernetes.api.model.coordination.v1.Lease instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.coordination.v1.Lease build() {
    Lease buildable = new Lease(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LeaseBuilder that = (LeaseBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}