package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface APIGroupListFluent<A extends APIGroupListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToGroups(int index,APIGroup item);
    public A setToGroups(int index,APIGroup item);
    public A addToGroups(APIGroup... items);
    public A addAllToGroups(Collection<APIGroup> items);
    public A removeFromGroups(APIGroup... items);
    public A removeAllFromGroups(Collection<APIGroup> items);
    public A removeMatchingFromGroups(io.fabric8.kubernetes.api.builder.Predicate<APIGroupBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGroups instead.
 * @return The buildable object.
 */
@Deprecated public List<APIGroup> getGroups();
    public List<APIGroup> buildGroups();
    public APIGroup buildGroup(int index);
    public APIGroup buildFirstGroup();
    public APIGroup buildLastGroup();
    public APIGroup buildMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<APIGroupBuilder> predicate);
    public Boolean hasMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<APIGroupBuilder> predicate);
    public A withGroups(List<APIGroup> groups);
    public A withGroups(APIGroup... groups);
    public Boolean hasGroups();
    public APIGroupListFluent.GroupsNested<A> addNewGroup();
    public APIGroupListFluent.GroupsNested<A> addNewGroupLike(APIGroup item);
    public APIGroupListFluent.GroupsNested<A> setNewGroupLike(int index,APIGroup item);
    public APIGroupListFluent.GroupsNested<A> editGroup(int index);
    public APIGroupListFluent.GroupsNested<A> editFirstGroup();
    public APIGroupListFluent.GroupsNested<A> editLastGroup();
    public APIGroupListFluent.GroupsNested<A> editMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<APIGroupBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);

    public interface GroupsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIGroupFluent<APIGroupListFluent.GroupsNested<N>>{

        
    public N and();    public N endGroup();
}


}
